/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.common.rdf;

import com.ontotext.soaas.common.rdf.AbstractRdfTree;
import com.ontotext.soaas.common.rdf.DistinctLongList;
import com.ontotext.soaas.common.rdf.EclipseRdfData;
import com.ontotext.soaas.common.rdf.EntityPool;
import com.ontotext.soaas.common.rdf.EntityPoolFactory;
import com.ontotext.soaas.common.rdf.RdfData;
import com.ontotext.soaas.common.rdf.RdfPath;
import com.ontotext.soaas.common.rdf.RdfTree;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import java.util.function.LongPredicate;
import java.util.stream.LongStream;
import java.util.stream.StreamSupport;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.block.function.primitive.LongToLongFunction;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.iterator.MutableLongIterator;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.map.primitive.LongObjectMap;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.api.set.primitive.ImmutableLongSet;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.tuple.primitive.LongObjectPair;
import org.eclipse.collections.impl.factory.primitive.LongObjectMaps;
import org.eclipse.collections.impl.factory.primitive.LongSets;

public class EclipseRdfTree
extends AbstractRdfTree<EclipseRdfData>
implements RdfTree {
    public EclipseRdfTree() {
        this(EntityPoolFactory.eclipse());
    }

    public EclipseRdfTree(EntityPool pool) {
        super(pool);
    }

    public EclipseRdfTree(RdfTree copyFrom) {
        super(copyFrom);
    }

    public EclipseRdfTree(RdfData rdfData) {
        super(rdfData);
    }

    public EclipseRdfTree(RdfData rdfData, List<RdfPath> rootResults) {
        super(rdfData, rootResults);
    }

    @Override
    protected EclipseNode createNode(long parentSubject, long parentPredicate, AbstractRdfTree.Node parent) {
        return new EclipseNode(parentSubject, parentPredicate, parent);
    }

    @Override
    protected void addRootPath(RdfData rdfData, RdfPath parentPath) {
        this.iterateDataMap(rdfData, parentPath, LongSets.mutable.empty());
    }

    private void iterateDataMap(RdfData rdfData, RdfPath parentPath, MutableLongSet visited) {
        long subject = parentPath.tail().getObject();
        LongObjectMap<LongList> predicateMap = ((EclipseRdfData)rdfData).get(subject);
        if (predicateMap == null) {
            return;
        }
        if (!predicateMap.isEmpty()) {
            if (visited.contains(subject)) {
                return;
            }
            visited.add(subject);
        }
        for (LongObjectPair predicateValue : predicateMap.keyValuesView()) {
            long predicate = predicateValue.getOne();
            LongIterator longIterator = ((LongList)predicateValue.getTwo()).longIterator();
            while (longIterator.hasNext()) {
                RdfPath addedPath = this.add(parentPath, predicate, longIterator.next());
                this.iterateDataMap(rdfData, addedPath, visited);
            }
        }
    }

    @Override
    public void merge(RdfTree added) {
        if (added.isEmpty()) {
            return;
        }
        LongStream resultIris = added.getResultIris(null).stream().mapToLong(this.getPool()::resolve);
        ImmutableLongSet results = LongSets.immutable.ofAll(resultIris);
        MutableLongObjectMap knownPaths = LongObjectMaps.mutable.empty();
        this.forEachPath(arg_0 -> EclipseRdfTree.lambda$merge$0((LongSet)results, knownPaths, arg_0));
        LongToLongFunction & Serializable valueConverter = this.getPool() == added.getPool() ? (LongToLongFunction & Serializable)longParameter -> longParameter : (LongToLongFunction & Serializable)longParameter -> this.toLocal(longParameter, added.getPool());
        added.forEachPath(path -> {
            if (path.depth() > 1) {
                RdfPath head = path.head();
                long objectId = valueConverter.valueOf(head.getObject());
                List rdfPaths = (List)knownPaths.getIfAbsent(objectId, Collections::emptyList);
                for (RdfPath rdfPath : rdfPaths) {
                    this.add(rdfPath.append(this.getPool().toLocalPath(head.next().trimHead())));
                }
            }
        });
    }

    private static /* synthetic */ void lambda$merge$0(LongSet results, MutableLongObjectMap knownPaths, RdfPath path) {
        long lastValue = path.tail().getObject();
        if (results.contains(lastValue)) {
            ((List)knownPaths.getIfAbsentPut(lastValue, LinkedList::new)).add(path);
        }
    }

    private class EclipseNode
    extends AbstractRdfTree.Node {
        private MutableLongList values;

        EclipseNode(long parentSubject, long parentPredicate, AbstractRdfTree.Node parent) {
            super(EclipseRdfTree.this, parentSubject, parentPredicate, parent);
        }

        @Override
        protected void acceptValue(long value) {
            this.getValues().add(value);
        }

        @Override
        protected void forEachValue(LongConsumer consumer) {
            if (this.values == null) {
                return;
            }
            this.values.forEach(consumer::accept);
        }

        @Override
        protected void forEachValue(LongPredicate filter, LongConsumer consumer) {
            long value;
            if (this.values == null) {
                return;
            }
            MutableLongIterator iterator = this.values.longIterator();
            while (iterator.hasNext() && filter.test(value = iterator.next())) {
                consumer.accept(value);
            }
        }

        @Override
        protected LongStream streamValues() {
            if (this.values == null) {
                return LongStream.empty();
            }
            return StreamSupport.longStream(new LongSpliterator((LongIterable)this.values), false);
        }

        @Override
        protected boolean hasValue(long object) {
            if (this.values == null) {
                return false;
            }
            return this.values.contains(object);
        }

        @Override
        protected boolean hasValues() {
            return this.values != null && !this.values.isEmpty();
        }

        @Override
        protected void clearValues() {
            if (this.values != null) {
                this.values.clear();
            }
        }

        @Override
        protected boolean removeValue(long value) {
            if (this.values == null) {
                return false;
            }
            return this.values.remove(value);
        }

        private MutableLongList getValues() {
            if (this.values == null) {
                this.values = new DistinctLongList(EclipseRdfTree.this.valueCollectionSize);
            }
            return this.values;
        }

        @Override
        protected void traversePredicate(RdfPath parent, Consumer<RdfPath> pathConsumer, Long2ObjectMap<it.unimi.dsi.fastutil.longs.LongSet> subjPredicates, long subject, long predicate, AbstractRdfTree.Node node) {
            ((it.unimi.dsi.fastutil.longs.LongSet)subjPredicates.computeIfAbsent(subject, key -> new LongLinkedOpenHashSet())).add(predicate);
            MutableLongIterator it = ((EclipseNode)node).getValues().longIterator();
            while (it.hasNext()) {
                this.traverseNextValueNode(node, parent, subject, predicate, it.next(), pathConsumer);
            }
        }

        @Override
        protected void listValues(RdfPath parent, Consumer<RdfPath> pathConsumer, long subject, LongPredicate isPredicateAllowed) {
            LongObjectMap<LongList> predicateValuesPair = ((EclipseRdfData)EclipseRdfTree.this.getIndexData()).get(subject);
            for (LongObjectPair predicateValues : predicateValuesPair.keyValuesView()) {
                long predicate = predicateValues.getOne();
                if (!isPredicateAllowed.test(predicate)) continue;
                LongIterator iterator = ((LongList)predicateValues.getTwo()).longIterator();
                while (iterator.hasNext()) {
                    RdfPath path = this.createOrAppend(parent, subject, predicate, iterator.next());
                    pathConsumer.accept(path);
                }
            }
        }
    }

    private static class LongSpliterator
    extends Spliterators.AbstractLongSpliterator {
        private final LongIterator iterator;

        protected LongSpliterator(LongIterator iterator, long est, int additionalCharacteristics) {
            super(est, additionalCharacteristics);
            this.iterator = iterator;
        }

        public LongSpliterator(LongIterable iterable) {
            this(iterable.longIterator(), iterable.size(), 80);
        }

        @Override
        public boolean tryAdvance(LongConsumer action) {
            if (this.iterator.hasNext()) {
                action.accept(this.iterator.next());
                return true;
            }
            return false;
        }
    }
}

