/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.common.rdf;

import com.ontotext.soaas.common.rdf.AbstractRdfData;
import com.ontotext.soaas.common.rdf.DistinctLongList;
import com.ontotext.soaas.common.rdf.EclipseRdfTree;
import com.ontotext.soaas.common.rdf.EntityPool;
import com.ontotext.soaas.common.rdf.EntityPoolFactory;
import com.ontotext.soaas.common.rdf.LongLongLongPredicate;
import com.ontotext.soaas.common.rdf.OrderedLongObjectMap;
import com.ontotext.soaas.common.rdf.RdfData;
import com.ontotext.soaas.common.rdf.RdfTree;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.LongPredicate;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.block.procedure.primitive.LongObjectProcedure;
import org.eclipse.collections.api.factory.map.primitive.MutableLongObjectMapFactory;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.iterator.MutableLongIterator;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.map.primitive.LongObjectMap;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.api.tuple.primitive.LongObjectPair;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.eclipse.collections.impl.factory.primitive.LongObjectMaps;

public class EclipseRdfData
extends AbstractRdfData
implements RdfData {
    private MutableLongObjectMap<MutableLongObjectMap<MutableLongList>> data = new OrderedLongObjectMap();

    public EclipseRdfData() {
        this(EntityPoolFactory.eclipse());
    }

    public EclipseRdfData(EntityPool pool) {
        super(pool);
    }

    @Override
    public int add(long subject, long predicate, long object) {
        MutableLongList objects = (MutableLongList)((MutableLongObjectMap)this.data.getIfAbsentPut(subject, OrderedLongObjectMap::new)).getIfAbsentPut(predicate, DistinctLongList::new);
        objects.add(object);
        return objects.size();
    }

    @Override
    public boolean remove(long subject, long predicate, long object) {
        MutableLongList objects = (MutableLongList)((MutableLongObjectMap)this.data.getIfAbsent(subject, () -> ((MutableLongObjectMapFactory)LongObjectMaps.mutable).empty())).getIfAbsent(predicate, DistinctLongList::new);
        if (objects.isEmpty()) {
            this.removeSubjectAndPredicateIfNeeded(subject, predicate);
            return false;
        }
        boolean removed = objects.remove(object);
        if (objects.isEmpty()) {
            this.removeSubjectAndPredicateIfNeeded(subject, predicate);
        }
        return removed;
    }

    private void removeSubjectAndPredicateIfNeeded(long subject, long predicate) {
        LongObjectMap<LongList> subjectMapping = this.get(subject);
        if (subjectMapping.isEmpty()) {
            this.data.remove(subject);
        } else {
            ((MutableLongObjectMap)subjectMapping).remove(predicate);
            if (subjectMapping.isEmpty()) {
                this.data.remove(subject);
            }
        }
    }

    @Override
    public Map<String, Collection<Object>> get(String subject) {
        MutableLongObjectMap predicateValues = (MutableLongObjectMap)this.data.get(this.pool.resolve(subject));
        if (predicateValues == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Collection<Object>> result = new LinkedHashMap<String, Collection<Object>>(predicateValues.size());
        predicateValues.forEachKeyValue((LongObjectProcedure & Serializable)(key, values) -> result.put(this.pool.getString(key), this.convert((LongIterable)values)));
        return result;
    }

    @Override
    public Collection<Object> get(String subject, String predicate) {
        MutableLongObjectMap predicateValues = (MutableLongObjectMap)this.data.get(this.pool.resolve(subject));
        if (predicateValues == null) {
            return Collections.emptyList();
        }
        return this.convert((LongIterable)predicateValues.get(this.pool.resolve(predicate)));
    }

    protected LongObjectMap<LongList> get(long subject) {
        return this.fakeCast((LongObjectMap)this.data.getIfAbsent(subject, () -> ((MutableLongObjectMapFactory)LongObjectMaps.mutable).empty()));
    }

    protected LongList get(long subject, long predicate) {
        MutableLongObjectMap predicateValues = (MutableLongObjectMap)this.data.get(subject);
        if (predicateValues == null) {
            return LongLists.immutable.empty();
        }
        return (LongList)predicateValues.getIfAbsent(predicate, DistinctLongList::new);
    }

    private List<Object> convert(LongIterable iterable) {
        if (iterable == null) {
            return new ArrayList<Object>(0);
        }
        return iterable.collect(this.pool::get).toList();
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public RdfTree toTree() {
        return new EclipseRdfTree(this);
    }

    @Override
    protected void filterByKnownPredicate(LongLongLongPredicate resultTriples, long subject, long predicate, long object) {
        LongList objects = this.get(subject, predicate);
        if (object != 0L) {
            if (this.matchObjectValue(object, objects)) {
                resultTriples.test(subject, predicate, object);
            }
        } else if (objects != null) {
            this.appendValues(resultTriples, subject, predicate, (LongIterable)objects);
        }
    }

    @Override
    protected void filterByAnyPredicate(LongLongLongPredicate resultTriples, long subject, long object) {
        if (object != 0L) {
            for (LongObjectPair entry : this.get(subject).keyValuesView()) {
                long pred = entry.getOne();
                if (!this.matchObjectValue(object, (LongList)entry.getTwo()) || resultTriples.test(subject, pred, object)) continue;
                return;
            }
        } else {
            for (LongObjectPair entry : this.get(subject).keyValuesView()) {
                long pred = entry.getOne();
                this.appendValues(resultTriples, subject, pred, (LongIterable)entry.getTwo());
            }
        }
    }

    @Override
    protected void filterByObjectTest(LongLongLongPredicate resultTriples, LongPredicate objectTest) {
        for (LongObjectPair perSubject : this.data.keyValuesView()) {
            long subj = perSubject.getOne();
            for (LongObjectPair perPredicate : ((MutableLongObjectMap)perSubject.getTwo()).keyValuesView()) {
                long value;
                long pred = perPredicate.getOne();
                MutableLongIterator valuesIt = ((MutableLongList)perPredicate.getTwo()).longIterator();
                while (valuesIt.hasNext() && objectTest.test(value = valuesIt.next())) {
                    if (resultTriples.test(subj, pred, value)) continue;
                    return;
                }
            }
        }
    }

    @Override
    protected void filterByPredicate(LongLongLongPredicate resultTriples, long predicate, long object) {
        for (LongObjectPair entry : this.data.keyValuesView()) {
            long subject = entry.getOne();
            MutableLongList values = (MutableLongList)((MutableLongObjectMap)entry.getTwo()).get(predicate);
            if (object != 0L) {
                if (!this.matchObjectValue(object, (LongList)values) || resultTriples.test(subject, predicate, object)) continue;
                return;
            }
            this.appendValues(resultTriples, subject, predicate, (LongIterable)values);
        }
    }

    private void appendValues(LongLongLongPredicate resultTriples, long subject, long predicate, LongIterable values) {
        if (values == null) {
            return;
        }
        LongIterator iterator = values.longIterator();
        while (iterator.hasNext()) {
            if (resultTriples.test(subject, predicate, iterator.next())) continue;
            return;
        }
    }

    private boolean matchObjectValue(long object, LongList objects) {
        return objects != null && objects.contains(object);
    }

    private LongObjectMap fakeCast(LongObjectMap map) {
        return map;
    }
}

