/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.common.concurrent;

import com.ontotext.soaas.common.concurrent.Timer;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class MonitoredOperationInfo {
    private final String operation;
    private final String id;
    private final Timer timer;
    private final Integer count;
    private final String thread;
    private final Supplier<List<MonitoredOperationInfo>> subOperations;

    public MonitoredOperationInfo(String op, String id, Timer timer, Integer count, String thread) {
        this(op, id, timer, count, thread, () -> null);
    }

    public MonitoredOperationInfo(String op, String id, Timer timer, Integer count, String thread, Supplier<List<MonitoredOperationInfo>> subOperations) {
        this.operation = op;
        this.id = id;
        this.timer = Objects.requireNonNull(timer, "Timer instance should not be null");
        this.count = count;
        this.thread = thread;
        this.subOperations = subOperations;
    }

    public String getOperation() {
        return this.operation;
    }

    public String getId() {
        return this.id;
    }

    public long getDuration() {
        return this.timer.getDuration();
    }

    public Integer getCount() {
        return this.count;
    }

    public String getThread() {
        return this.thread;
    }

    public List<MonitoredOperationInfo> getSubOperations() {
        if (this.subOperations == null) {
            return Collections.emptyList();
        }
        List<MonitoredOperationInfo> subs = this.subOperations.get();
        if (subs == null) {
            return Collections.emptyList();
        }
        return subs;
    }

    public Map<String, Serializable> toMap() {
        List<MonitoredOperationInfo> subs;
        LinkedHashMap<String, Serializable> info = new LinkedHashMap<String, Serializable>();
        if (this.id != null) {
            info.put("id", (Serializable)((Object)this.id));
        }
        info.put("operation", (Serializable)((Object)this.operation));
        if (this.thread != null) {
            info.put("thread", (Serializable)((Object)this.thread));
        }
        info.put("duration", (Serializable)((Object)Long.toString(this.timer.getDuration())));
        if (this.count != null && this.count > 0) {
            info.put("count", (Serializable)((Object)Integer.toString(this.count)));
        }
        if (this.subOperations != null && (subs = this.subOperations.get()) != null && !subs.isEmpty()) {
            info.put("subOperation", (Serializable)((Object)subs.stream().map(MonitoredOperationInfo::toMap).collect(Collectors.toList())));
        }
        return info;
    }
}

