/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.common;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class ObjectsUtil {
    private ObjectsUtil() {
    }

    public static <T> T getOrDefault(T value, T defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static <T> T getOrDefaultGet(T value, Supplier<T> defaultValueSupplier) {
        return value == null ? Objects.requireNonNull(defaultValueSupplier, "Default value supplier cannot be null").get() : value;
    }

    public static <T> T getIfOrDefaultGet(T value, Predicate<T> condition, Supplier<T> defaultValue) {
        Objects.requireNonNull(condition, "Condition should be provided");
        Objects.requireNonNull(defaultValue, "Default value supplier should be provided");
        return condition.test(value) ? value : defaultValue.get();
    }

    public static <T> void setIfNotNull(Supplier<T> getter, Consumer<T> setter) {
        T val = getter.get();
        if (val != null) {
            setter.accept(val);
        }
    }
}

