/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.common;

import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HealthResult {
    private String name;
    private Status status;
    private String message;
    private Throwable cause;

    protected HealthResult(String name) {
        this.name = name;
    }

    public HealthResult(String name, Status status) {
        this.name = name;
        this.status = status;
    }

    public HealthResult(String name, Status status, String message) {
        this.name = name;
        this.status = status;
        this.message = message;
    }

    public HealthResult(String name, Status status, String message, Throwable cause) {
        this.name = name;
        this.status = status;
        this.message = message;
        this.cause = cause;
    }

    public static HealthResult green(String name) {
        return new HealthResult(name, Status.GREEN);
    }

    public static HealthResult yellow(String name, String message) {
        return new HealthResult(name, Status.YELLOW, message);
    }

    public static HealthResult red(String name, String message) {
        return new HealthResult(name, Status.RED, message);
    }

    public static HealthResult red(String name, Throwable cause) {
        return new HealthResult(name, Status.RED, cause.getMessage(), cause);
    }

    public static HealthResult red(String name, String message, Throwable cause) {
        return new HealthResult(name, Status.RED, message, cause);
    }

    public boolean isHealth() {
        return this.status != null && this.status.isHealthy();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public void setCause(Throwable cause) {
        this.cause = cause;
    }

    public HealthResult copy() {
        return new HealthResult(this.getName(), this.getStatus(), this.getMessage(), this.getCause());
    }

    public static HealthResult combine(Supplier<HealthResult> firstProvider, Supplier<HealthResult> secondProvider) {
        HealthResult secondHealth;
        HealthResult firstHealth;
        try {
            firstHealth = firstProvider.get();
        }
        catch (Exception ex) {
            firstHealth = new HealthResult(null, Status.RED, ex.getMessage());
        }
        if (firstHealth != null && !firstHealth.isHealth()) {
            return firstHealth;
        }
        try {
            secondHealth = secondProvider.get();
        }
        catch (Exception ex) {
            secondHealth = new HealthResult(null, Status.RED, ex.getMessage());
        }
        if (secondHealth == null) {
            return firstHealth == null ? new HealthResult(null, Status.GREEN) : firstHealth;
        }
        if (firstHealth == null) {
            return secondHealth;
        }
        if (!secondHealth.isHealth()) {
            return secondHealth;
        }
        Status status = Status.GREEN;
        if (firstHealth.getStatus() == Status.YELLOW || secondHealth.getStatus() == Status.YELLOW) {
            status = Status.YELLOW;
        }
        String message = Stream.of(firstHealth.getMessage(), secondHealth.getMessage()).filter(Objects::nonNull).distinct().collect(Collectors.joining(", "));
        Throwable cause = firstHealth.getCause();
        if (cause != null) {
            if (secondHealth.getCause() != null) {
                cause.addSuppressed(secondHealth.getCause());
            }
        } else {
            cause = secondHealth.getCause();
        }
        return new HealthResult(null, status, message, cause);
    }

    public static enum Status {
        RED(false, 500),
        YELLOW(true, 206),
        GREEN(true, 200);

        private int httpStatus;
        private boolean healthy;

        private Status(boolean healthy, int httpStatus) {
            this.healthy = healthy;
            this.httpStatus = httpStatus;
        }

        public boolean isHealthy() {
            return this.healthy;
        }

        public int getHttpStatus() {
            return this.httpStatus;
        }
    }
}

