/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.common;

import com.ontotext.soaas.common.Resettable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

public class Debounce<E>
implements Resettable {
    public static final int DEFAULT_DEBOUNCE_WINDOW = 5000;
    private final Lock debounceLock = new ReentrantLock();
    private long debounceWindow;
    private E cachedResult;
    private long expireAfter;

    public Debounce() {
        this(5000L);
    }

    public Debounce(long debounceWindow) {
        this.debounceWindow = debounceWindow;
    }

    public static <E> Debounce<E> noWait() {
        return new Debounce<E>(0L);
    }

    public void setDebounceWindow(long debounceWindow) {
        if (this.expireAfter > 0L) {
            long oldDebounceWindow = this.debounceWindow;
            this.expireAfter = this.expireAfter - oldDebounceWindow + debounceWindow;
        }
        this.debounceWindow = debounceWindow;
    }

    public E get(Supplier<E> supplier) {
        return (E)this.get(0L, supplier, () -> null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E get(long waitInMillis, Supplier<E> supplier, Supplier<E> onTimeout) {
        if (this.canUseCache()) {
            return this.cachedResult;
        }
        try {
            if (waitInMillis > 0L) {
                if (!this.debounceLock.tryLock(waitInMillis, TimeUnit.MILLISECONDS)) {
                    return onTimeout.get();
                }
            } else {
                this.debounceLock.lock();
            }
            if (this.cachedResult != null) {
                this.debounceLock.unlock();
                return this.cachedResult;
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        try {
            this.cachedResult = supplier.get();
            this.expireAfter = System.currentTimeMillis() + this.debounceWindow;
        }
        finally {
            this.debounceLock.unlock();
        }
        return this.cachedResult;
    }

    private boolean canUseCache() {
        if (System.currentTimeMillis() < this.expireAfter) {
            return this.cachedResult != null;
        }
        this.cachedResult = null;
        return false;
    }

    @Override
    public void reset() {
        this.debounceLock.lock();
        this.cachedResult = null;
        this.debounceLock.unlock();
    }
}

