/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.spt.data.jslt.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.schibsted.spt.data.jslt.impl.AbstractOperator;
import com.schibsted.spt.data.jslt.impl.ExpressionNode;
import com.schibsted.spt.data.jslt.impl.Location;
import com.schibsted.spt.data.jslt.impl.NodeUtils;

public abstract class NumericOperator
extends AbstractOperator {
    public NumericOperator(ExpressionNode left, ExpressionNode right, String name, Location location) {
        super(left, right, name, location);
    }

    @Override
    public JsonNode perform(JsonNode v1, JsonNode v2) {
        if (v1.isNull() || v2.isNull()) {
            return NullNode.instance;
        }
        v1 = NodeUtils.number(v1, true, this.location);
        v2 = NodeUtils.number(v2, true, this.location);
        if (v1.isIntegralNumber() && v2.isIntegralNumber()) {
            return new LongNode(this.perform(v1.longValue(), v2.longValue()));
        }
        return new DoubleNode(this.perform(v1.doubleValue(), v2.doubleValue()));
    }

    protected abstract double perform(double var1, double var3);

    protected abstract long perform(long var1, long var3);
}

