/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.spt.data.jslt.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.schibsted.spt.data.jslt.Function;
import com.schibsted.spt.data.jslt.impl.AbstractInvocationExpression;
import com.schibsted.spt.data.jslt.impl.BuiltinFunctions;
import com.schibsted.spt.data.jslt.impl.ExpressionNode;
import com.schibsted.spt.data.jslt.impl.FunctionDeclaration;
import com.schibsted.spt.data.jslt.impl.LiteralExpression;
import com.schibsted.spt.data.jslt.impl.Location;
import com.schibsted.spt.data.jslt.impl.OptimizedStaticContainsFunction;
import com.schibsted.spt.data.jslt.impl.Scope;

public class FunctionExpression
extends AbstractInvocationExpression {
    private Function function;
    private FunctionDeclaration declared;
    private String name;
    private static final int OPTIMIZE_ARRAY_CONTAINS_MIN = 10;

    public FunctionExpression(String name, ExpressionNode[] arguments, Location location) {
        super(arguments, location);
        this.name = name;
    }

    public String getFunctionName() {
        return this.name;
    }

    public void resolve(Function function) {
        super.resolve(function);
        this.function = function;
        if (function instanceof FunctionDeclaration) {
            this.declared = (FunctionDeclaration)function;
        }
    }

    @Override
    public JsonNode apply(Scope scope, JsonNode input) {
        JsonNode[] params = new JsonNode[this.arguments.length];
        for (int ix = 0; ix < params.length; ++ix) {
            params[ix] = this.arguments[ix].apply(scope, input);
        }
        if (this.declared != null) {
            return this.declared.call(scope, input, params);
        }
        JsonNode value = this.function.call(input, params);
        if (value == null) {
            value = NullNode.instance;
        }
        return value;
    }

    @Override
    public ExpressionNode optimize() {
        JsonNode v;
        super.optimize();
        if (this.function == BuiltinFunctions.functions.get("contains") && this.arguments.length == 2 && this.arguments[1] instanceof LiteralExpression && (v = this.arguments[1].apply(null, null)).isArray() && v.size() > 10) {
            this.resolve(new OptimizedStaticContainsFunction(v));
        }
        return this;
    }
}

