/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.spt.data.jslt.impl;

import com.schibsted.spt.data.jslt.JsltException;
import com.schibsted.spt.data.jslt.ResourceResolver;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class ClasspathResourceResolver
implements ResourceResolver {
    private Charset charset;

    public ClasspathResourceResolver() {
        this(StandardCharsets.UTF_8);
    }

    public ClasspathResourceResolver(Charset charset) {
        this.charset = charset;
    }

    @Override
    public Reader resolve(String jslt) {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(jslt);
        if (is == null) {
            throw new JsltException("Cannot load resource '" + jslt + "': not found");
        }
        return new InputStreamReader(is, this.charset);
    }
}

