/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rdf.transformer;

import com.ontotext.models.SomlSchema;
import com.ontotext.rdf.transformer.RdfTransformerFactory;
import com.ontotext.rdf.transformer.TransformContext;
import com.ontotext.rdf.transformer.ValueSerializationMode;
import com.ontotext.soaas.plugin.PluginsManager;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdfTransformers {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Map<String, RdfTransformerFactory> transformerFactories;
    private Map<String, Object> options = Collections.emptyMap();

    public Object transform(String format, SomlSchema schema, TransformContext transformContext) {
        return this.resolveTransformer(format).orElseThrow(RdfTransformers.notSupportedFormat(format)).createTransformer(format, schema).transform(transformContext, this.options);
    }

    public Object transform(String format, SomlSchema schema, List<TransformContext> transformContexts) {
        return this.resolveTransformer(format).orElseThrow(RdfTransformers.notSupportedFormat(format)).createTransformer(format, schema).transform(transformContexts, this.options);
    }

    private static Supplier<IllegalArgumentException> notSupportedFormat(String format) {
        return () -> new IllegalArgumentException("No " + RdfTransformerFactory.class.getName() + " that supports the format: " + format);
    }

    private Optional<RdfTransformerFactory> resolveTransformer(String format) {
        return Optional.ofNullable(this.getFactories().get(format));
    }

    private Map<String, RdfTransformerFactory> getFactories() {
        if (this.transformerFactories == null) {
            this.transformerFactories = RdfTransformers.createFactories();
        }
        return this.transformerFactories;
    }

    public boolean isSupported(String format) {
        return this.getFactories().containsKey(format);
    }

    public Set<String> getSupportedFormats() {
        return Collections.unmodifiableSet(this.getFactories().keySet());
    }

    public void registerRdfTransformerFactory(RdfTransformerFactory factoryInstance) {
        RdfTransformers.registerFactory(factoryInstance, this.getFactories(), false);
    }

    public void enableValidations() {
        this.getFactories().replaceAll((outputFormat, transformerFactory) -> RdfTransformers.changeSerializationModeTo(transformerFactory, ValueSerializationMode.STRICT));
    }

    public void disableValidations() {
        this.getFactories().replaceAll((outputFormat, transformerFactory) -> RdfTransformers.changeSerializationModeTo(transformerFactory, ValueSerializationMode.RELAXED));
    }

    private static RdfTransformerFactory changeSerializationModeTo(RdfTransformerFactory transformerFactory, ValueSerializationMode serializationMode) {
        if (transformerFactory.getValueSerializationMode() == serializationMode) {
            return transformerFactory;
        }
        return transformerFactory.withValueSerializationMode(serializationMode);
    }

    private static Map<String, RdfTransformerFactory> createFactories() {
        List factoryList = PluginsManager.loadPlugins(RdfTransformerFactory.class);
        HashMap<String, RdfTransformerFactory> factories = new HashMap<String, RdfTransformerFactory>();
        for (RdfTransformerFactory transformerFactory : factoryList) {
            RdfTransformers.registerFactory(transformerFactory, factories, true);
        }
        return factories;
    }

    private static void registerFactory(RdfTransformerFactory transformerFactory, Map<String, RdfTransformerFactory> factories, boolean failIfExist) {
        for (String type : transformerFactory.outputFormat()) {
            if (factories.containsKey(type)) {
                String message = String.format("Cannot register transformer factory %s for %s as it's already handled by %s", transformerFactory.getClass().getName(), type, factories.get(type).getClass().getName());
                if (failIfExist) {
                    throw new IllegalStateException(message);
                }
                LOGGER.warn(message);
            }
            factories.put(type, transformerFactory);
        }
    }

    public void setOptions(Map<String, Object> options) {
        this.options = options;
    }
}

