/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.calcite;

import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.calcite.avatica.AvaticaUtils;
import org.apache.calcite.avatica.metrics.MetricsSystem;
import org.apache.calcite.avatica.metrics.Timer;
import org.apache.calcite.avatica.metrics.noop.NoopMetricsSystem;
import org.apache.calcite.avatica.remote.Handler;
import org.apache.calcite.avatica.remote.JsonHandler;
import org.apache.calcite.avatica.remote.MetricsHelper;
import org.apache.calcite.avatica.remote.ProtobufHandler;
import org.apache.calcite.avatica.remote.ProtobufTranslation;
import org.apache.calcite.avatica.remote.ProtobufTranslationImpl;
import org.apache.calcite.avatica.remote.Service;
import org.apache.calcite.avatica.util.UnsynchronizedBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvaticaHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AvaticaHandler.class);
    private final JsonHandler jsonHandler;
    private final ProtobufHandler pbHandler;
    private final Timer requestTimer;
    final ThreadLocal<UnsynchronizedBuffer> threadLocalBuffer;

    public AvaticaHandler(Service service) {
        Objects.requireNonNull(service);
        NoopMetricsSystem metrics = NoopMetricsSystem.getInstance();
        this.jsonHandler = new JsonHandler(service, (MetricsSystem)metrics);
        this.pbHandler = new ProtobufHandler(service, (ProtobufTranslation)new ProtobufTranslationImpl(), (MetricsSystem)metrics);
        this.requestTimer = metrics.getTimer(MetricsHelper.concat(AvaticaHandler.class, (String)"Handler.RequestTimings"));
        this.threadLocalBuffer = ThreadLocal.withInitial(UnsynchronizedBuffer::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleJson(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try (Timer.Context ignored = this.requestTimer.start();){
            Handler.HandlerResponse jsonResponse;
            response.setContentType("application/json;charset=utf-8");
            response.setStatus(200);
            String rawRequest = request.getHeader("request");
            if (rawRequest == null) {
                UnsynchronizedBuffer buffer = this.threadLocalBuffer.get();
                try (ServletInputStream inputStream = request.getInputStream();){
                    byte[] bytes = AvaticaUtils.readFullyToBytes((InputStream)inputStream, (UnsynchronizedBuffer)buffer);
                    String encoding = request.getCharacterEncoding();
                    if (encoding == null) {
                        encoding = "UTF-8";
                    }
                    rawRequest = new String(bytes, encoding);
                }
                finally {
                    buffer.reset();
                }
            }
            String jsonRequest = rawRequest;
            LOG.trace("request: {}", (Object)jsonRequest);
            try {
                jsonResponse = this.jsonHandler.apply(jsonRequest);
            }
            catch (Exception e) {
                LOG.debug("Error invoking request from {}", (Object)request.getRemoteAddr(), (Object)e);
                jsonResponse = this.jsonHandler.convertToErrorResponse(e);
            }
            LOG.trace("response: {}", (Object)jsonResponse);
            response.setStatus(jsonResponse.getStatusCode());
            response.getWriter().println((String)jsonResponse.getResponse());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleProtobuf(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try (Timer.Context ignored = this.requestTimer.start();){
            Handler.HandlerResponse handlerResponse;
            byte[] requestBytes;
            response.setContentType("application/octet-stream;charset=utf-8");
            response.setStatus(200);
            UnsynchronizedBuffer buffer = this.threadLocalBuffer.get();
            try (ServletInputStream inputStream = request.getInputStream();){
                requestBytes = AvaticaUtils.readFullyToBytes((InputStream)inputStream, (UnsynchronizedBuffer)buffer);
            }
            finally {
                buffer.reset();
            }
            try {
                handlerResponse = this.pbHandler.apply(requestBytes);
            }
            catch (Exception e) {
                LOG.debug("Error invoking request from {}", (Object)request.getRemoteAddr(), (Object)e);
                handlerResponse = this.pbHandler.convertToErrorResponse(e);
            }
            response.setStatus(handlerResponse.getStatusCode());
            response.getOutputStream().write((byte[])handlerResponse.getResponse());
        }
    }
}

