/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.calcite;

import com.ontotext.forest.calcite.AvaticaHandler;
import com.ontotext.forest.core.proxy.ProxyToRemoteSesame;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.core.semantic.SemanticLocation;
import com.ontotext.forest.core.semantic.SemanticLocationManagement;
import com.ontotext.forest.security.utils.SecurityUtils;
import com.ontotext.graphdb.GraphDBRepositoryManager;
import com.ontotext.graphdb.jdbc.GraphDBJdbcMeta;
import com.ontotext.graphdb.jdbc.RepositoryManagerModelProperties;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.remote.LocalService;
import org.apache.calcite.avatica.remote.Service;
import org.eclipse.rdf4j.repository.manager.LocalRepositoryManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/avatica"})
public class AvaticaController {
    private static final String URL_BASE = "jdbc:graphdb:internal:";
    private AvaticaHandler handler;
    @Autowired
    private SemanticLocationManagement locationManagement;
    @Autowired
    private SemanticDataManagement dataManagement;
    @Autowired
    private ProxyToRemoteSesame proxy;

    @PostConstruct
    public void init() throws SQLException, URISyntaxException {
        SemanticLocation systemLocation = this.locationManagement.getSystemLocation();
        GraphDBRepositoryManager repositoryManager = (GraphDBRepositoryManager)systemLocation.sesameManager();
        GraphDBJdbcMeta meta = new GraphDBJdbcMeta(URL_BASE, (Properties)new RepositoryManagerModelProperties((LocalRepositoryManager)repositoryManager, repo -> SecurityUtils.hasRepositoryAccess((String)repo, (boolean)false)));
        LocalService service = new LocalService((Meta)meta);
        this.handler = new AvaticaHandler((Service)service);
    }

    @RequestMapping(value={"", "/", "protobuf", "protobuf/"}, method={RequestMethod.POST})
    public void handleProtobuf(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.handleLocalOrRemote(request, response, this.handler::handleProtobuf);
    }

    @RequestMapping(value={"json", "json/"}, method={RequestMethod.POST})
    public void handleJson(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.handleLocalOrRemote(request, response, this.handler::handleJson);
    }

    private void handleLocalOrRemote(HttpServletRequest request, HttpServletResponse response, LocalHandler localHandler) throws IOException {
        SemanticLocation location = this.dataManagement.getLocationFromHeaderOrThrow();
        if (location.isLocal()) {
            localHandler.handle(request, response);
        } else {
            this.proxy.proxyRequest(request, response, location);
        }
    }

    static interface LocalHandler {
        public void handle(HttpServletRequest var1, HttpServletResponse var2) throws IOException;
    }
}

