/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.autocomplete.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.ontotext.forest.autocomplete.model.Label;
import com.ontotext.forest.autocomplete.model.SuggestionEntry;
import com.ontotext.forest.core.error.GraphDBWorkbenchException;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.core.semantic.repository.SemanticRepository;
import com.ontotext.license.License;
import com.ontotext.license.LicenseRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.UpdateExecutionException;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.helpers.NTriplesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/rest/autocomplete"})
public class AutocompleteController {
    private final Logger LOGGER = LoggerFactory.getLogger(AutocompleteController.class);
    private static final String ASK_AUTOCOMPLETE = "ASK WHERE { _:s <http://www.ontotext.com/plugins/autocomplete#present> ?o . } ";
    private static final String ASK_ENABLED_AUTOCOMPLETE = "ASK WHERE { _:s <http://www.ontotext.com/plugins/autocomplete#enabled> ?o . } ";
    private static final String SET_ENABLED_AUTOCOMPLETE_INSERT = "INSERT DATA { _:s  <http://www.ontotext.com/plugins/autocomplete#enabled> \"%s\" . }";
    private static final String SET_ENABLED_AUTOCOMPLETE_ASK = "ASK { GRAPH <http://www.ontotext.com/plugins/autocomplete#control> { _:s  <http://www.ontotext.com/plugins/autocomplete#enabled> \"%s\" . } }";
    private static final String ASK_INDEX_IRIS = "ASK WHERE { _:s <http://www.ontotext.com/plugins/autocomplete#indexIRIs> ?o . } ";
    private static final String SET_INDEX_IRIS_INSERT = "INSERT DATA { _:s  <http://www.ontotext.com/plugins/autocomplete#indexIRIs> \"%s\" . }";
    private static final String SET_INDEX_IRIS_ASK = "ASK { GRAPH <http://www.ontotext.com/plugins/autocomplete#control> { _:s  <http://www.ontotext.com/plugins/autocomplete#indexIRIs> \"%s\" . } }";
    private static final String REINDEX_AUTOCOMPLETE_INSERT = "INSERT DATA { _:s <http://www.ontotext.com/plugins/autocomplete#reIndex> true . }";
    private static final String REINDEX_AUTOCOMPLETE_ASK = "ASK { GRAPH <http://www.ontotext.com/plugins/autocomplete#control> { _:s <http://www.ontotext.com/plugins/autocomplete#reIndex> true . } }";
    private static final String GET_AUTOCOMPLETE_SUGGESTIONS = "SELECT ?s ?g WHERE { GRAPH ?g { ?s <http://www.ontotext.com/plugins/autocomplete#query> ?queryStr } . } \n";
    private static final String GET_INDEX_STATUS = "SELECT ?o WHERE { ?s <http://www.ontotext.com/plugins/autocomplete#status> ?o . } \n";
    private static final String INTERRUPT_REINDEX_AUTOCOMPLETE_INSERT = "INSERT DATA { _:s <http://www.ontotext.com/plugins/autocomplete#interruptIndexing> true . }";
    private static final String INTERRUPT_REINDEX_AUTOCOMPLETE_ASK = "ASK { GRAPH <http://www.ontotext.com/plugins/autocomplete#control> { _:s <http://www.ontotext.com/plugins/autocomplete#interruptIndexing> true . } }";
    private static final String GET_LABEL_CONFIG = "SELECT ?iri ?languages WHERE { ?iri <http://www.ontotext.com/plugins/autocomplete#labelConfig> ?languages . } \n";
    private static final String ADD_LABEL_CONFIG_INSERT = "INSERT DATA { <%s>  <http://www.ontotext.com/plugins/autocomplete#addLabelConfig> \"%s\" . }";
    private static final String ADD_LABEL_CONFIG_ASK = "ASK { GRAPH <http://www.ontotext.com/plugins/autocomplete#control> { <%s>  <http://www.ontotext.com/plugins/autocomplete#addLabelConfig> \"%s\" . } }";
    private static final String REMOVE_LABEL_CONFIG_INSERT = "INSERT DATA { <%s>  <http://www.ontotext.com/plugins/autocomplete#removeLabelConfig> \"\" . }";
    private static final String REMOVE_LABEL_CONFIG_ASK = "ASK { GRAPH <http://www.ontotext.com/plugins/autocomplete#control> { <%s>  <http://www.ontotext.com/plugins/autocomplete#removeLabelConfig> \"\" . } }";
    @Autowired
    private SemanticDataManagement semanticDataManagement;

    @RequestMapping(value={"enabled"}, method={RequestMethod.GET})
    private ResponseEntity<Boolean> isAutocompleteEnabled() throws GraphDBWorkbenchException {
        return new ResponseEntity((Object)this._isAutocompleteEnabled(), (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"enabled"}, method={RequestMethod.POST})
    private ResponseEntity<String> setEnabledAutocomplete(@RequestParam(value="enabled") Boolean enabled) throws GraphDBWorkbenchException {
        try {
            if (this.useAskControl()) {
                this.evaluateBooleanQuery(String.format(SET_ENABLED_AUTOCOMPLETE_ASK, enabled));
            } else {
                this.executeUpdate(String.format(SET_ENABLED_AUTOCOMPLETE_INSERT, enabled));
            }
            return new ResponseEntity((Object)("Autocomplete was " + (enabled != false ? "enabled" : "disabled")), (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    boolean useAskControl() {
        return LicenseRegistry.getInstance().getProduct() != License.Product.GRAPHDB_ENTERPRISE;
    }

    @RequestMapping(value={"iris"}, method={RequestMethod.GET})
    private ResponseEntity<Boolean> shouldIndexIRIs() throws GraphDBWorkbenchException {
        return new ResponseEntity((Object)this._shouldIndexIRIs(), (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"iris"}, method={RequestMethod.POST})
    private ResponseEntity<String> setShouldIndexIRIs(@RequestParam(value="enabled") Boolean enabled) throws GraphDBWorkbenchException {
        try {
            if (this.useAskControl()) {
                this.evaluateBooleanQuery(String.format(SET_INDEX_IRIS_ASK, enabled));
            } else {
                this.executeUpdate(String.format(SET_INDEX_IRIS_INSERT, enabled));
            }
            return new ResponseEntity((Object)("Indexing IRIs was " + (enabled != false ? "enabled" : "disabled")), (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"reindex"}, method={RequestMethod.POST})
    public ResponseEntity<String> reIndex() {
        try {
            if (this.useAskControl()) {
                this.evaluateBooleanQuery(REINDEX_AUTOCOMPLETE_ASK);
            } else {
                this.executeUpdate(REINDEX_AUTOCOMPLETE_INSERT);
            }
            return new ResponseEntity((Object)"Index will be rebuilt.", (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"interrupt"}, method={RequestMethod.POST})
    public ResponseEntity<String> interrupt() {
        try {
            if (this.useAskControl()) {
                this.evaluateBooleanQuery(INTERRUPT_REINDEX_AUTOCOMPLETE_ASK);
            } else {
                this.executeUpdate(INTERRUPT_REINDEX_AUTOCOMPLETE_INSERT);
            }
            return new ResponseEntity((Object)"Index rebuilt will be interrupted.", (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private void executeUpdate(final String query) throws GraphDBWorkbenchException {
        SemanticRepository semanticRepository = this.semanticDataManagement.getCurrentRepositoryOrThrow();
        Objects.requireNonNull(semanticRepository);
        new SemanticRepository.WithConnection(this, semanticRepository){

            protected Void doInConnection() throws RepositoryException {
                try {
                    this.prepareAndExecuteUpdate(query);
                }
                catch (MalformedQueryException | UpdateExecutionException e) {
                    throw new RepositoryException(e);
                }
                return null;
            }
        }.run();
    }

    private boolean evaluateBooleanQuery(final String query) throws GraphDBWorkbenchException {
        SemanticRepository semanticRepository = this.semanticDataManagement.getCurrentRepositoryOrThrow();
        Objects.requireNonNull(semanticRepository);
        return (Boolean)new SemanticRepository.WithConnection<Boolean>(this, semanticRepository){

            protected Boolean doInConnection() throws RepositoryException {
                try {
                    return this.prepareAndEvaluateBoolean(query);
                }
                catch (MalformedQueryException | QueryEvaluationException e) {
                    throw new RepositoryException(e);
                }
            }
        }.run();
    }

    @RequestMapping(value={"status"}, method={RequestMethod.GET})
    public ResponseEntity<String> status() throws GraphDBWorkbenchException {
        String status = this.getIndexStatus();
        if (status != null) {
            return new ResponseEntity((Object)status, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((Object)"Unable to get index status", (HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"labels"}, method={RequestMethod.GET})
    public ResponseEntity<List<Label>> listLabels() throws GraphDBWorkbenchException {
        return new ResponseEntity(this.getLabelConfig(), (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"labels"}, method={RequestMethod.PUT})
    public ResponseEntity<?> addLabel(@RequestBody Label label) throws GraphDBWorkbenchException {
        this._addLabel(label);
        return new ResponseEntity((HttpStatusCode)HttpStatus.CREATED);
    }

    @RequestMapping(value={"labels/edit"}, method={RequestMethod.PUT})
    public ResponseEntity<?> updateLabel(@RequestParam String oldLabel, @RequestParam String newLabel) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        Label oldLabelObj = (Label)mapper.readValue(oldLabel, Label.class);
        Label newLabelObj = (Label)mapper.readValue(newLabel, Label.class);
        final String oldLabelIri = oldLabelObj.getLabelIri();
        final String newLabelIri = newLabelObj.getLabelIri();
        final String languages = newLabelObj.getLanguages().replace("\"", "");
        SemanticRepository semanticRepository = this.semanticDataManagement.getCurrentRepositoryOrThrow();
        Objects.requireNonNull(semanticRepository);
        new SemanticRepository.WithConnection(semanticRepository){

            protected Void doInConnection() throws RepositoryException {
                try {
                    if (AutocompleteController.this.useAskControl()) {
                        this.prepareAndEvaluateBoolean(String.format(AutocompleteController.REMOVE_LABEL_CONFIG_ASK, oldLabelIri));
                        this.prepareAndEvaluateBoolean(String.format(AutocompleteController.ADD_LABEL_CONFIG_ASK, newLabelIri, languages));
                    } else {
                        this.prepareAndExecuteUpdate(String.format(AutocompleteController.REMOVE_LABEL_CONFIG_INSERT, oldLabelIri));
                        this.prepareAndExecuteUpdate(String.format(AutocompleteController.ADD_LABEL_CONFIG_INSERT, newLabelIri, languages));
                    }
                }
                catch (MalformedQueryException | UpdateExecutionException e) {
                    throw new RepositoryException(e);
                }
                return null;
            }
        }.run();
        return new ResponseEntity((HttpStatusCode)HttpStatus.CREATED);
    }

    @RequestMapping(value={"labels"}, method={RequestMethod.DELETE})
    public ResponseEntity<?> removeLabel(@RequestBody Label label) throws GraphDBWorkbenchException {
        this._removeLabel(label);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"plugin-found"}, method={RequestMethod.GET})
    public ResponseEntity<Boolean> isAutocompletePluginPresent() throws GraphDBWorkbenchException {
        return new ResponseEntity((Object)this._isAutocompletePluginPresent(), (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"query"}, method={RequestMethod.GET})
    public ResponseEntity<?> autocomplete(final @RequestParam(value="q") String q) throws GraphDBWorkbenchException {
        if (!this._isAutocompletePluginPresent()) {
            return new ResponseEntity((Object)"Autocomplete plugin not found or not available for this repository.", (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        if (!this._isAutocompleteEnabled()) {
            return new ResponseEntity((Object)"Autocomplete is not enabled for this repository", (HttpStatusCode)HttpStatus.NO_CONTENT);
        }
        ArrayList suggestionEntries = Lists.newArrayList();
        if (q == null || q.isEmpty()) {
            return new ResponseEntity((Object)new SuggestionEntry.Suggestions(suggestionEntries), (HttpStatusCode)HttpStatus.OK);
        }
        try {
            SemanticRepository semanticRepository = this.semanticDataManagement.getCurrentRepositoryOrThrow();
            Objects.requireNonNull(semanticRepository);
            List uriSuggestions = (List)new SemanticRepository.WithConnection<List<SuggestionEntry>>(semanticRepository){

                protected List<SuggestionEntry> doInConnection() throws RepositoryException {
                    ArrayList<SuggestionEntry> autocompleteResponse = new ArrayList<SuggestionEntry>();
                    try {
                        TupleQuery tupleQuery = this.prepare(AutocompleteController.GET_AUTOCOMPLETE_SUGGESTIONS);
                        tupleQuery.setBinding("queryStr", (Value)SimpleValueFactory.getInstance().createLiteral(q));
                        TupleQueryResult result = this.evaluate(tupleQuery);
                        while (result.hasNext()) {
                            BindingSet suggestion = (BindingSet)result.next();
                            Value sValue = suggestion.getBinding("s").getValue();
                            String description = suggestion.getBinding("g").getValue().stringValue();
                            if (sValue instanceof Triple) {
                                autocompleteResponse.add(new SuggestionEntry("triple", NTriplesUtil.toNTriplesString((Value)sValue), description));
                                continue;
                            }
                            autocompleteResponse.add(new SuggestionEntry("uri", sValue.stringValue(), description));
                        }
                    }
                    catch (MalformedQueryException | QueryEvaluationException e) {
                        AutocompleteController.this.LOGGER.error("Error while autocompletion", e);
                        throw new RepositoryException(e);
                    }
                    return autocompleteResponse;
                }
            }.run();
            if (q.indexOf(58) == -1) {
                Stream<SuggestionEntry> foundNamespaces = this.semanticDataManagement.getCurrentRepositoryOrThrow().getNamespaces().stream().filter(n -> n.getPrefix().startsWith(q)).map(n -> new SuggestionEntry("prefix", n.getPrefix(), "PREFIX " + n.getPrefix().replaceAll(q, "<b>" + q + "</b>") + ": &lt;" + n.getName() + "&gt;"));
                suggestionEntries.addAll(foundNamespaces.collect(Collectors.toList()));
            }
            suggestionEntries.addAll(uriSuggestions);
            return new ResponseEntity((Object)new SuggestionEntry.Suggestions(suggestionEntries), (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private boolean _isAutocompleteEnabled() throws GraphDBWorkbenchException {
        return this.evaluateBooleanQuery(ASK_ENABLED_AUTOCOMPLETE);
    }

    private boolean _shouldIndexIRIs() throws GraphDBWorkbenchException {
        return this.evaluateBooleanQuery(ASK_INDEX_IRIS);
    }

    private String getIndexStatus() throws GraphDBWorkbenchException {
        return (String)new SemanticRepository.WithConnection<String>(this, this.semanticDataManagement.getCurrentRepositoryOrThrow()){

            protected String doInConnection() throws RepositoryException {
                try {
                    TupleQueryResult result = this.prepareAndEvaluate(AutocompleteController.GET_INDEX_STATUS);
                    if (result.hasNext()) {
                        BindingSet next = (BindingSet)result.next();
                        return next.getBinding("o").getValue().stringValue();
                    }
                    return null;
                }
                catch (MalformedQueryException | QueryEvaluationException e) {
                    throw new RepositoryException(e);
                }
            }
        }.run();
    }

    private boolean _isAutocompletePluginPresent() throws GraphDBWorkbenchException {
        return this.evaluateBooleanQuery(ASK_AUTOCOMPLETE);
    }

    private List<Label> getLabelConfig() throws GraphDBWorkbenchException {
        return (List)new SemanticRepository.WithConnection<List<Label>>(this, this.semanticDataManagement.getCurrentRepositoryOrThrow()){

            protected List<Label> doInConnection() throws RepositoryException {
                ArrayList<Label> result = new ArrayList<Label>();
                try (TupleQueryResult tqr = this.prepareAndEvaluate(AutocompleteController.GET_LABEL_CONFIG);){
                    while (tqr.hasNext()) {
                        BindingSet bs = (BindingSet)tqr.next();
                        result.add(new Label(bs.getBinding("iri").getValue().stringValue(), bs.getBinding("languages").getValue().stringValue()));
                    }
                }
                catch (MalformedQueryException | QueryEvaluationException e) {
                    throw new RepositoryException(e);
                }
                return result;
            }
        }.run();
    }

    private void _addLabel(Label label) throws GraphDBWorkbenchException {
        String labelIri = label.getLabelIri();
        String languages = label.getLanguages().replace("\"", "");
        if (this.useAskControl()) {
            this.evaluateBooleanQuery(String.format(ADD_LABEL_CONFIG_ASK, labelIri, languages));
        } else {
            this.executeUpdate(String.format(ADD_LABEL_CONFIG_INSERT, labelIri, languages));
        }
    }

    private void _removeLabel(Label label) throws GraphDBWorkbenchException {
        String labelIri = label.getLabelIri();
        if (this.useAskControl()) {
            this.evaluateBooleanQuery(String.format(REMOVE_LABEL_CONFIG_ASK, labelIri));
        } else {
            this.executeUpdate(String.format(REMOVE_LABEL_CONFIG_INSERT, labelIri));
        }
    }
}

