/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler.statistics;

import com.ontotext.graphql.parser.argument.optimization.RepoStatistics;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.Shapes;
import com.ontotext.soaas.common.SparqlUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class CachedRepoStatistics
implements RepoStatistics {
    private static final double DEFAULT_SIZE = 1.0;
    private static final Map<String, Double> EMPTY_MAP = new HashMap<String, Double>();
    private Map<Shape, Double> shapeSizeMap;
    private Map<Shape, Map<String, Double>> shapePropSizeMap;

    private CachedRepoStatistics() {
    }

    private CachedRepoStatistics(Map<Shape, Double> shapeSizeMap, Map<Shape, Map<String, Double>> shapePropSizeMap) {
        this.shapeSizeMap = shapeSizeMap;
        this.shapePropSizeMap = shapePropSizeMap;
    }

    public double forShape(Shape shape) {
        return this.shapeSizeMap.getOrDefault(shape, 1.0);
    }

    public double forShapeProp(Shape shape, PropertyShape prop) {
        if (prop == null) {
            return this.forShape(shape);
        }
        return this.shapePropSizeMap.getOrDefault(shape, EMPTY_MAP).getOrDefault(prop.getName(), this.forShape(shape));
    }

    public boolean isEmpty() {
        if (this.shapeSizeMap == null || this.shapePropSizeMap == null) {
            return true;
        }
        return this.shapeSizeMap.values().stream().mapToDouble(Double::doubleValue).sum() == 0.0;
    }

    public String prettyPrint() {
        StringBuilder builder = new StringBuilder();
        builder.append("REPOSITORY STATISTICS\n");
        builder.append("ESTIMATED TYPE SIZE\n");
        this.shapeSizeMap.entrySet().stream().sorted(Comparator.comparing(o -> ((Shape)o.getKey()).getId())).forEach(this.printShape(builder));
        builder.append("\nESTIMATED PROPERTY PER TYPE SIZE\n");
        this.shapePropSizeMap.entrySet().stream().sorted(Comparator.comparing(o -> ((Shape)o.getKey()).getId())).forEach(this.printShapeProp(builder));
        return builder.toString();
    }

    protected static Predicate<Shape> includeShapeInStatistics() {
        return shape -> !shape.isAbstract() && !shape.isUnion() && !shape.getId().equals("Literal") && !shape.isSystem() && !SparqlUtil.isSparqlTemplate((String)shape.getTypePropIri());
    }

    protected static Predicate<PropertyShape> includePropInStatistics() {
        return shapeProp -> {
            if ("type".equalsIgnoreCase(shapeProp.getName())) {
                return false;
            }
            if (shapeProp.isSparqlTemplate()) {
                return false;
            }
            if (shapeProp.getInverseAliasProperty().filter(SparqlUtil::isSparqlTemplate).isPresent()) {
                return false;
            }
            return shapeProp.isMultivalued() || !shapeProp.isRequired();
        };
    }

    private Consumer<Map.Entry<Shape, Double>> printShape(StringBuilder builder) {
        return shapeStat -> builder.append("  ").append(((Shape)shapeStat.getKey()).getId()).append(": ").append(shapeStat.getValue()).append("\n");
    }

    private Consumer<Map.Entry<Shape, Map<String, Double>>> printShapeProp(StringBuilder builder) {
        return shapePropStat -> {
            builder.append("  ").append(((Shape)shapePropStat.getKey()).getId()).append(":\n");
            ((Map)shapePropStat.getValue()).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(this.printProp(builder));
        };
    }

    private Consumer<Map.Entry<String, Double>> printProp(StringBuilder builder) {
        return propStat -> builder.append("    ").append((String)propStat.getKey()).append(": ").append(BigDecimal.valueOf((Double)propStat.getValue()).setScale(2, RoundingMode.CEILING).doubleValue()).append("\n");
    }

    static class Builder {
        private Map<Shape, Set<Shape>> abstractToConcreteClassMap;
        private Map<Shape, Double> shapeSizeMap = new HashMap<Shape, Double>();
        private Map<Shape, Map<String, Double>> shapePropSizeMap = new HashMap<Shape, Map<String, Double>>();

        Builder() {
        }

        Builder addShapeSize(Shape shape, Double size) {
            this.shapeSizeMap.put(shape, size);
            return this;
        }

        Builder addShapePropSize(Shape shape, PropertyShape prop, Double size) {
            this.shapePropSizeMap.computeIfAbsent(shape, s -> new HashMap()).put(prop.getName(), size);
            return this;
        }

        public CachedRepoStatistics build(Shapes shapes) {
            this.buildHelperCollections(shapes);
            this.buildStatisticsForAbstractClasses(shapes);
            return new CachedRepoStatistics(this.shapeSizeMap, this.shapePropSizeMap);
        }

        private void buildStatisticsForAbstractClasses(Shapes shapes) {
            List abstractClasses = shapes.values().stream().filter(Shape::isAbstract).collect(Collectors.toList());
            for (Shape abstractClass : abstractClasses) {
                Set<Shape> concreteClasses = this.abstractToConcreteClassMap.get(abstractClass);
                double totalSize = concreteClasses.stream().map(concrete -> this.shapeSizeMap.getOrDefault(concrete, 0.0)).mapToDouble(Double::doubleValue).sum();
                this.addShapeSize(abstractClass, totalSize);
            }
            for (Shape abstractClass : abstractClasses) {
                Set propsToBeAdded = abstractClass.getProps().values().stream().filter(CachedRepoStatistics.includePropInStatistics()).collect(Collectors.toSet());
                Set<Shape> concreteClasses = this.abstractToConcreteClassMap.get(abstractClass);
                for (PropertyShape prop : propsToBeAdded) {
                    double totalSize = 0.0;
                    for (Shape concreteClass : concreteClasses) {
                        assert (this.shapePropSizeMap.containsKey(concreteClass));
                        Double value = this.shapePropSizeMap.getOrDefault(concreteClass, EMPTY_MAP).get(prop.getName());
                        if (value == null) continue;
                        totalSize += value.doubleValue();
                    }
                    this.addShapePropSize(abstractClass, prop, totalSize);
                }
            }
        }

        private void buildHelperCollections(Shapes shapes) {
            this.abstractToConcreteClassMap = shapes.values().stream().filter(shape -> shape.isAbstract() || shape.isUnion()).collect(Collectors.toMap(Function.identity(), this.getConcreteShapesForAbstract(shapes)));
        }

        private Function<Shape, Set<Shape>> getConcreteShapesForAbstract(Shapes shapes) {
            return shape -> ((Collection)shapes.getIfPresent(shape.getId()).map(Shape::getConcreteSubTypes).orElse(List.of())).stream().filter(s -> s.isSynthetic() == false).collect(Collectors.toSet());
        }
    }
}

