/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler.specialpredicates;

import com.ontotext.graphql.compiler.ConstraintGenerator;
import com.ontotext.graphql.compiler.SparqlBuilderUtil;
import com.ontotext.graphql.compiler.SpecialPredicate;
import com.ontotext.graphql.compiler.querymodel.BoTypeFragment;
import com.ontotext.graphql.compiler.querymodel.Empty;
import com.ontotext.graphql.compiler.querymodel.Iri;
import com.ontotext.graphql.compiler.querymodel.SparqlFragment;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.TempVar;
import com.ontotext.graphql.compiler.querymodel.TriplePattern;
import com.ontotext.graphql.compiler.querymodel.TriplePatternBlock;
import com.ontotext.graphql.compiler.querymodel.Value;
import com.ontotext.graphql.compiler.querymodel.Var;
import com.ontotext.models.Constraints;
import com.ontotext.models.Prefixes;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Selectable;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.templates.Template;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public class BoName
implements SpecialPredicate {
    public static final String NAME = "name";

    @Override
    public String getPredicate() {
        return NAME;
    }

    @Override
    public String getRdfProperty(Shape wrappingType) {
        return wrappingType.getNameIri();
    }

    @Override
    public SparqlNode generateSparql(Selectable selection, Var subject, ConstraintGenerator constraintGenerator, UnaryOperator<Var> varProcessor) {
        Shape definedInType = selection.getDefinedInType();
        if (!definedInType.isAbstract() && definedInType.getName() == null || definedInType.isUnion()) {
            return Empty.INSTANCE;
        }
        Var object = (Var)varProcessor.apply(this.createPredicateVariable(selection, subject));
        if (BoName.isThereConcreteSubtypesWithDifferentName(definedInType)) {
            Collection<Shape> subTypes = this.getSubTypes(selection.getParent(), definedInType);
            return this.computeNameBasedOnType(subTypes, subject, object, constraintGenerator, selection);
        }
        Object templateArgs = selection.getArguments().get((Object)"args");
        Shape concreteShape = definedInType.isAbstract() ? (Shape)definedInType.getConcreteSubTypes().stream().findFirst().orElseThrow(() -> new IllegalStateException("There should be at least one child")) : definedInType;
        return this.createNamePropSelection(subject, object, templateArgs).apply(concreteShape);
    }

    @Override
    public Var createPredicateVariable(Selectable selectable, Var subject) {
        return new TempVar(subject, Objects.toString(selectable.getAlias(), "so_name"));
    }

    public static boolean isThereConcreteSubtypesWithDifferentName(Shape shape) {
        return shape.isAbstract() && shape.getConcreteSubTypes().stream().map(Shape::getNameIri).filter(Objects::nonNull).distinct().count() > 1L;
    }

    private SparqlNode computeNameBasedOnType(Collection<Shape> subTypes, Var subject, Var object, ConstraintGenerator constraintGenerator, Selectable selection) {
        subTypes.removeIf(shape -> shape.getName() == null);
        if (subTypes.isEmpty()) {
            return Empty.INSTANCE;
        }
        TriplePatternBlock block = new TriplePatternBlock();
        Object templateArgs = selection.getArguments().get((Object)"args");
        Map<SparqlNode, List<Shape>> nameMapping = subTypes.stream().collect(Collectors.groupingBy(this.createNamePropSelection(subject, object, templateArgs)));
        nameMapping.forEach(this.createNameSelectionBlock(constraintGenerator, subject, block::addNode, selection.getParent()));
        if (block.getPatterns().size() == 1) {
            return block.getPatterns().get(0);
        }
        return block;
    }

    private Function<Shape, SparqlNode> createNamePropSelection(Var subject, Var object, Object templateArgs) {
        return shape -> {
            if (shape.getNameTemplate() != null) {
                String nameTemplate = SparqlBuilderUtil.applyTemplateArguments(shape.getNameTemplate(), templateArgs);
                return SparqlFragment.create(nameTemplate, subject, object);
            }
            PropertyShape nameProperty = shape.getProperty(shape.getNameIri()).orElse(null);
            if (nameProperty == null) {
                return Empty.INSTANCE;
            }
            Template template = nameProperty.getSparqlTemplate();
            if (template != null) {
                return SparqlFragment.create(SparqlBuilderUtil.applyTemplateArguments(template, templateArgs), subject, object);
            }
            return new TriplePattern((Value)subject, (Value)new Iri(shape.getNameIri()), object);
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Collection<Shape> getSubTypes(Selectable parentSelection, Shape definedInType) {
        String parentId = definedInType.getId();
        if (parentSelection == null) return definedInType.getContainedIn().getConcreteSubTypes(parentId);
        SomlSchema somlSchema = definedInType.getContainedIn().getContainedIn();
        Prefixes prefixes = somlSchema.getPrefixes();
        String typeIri = prefixes.nameToShortIri(parentSelection.getType());
        Shape concreteContainingType = (Shape)somlSchema.getObjects().get((Object)typeIri);
        if (definedInType.getId().equals(typeIri) || concreteContainingType == null) return definedInType.getContainedIn().getConcreteSubTypes(parentId);
        if (concreteContainingType.getName() == null) {
            if (!concreteContainingType.isAbstract()) return new LinkedList<Shape>();
            parentId = concreteContainingType.getId();
            return definedInType.getContainedIn().getConcreteSubTypes(parentId);
        } else {
            LinkedList<Shape> concreteType = new LinkedList<Shape>();
            concreteType.add(concreteContainingType);
            return concreteType;
        }
    }

    private BiConsumer<SparqlNode, List<Shape>> createNameSelectionBlock(ConstraintGenerator constraintGenerator, Var subject, Consumer<SparqlNode> nodeConsumer, Selectable parent) {
        return (nameIriPattern, shapes) -> {
            Set rdfTypes = shapes.stream().map(Shape::getId).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
            nodeConsumer.accept(new BoTypeFragment(constraintGenerator, actionFilter -> Optional.empty(), Constraints.fromShapeIds((Set)rdfTypes), (SparqlNode)nameIriPattern, subject, parent));
        };
    }
}

