/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler.querymodel;

import com.ontotext.graphql.compiler.querymodel.Empty;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.TriplePatternBlock;
import com.ontotext.graphql.compiler.querymodel.UnionNode;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class UnionCollection
implements SparqlNode {
    private static final TriplePatternBlock EMPTY_BLOCK = new TriplePatternBlock();
    private LinkedList<UnionNode> nodes;

    public UnionCollection() {
        this.nodes = new LinkedList();
    }

    public UnionCollection(List<UnionNode> unionNodes) {
        this.nodes = new LinkedList<UnionNode>(unionNodes);
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public void addNode(SparqlNode node) {
        Objects.requireNonNull(node);
        if (node instanceof UnionNode) {
            this.nodes.add((UnionNode)node);
        } else if (node instanceof UnionCollection) {
            this.nodes.addAll(((UnionCollection)node).nodes);
        } else if (Empty.notEmpty().test(node)) {
            this.nodes.add(new UnionNode(node));
        }
    }

    @Override
    public Stream<SparqlNode> streamNodes() {
        return this.nodes.stream().map(SparqlNode.class::cast);
    }

    @Override
    public String toSparql() {
        if (this.nodes.isEmpty()) {
            return "";
        }
        LinkedList<UnionNode> toVisualize = new LinkedList<UnionNode>(this.nodes);
        if (toVisualize.isEmpty()) {
            return "";
        }
        if (toVisualize.size() == 1) {
            toVisualize.add((UnionNode)((Object)EMPTY_BLOCK));
        }
        return toVisualize.stream().map(SparqlNode::toSparql).collect(Collectors.joining(" UNION "));
    }
}

