/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler.querymodel;

import com.ontotext.graphql.compiler.querymodel.Empty;
import com.ontotext.graphql.compiler.querymodel.FederatedBlock;
import com.ontotext.graphql.compiler.querymodel.NamedGraphTriplePatternBlock;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.TriplePatternBlock;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Union
implements SparqlNode {
    private static final TriplePatternBlock EMPTY_BLOCK = new TriplePatternBlock();
    private final List<SparqlNode> nodes;

    public Union() {
        this.nodes = new LinkedList<SparqlNode>();
    }

    public Union(TriplePatternBlock ... nodes) {
        this.nodes = Arrays.asList(nodes);
    }

    public void addNode(SparqlNode node) {
        if (node instanceof FederatedBlock || node instanceof NamedGraphTriplePatternBlock) {
            this.nodes.add(new TriplePatternBlock(node));
        } else if (node.getClass().equals(TriplePatternBlock.class)) {
            this.nodes.add(node);
        } else {
            this.nodes.add(new TriplePatternBlock(node));
        }
    }

    public void addNodeFirst(SparqlNode node) {
        this.nodes.addFirst(node);
    }

    @Override
    public String toSparql() {
        LinkedList<Object> toVisualize = new LinkedList<Object>(this.nodes.stream().filter(Empty.notEmpty()).toList());
        if (toVisualize.isEmpty()) {
            return "";
        }
        if (toVisualize.size() == 1) {
            toVisualize.add(EMPTY_BLOCK);
        }
        return toVisualize.stream().map(SparqlNode::toSparql).collect(Collectors.joining(" UNION "));
    }

    public List<SparqlNode> getNodes() {
        return this.nodes;
    }

    @Override
    public Stream<SparqlNode> streamNodes() {
        return this.nodes.stream().flatMap(SparqlNode::streamNodes);
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }
}

