/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler.querymodel;

import com.ontotext.graphql.compiler.querymodel.Empty;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.SparqlNodeSequence;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TriplePatternBlock
implements SparqlNode {
    private List<SparqlNode> patterns = new LinkedList<SparqlNode>();

    public TriplePatternBlock() {
    }

    public TriplePatternBlock(SparqlNode pattern) {
        this();
        this.addNode(pattern);
    }

    public TriplePatternBlock(SparqlNode ... patterns) {
        this();
        Collections.addAll(this.patterns, patterns);
    }

    public TriplePatternBlock(List<SparqlNode> patterns) {
        this();
        this.patterns = patterns;
    }

    @Override
    public String toSparql() {
        if (this.patterns.isEmpty()) {
            return "{ }";
        }
        return this.patterns.stream().filter(Predicate.isEqual(Empty.INSTANCE).negate()).map(SparqlNode::toSparql).collect(Collectors.joining(" ", "{ ", " }"));
    }

    public void addNode(int pos, SparqlNode node) {
        if (node == null) {
            return;
        }
        this.patterns.add(pos, node);
    }

    public TriplePatternBlock addNode(SparqlNode node) {
        if (node == null) {
            return this;
        }
        if (this.patterns.isEmpty() || !this.patterns.contains(node)) {
            this.patterns.add(node);
        }
        return this;
    }

    public int removeNode(SparqlNode node) {
        int position = this.patterns.indexOf(node);
        if (position >= 0) {
            this.patterns.remove(position);
        }
        return position;
    }

    public void addAll(Collection<? extends SparqlNode> nodes) {
        this.patterns.addAll(nodes.stream().filter(Objects::nonNull).flatMap(node -> node.getClass().equals(TriplePatternBlock.class) ? ((TriplePatternBlock)node).patterns.stream() : Stream.of(node)).filter(node -> !this.patterns.contains(node)).toList());
    }

    public void addNodeFirst(SparqlNode node) {
        if (node != null) {
            this.patterns.addFirst(node);
        }
    }

    public void addAllFirst(Collection<SparqlNode> nodes) {
        this.patterns.addAll(0, nodes);
    }

    public List<SparqlNode> getPatterns() {
        return this.patterns;
    }

    @Override
    public Stream<SparqlNode> streamNodes() {
        return this.getPatterns().stream();
    }

    public SparqlNodeSequence asSequence() {
        return new SparqlNodeSequence(this.getPatterns());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TriplePatternBlock)) {
            return false;
        }
        TriplePatternBlock that = (TriplePatternBlock)obj;
        return Objects.equals(this.patterns, that.patterns);
    }

    public int hashCode() {
        return Objects.hash(this.patterns);
    }
}

