/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler.querymodel;

import com.ontotext.graphql.compiler.querymodel.Empty;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SparqlNodeSequence
implements SparqlNode {
    private final Deque<SparqlNode> nodes;

    public SparqlNodeSequence() {
        this(new LinkedList<SparqlNode>());
    }

    public SparqlNodeSequence(SparqlNode ... nodes) {
        this(Arrays.asList(nodes));
    }

    public SparqlNodeSequence(Collection<SparqlNode> nodes) {
        this.nodes = new LinkedList<SparqlNode>(nodes);
    }

    public Deque<SparqlNode> getNodes() {
        return this.nodes;
    }

    @Override
    public Stream<SparqlNode> streamNodes() {
        return this.nodes.stream();
    }

    @Override
    public String toSparql() {
        return this.nodes.stream().filter(Predicate.isEqual(Empty.INSTANCE).negate()).map(SparqlNode::toSparql).collect(Collectors.joining(" "));
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty() || this.nodes.stream().allMatch(Predicate.isEqual(Empty.INSTANCE));
    }

    public SparqlNodeSequence add(SparqlNode node) {
        this.nodes.add(node);
        return this;
    }

    public SparqlNodeSequence addAll(SparqlNodeSequence node) {
        this.nodes.addAll(node.nodes);
        return this;
    }

    public SparqlNodeSequence addFirst(SparqlNode node) {
        this.nodes.addFirst(node);
        return this;
    }

    public static Stream<SparqlNode> flatten(SparqlNode node) {
        return node instanceof SparqlNodeSequence ? node.streamNodes() : Stream.of(node);
    }
}

