/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler.querymodel;

import com.google.common.annotations.VisibleForTesting;
import com.ontotext.graphql.compiler.querymodel.Inverse;
import com.ontotext.graphql.compiler.querymodel.Iri;
import com.ontotext.graphql.compiler.querymodel.PatternNode;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.TriplePattern;
import com.ontotext.graphql.compiler.querymodel.Value;
import com.ontotext.graphql.compiler.querymodel.Var;
import com.ontotext.soaas.common.SparqlUtil;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class SparqlFragment
extends PatternNode {
    private static final ThreadLocal<AtomicLong> VAR_OFFSET_IDX = ThreadLocal.withInitial(AtomicLong::new);
    private static final Pattern BIND_PATTERN = Pattern.compile("BIND\\((?<value>.+?) as (?<var>[?$]\\w+)\\)");
    private static final Pattern SELECT_PATTERN = Pattern.compile("\\b[sS][eE][lL][eE][cC][tT]\\b");
    private static final Pattern PREFIX_PATTERN = Pattern.compile("\\W([\\w-]+):");
    private static final String SUBJECT_VAR = "_subject";
    private static final String VALUE_VAR = "_value";
    private static final String LEADIN_DOT = "^\\.";
    private final String fragmentBody;
    private final boolean inverse;
    private final long offset;
    private Set<Var> publicVars;
    private boolean processed = false;

    SparqlFragment(Value subject, String fragmentBody, Value object, boolean inverse, boolean restrictive) {
        super(subject, object, restrictive);
        this.fragmentBody = fragmentBody;
        this.inverse = inverse;
        this.offset = VAR_OFFSET_IDX.get().getAndIncrement();
    }

    public static void resetVariableOffset() {
        VAR_OFFSET_IDX.remove();
    }

    public static PatternNode convertIfNeeded(TriplePattern pattern) {
        Inverse inverse;
        String inverseValue;
        Value subject = pattern.getSubject();
        Value predicate = pattern.getPredicate();
        Value object = pattern.getObject();
        if (predicate instanceof Iri && SparqlUtil.isSparqlTemplate((String)predicate.getName())) {
            return SparqlFragment.create(predicate.getName(), subject, object, pattern.isRestrictive());
        }
        if (predicate instanceof Inverse && SparqlUtil.isSparqlTemplate((String)(inverseValue = (inverse = (Inverse)predicate).toIri().getName()))) {
            return SparqlFragment.createInverse(inverseValue, subject, object, pattern.isRestrictive());
        }
        return pattern;
    }

    public static SparqlFragment create(String fragmentBody, Var subject, Var object) {
        return SparqlFragment.create(fragmentBody, subject, object, false, false, false);
    }

    public static SparqlFragment create(String fragmentBody, Value subject, Value object, boolean restrictive) {
        return SparqlFragment.create(fragmentBody, subject, object, false, false, restrictive);
    }

    public static SparqlFragment create(String fragmentBody, Value subject, Value object, boolean inSeparateBlock, boolean inverse, boolean restrictive) {
        Object fragment = fragmentBody;
        if (inSeparateBlock || SparqlFragment.containsSelect((String)fragment)) {
            fragment = "{" + (String)fragment + "}";
        }
        if (subject == null) {
            subject = new Var(SUBJECT_VAR);
        }
        if (object == null) {
            object = new Var(VALUE_VAR);
        }
        return new SparqlFragment(subject, (String)fragment, object, inverse, restrictive);
    }

    public static SparqlFragment createInverse(String fragmentBody, Value subject, Value object, boolean restrictive) {
        return SparqlFragment.create(fragmentBody, subject, object, false, true, restrictive);
    }

    private static boolean containsSelect(String fragment) {
        return SELECT_PATTERN.matcher(fragment).find();
    }

    @Override
    public String toSparql() {
        Value newSubject = this.resolveSubject();
        String subjectVar = "?_subject";
        if (newSubject != null) {
            subjectVar = newSubject.toSparql();
            subjectVar = newSubject instanceof Var ? subjectVar.substring(1) : subjectVar;
        }
        Value newObject = this.resolveObject();
        String valueVar = "?_value";
        if (newObject != null) {
            valueVar = newObject.toSparql();
            valueVar = newObject instanceof Var ? valueVar.substring(1) : valueVar;
        }
        this.processed = true;
        return this.replaceBodyVars(SparqlFragment.escapePrefixes(this.fragmentBody), subjectVar, valueVar);
    }

    private Value resolveObject() {
        return this.inverse ? this.getSubject() : this.getObject();
    }

    private Value resolveSubject() {
        return this.inverse ? this.getObject() : this.getSubject();
    }

    private String replaceBodyVars(String body, String subject, String object) {
        AtomicInteger singleBlocks = new AtomicInteger();
        AtomicInteger doubleBlocks = new AtomicInteger();
        AtomicInteger tripleBlocks = new AtomicInteger();
        Matcher matcher = SparqlUtil.VAR_PATTERN_WITH_PATH.matcher(body);
        StringBuilder resultBody = new StringBuilder();
        int idx = 0;
        while (matcher.find(idx)) {
            String variable = matcher.group(1);
            resultBody.append(body, idx, matcher.start(1));
            SparqlFragment.countStringBoundaries(body, idx, matcher.start(1), singleBlocks, doubleBlocks, tripleBlocks);
            if (variable.startsWith(SUBJECT_VAR)) {
                this.replaceSpecialVar(subject, resultBody, variable, SUBJECT_VAR, this.resolveSubject());
            } else if (variable.startsWith(VALUE_VAR)) {
                this.replaceSpecialVar(object, resultBody, variable, VALUE_VAR, this.resolveObject());
            } else if (variable.startsWith("_")) {
                this.addPublicVar(this.resolveSubject(), variable.substring(1));
                resultBody.append(subject).append(variable.replace('.', '_'));
            } else {
                resultBody.append(variable);
                if (singleBlocks.get() % 2 == 0 && doubleBlocks.get() % 2 == 0 && tripleBlocks.get() % 2 == 0) {
                    resultBody.append("_").append(this.offset);
                }
            }
            idx = matcher.end(1);
        }
        resultBody.append(body, idx, body.length());
        return resultBody.toString();
    }

    private void replaceSpecialVar(String replacement, StringBuilder resultBody, String currentVar, String specialVarName, Value value) {
        String subjectVarName = currentVar.replace(specialVarName, replacement);
        if (subjectVarName.length() > replacement.length()) {
            this.addPublicVar(value, currentVar.replace(specialVarName, "").replaceFirst(LEADIN_DOT, ""));
        }
        resultBody.append(subjectVarName.replace('.', '_'));
    }

    private void addPublicVar(Value parentVar, String subVarName) {
        if (this.publicVars == null) {
            this.publicVars = new LinkedHashSet<Var>();
        }
        String[] subVars = subVarName.split("\\.");
        Var lastVar = new Var((Var)parentVar, subVars[0]);
        this.publicVars.add(lastVar);
        for (int i = 1; i < subVars.length; ++i) {
            lastVar = new Var(lastVar, subVars[i]);
            this.publicVars.add(lastVar);
        }
    }

    private static String escapePrefixes(String body) {
        AtomicInteger singleBlocks = new AtomicInteger();
        AtomicInteger doubleBlocks = new AtomicInteger();
        AtomicInteger tripleBlocks = new AtomicInteger();
        Matcher matcher = PREFIX_PATTERN.matcher(body);
        StringBuilder resultBody = new StringBuilder();
        int idx = 0;
        while (matcher.find(idx)) {
            String prefix = matcher.group(1);
            resultBody.append(body, idx, matcher.start(1));
            SparqlFragment.countStringBoundaries(body, idx, matcher.start(1), singleBlocks, doubleBlocks, tripleBlocks);
            if (prefix.contains("-")) {
                if (singleBlocks.get() % 2 == 0 && doubleBlocks.get() % 2 == 0 && tripleBlocks.get() % 2 == 0) {
                    resultBody.append(prefix.replace('-', '_'));
                } else {
                    resultBody.append(prefix);
                }
            } else {
                resultBody.append(prefix);
            }
            idx = matcher.end(1);
        }
        resultBody.append(body, idx, body.length());
        return resultBody.toString();
    }

    @VisibleForTesting
    static void countStringBoundaries(String searchIn, int from, int to, AtomicInteger singleBlocks, AtomicInteger doubleBlocks, AtomicInteger tripleBlocks) {
        for (int i = from; i < to; ++i) {
            char charAt = searchIn.charAt(i);
            if (charAt == '\"') {
                if (!SparqlFragment.isNotEscaped(searchIn, i)) continue;
                doubleBlocks.incrementAndGet();
                continue;
            }
            if (charAt != '\'') continue;
            if (SparqlFragment.isMultilineBlock(searchIn, i)) {
                tripleBlocks.incrementAndGet();
                i += 2;
                continue;
            }
            if (!SparqlFragment.isNotEscaped(searchIn, i)) continue;
            singleBlocks.incrementAndGet();
        }
    }

    private static boolean isMultilineBlock(String searchIn, int idx) {
        return idx + 2 < searchIn.length() && searchIn.charAt(idx + 1) == '\'' && searchIn.charAt(idx + 2) == '\'';
    }

    private static boolean isNotEscaped(String searchIn, int idx) {
        return idx == 0 || searchIn.charAt(idx - 1) != '\\';
    }

    public Optional<String> getBindValue(Object variable) {
        String varName;
        if (variable instanceof String) {
            varName = variable.toString();
        } else if (variable instanceof Var) {
            Var asVar = (Var)variable;
            varName = asVar.toSparql();
        } else {
            throw new IllegalArgumentException("Unsupported var identifier: " + String.valueOf(variable));
        }
        Matcher matcher = BIND_PATTERN.matcher(this.toSparql());
        int startPos = 0;
        while (matcher.find(startPos)) {
            String foundVarName = matcher.group("var");
            if (varName.equals(foundVarName)) {
                return Optional.of(matcher.group("value"));
            }
            startPos = matcher.end("var");
        }
        return Optional.empty();
    }

    @Override
    public Stream<SparqlNode> streamNodes() {
        if (!this.processed) {
            this.toSparql();
        }
        if (this.publicVars == null) {
            return super.streamNodes();
        }
        return Stream.concat(Stream.of(this.getSubject()), Stream.concat(this.publicVars.stream(), Stream.of(this.getObject())));
    }

    @Override
    public Stream<String> getUsedPrefixes() {
        Matcher matcher = PREFIX_PATTERN.matcher(this.fragmentBody);
        LinkedHashSet<String> prefixes = new LinkedHashSet<String>();
        int start = 0;
        while (matcher.find(start)) {
            prefixes.add(matcher.group(1).replace('-', '_'));
            start = matcher.end(1);
        }
        return prefixes.stream();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SparqlFragment)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        SparqlFragment fragment = (SparqlFragment)obj;
        return Objects.equals(this.fragmentBody, fragment.fragmentBody);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fragmentBody);
    }
}

