/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler.querymodel;

import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import java.util.Objects;
import java.util.stream.Stream;

public class Filter
implements SparqlNode {
    private SparqlNode node;

    public Filter(SparqlNode node) {
        this.node = node;
    }

    @Override
    public String toSparql() {
        String subNodeSparql = this.node.toSparql();
        boolean appendBrackets = !subNodeSparql.startsWith("(");
        return "FILTER " + (appendBrackets ? "(" : "") + subNodeSparql + (appendBrackets ? ")" : "");
    }

    @Override
    public Stream<SparqlNode> streamNodes() {
        return Stream.concat(Stream.of(this.node), this.node.streamNodes());
    }

    public SparqlNode getNode() {
        return this.node;
    }

    public String toString() {
        return this.toSparql();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Filter)) {
            return false;
        }
        Filter filter = (Filter)obj;
        return Objects.equals(this.node, filter.node);
    }

    public int hashCode() {
        return Objects.hash(this.node);
    }
}

