/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler.querymodel;

import com.google.common.collect.Streams;
import com.ontotext.graphql.compiler.querymodel.Empty;
import com.ontotext.graphql.compiler.querymodel.Iri;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.TriplePatternBlock;
import java.util.Objects;
import java.util.stream.Stream;

public class FederatedBlock
extends TriplePatternBlock {
    private final Iri service;

    public FederatedBlock(Iri service) {
        this.service = Objects.requireNonNull(service);
    }

    public FederatedBlock(Iri service, TriplePatternBlock innerBlock) {
        super(innerBlock.getPatterns());
        this.service = service;
    }

    public FederatedBlock(Iri service, SparqlNode ... nodes) {
        super(nodes);
        this.service = service;
    }

    public static FederatedBlock of(Iri service, SparqlNode node) {
        if (node instanceof TriplePatternBlock) {
            return new FederatedBlock(service, (TriplePatternBlock)node);
        }
        FederatedBlock federatedBlock = new FederatedBlock(service);
        federatedBlock.addNode(node);
        return federatedBlock;
    }

    public Iri getService() {
        return this.service;
    }

    @Override
    public String toSparql() {
        block3: {
            block2: {
                if (this.getPatterns().isEmpty()) break block2;
                if (!this.getPatterns().stream().flatMap(SparqlNode::streamNodes).allMatch(Empty.INSTANCE::equals)) break block3;
            }
            return "";
        }
        return String.format(" SERVICE %s %s ", this.service.toSparql(), super.toSparql());
    }

    @Override
    public Stream<SparqlNode> streamNodes() {
        return Streams.concat((Stream[])new Stream[]{super.streamNodes(), Stream.of(this.service)});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        FederatedBlock that = (FederatedBlock)obj;
        return Objects.equals(this.service, that.service);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.service);
    }
}

