/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler.querymodel;

import com.ontotext.graphql.compiler.querymodel.AbstractQuery;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.TriplePatternBlock;
import com.ontotext.graphql.compiler.querymodel.Value;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DeleteInsertQuery
extends AbstractQuery {
    private Value withGraph;
    private List<Value> usingGraphs;
    private List<Value> usingNamedGraphs;
    private final TriplePatternBlock delete = new TriplePatternBlock();
    private final TriplePatternBlock insert = new TriplePatternBlock();
    private final TriplePatternBlock where = new TriplePatternBlock();

    @Override
    public String toSparql() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toSparql());
        if (this.withGraph != null) {
            builder.append(" WITH ").append(this.withGraph.toSparql()).append(" ");
        }
        if (DeleteInsertQuery.isPresent(this.delete)) {
            builder.append("DELETE ");
            builder.append(this.delete.toSparql()).append(" ");
        }
        if (DeleteInsertQuery.isPresent(this.insert)) {
            builder.append("INSERT ");
            builder.append(this.insert.toSparql()).append(" ");
        }
        if (this.usingGraphs != null) {
            builder.append(this.usingGraphs.stream().map(node -> "USING " + node.toSparql()).collect(Collectors.joining(" "))).append(" ");
        }
        if (this.usingNamedGraphs != null) {
            builder.append(this.usingNamedGraphs.stream().map(node -> "USING NAMED " + node.toSparql()).collect(Collectors.joining(" "))).append(" ");
        }
        builder.append("WHERE ").append(this.where.toSparql());
        return builder.toString();
    }

    private static boolean isPresent(TriplePatternBlock block) {
        return block != null && !block.getPatterns().isEmpty();
    }

    public TriplePatternBlock getDelete() {
        return this.delete;
    }

    public TriplePatternBlock getInsert() {
        return this.insert;
    }

    public TriplePatternBlock getWhere() {
        return this.where;
    }

    @Override
    public Stream<SparqlNode> streamNodes() {
        Stream.Builder<Value> builder = Stream.builder();
        if (this.withGraph != null) {
            builder.add(this.withGraph);
        }
        if (this.usingGraphs != null) {
            this.usingGraphs.forEach(builder);
        }
        if (this.usingNamedGraphs != null) {
            this.usingNamedGraphs.forEach(builder);
        }
        return Stream.concat(builder.build(), Stream.of(this.delete, this.insert, this.where).flatMap(SparqlNode::streamNodes));
    }

    public void setWithGraph(Value withGraph) {
        this.withGraph = withGraph;
    }

    public Value getWithGraph() {
        return this.withGraph;
    }

    public void addUsingGraph(Value usingGraph) {
        if (this.usingGraphs == null) {
            this.usingGraphs = new LinkedList<Value>();
        }
        this.usingGraphs.add(usingGraph);
    }

    public void addUsingNamedGraph(Value usingNamedGraph) {
        if (this.usingNamedGraphs == null) {
            this.usingNamedGraphs = new LinkedList<Value>();
        }
        this.usingNamedGraphs.add(usingNamedGraph);
    }

    public List<Value> getUsingGraphs() {
        if (this.usingGraphs == null) {
            return Collections.emptyList();
        }
        return this.usingGraphs;
    }

    public List<Value> getUsingNamedGraphs() {
        if (this.usingNamedGraphs == null) {
            return Collections.emptyList();
        }
        return this.usingNamedGraphs;
    }
}

