/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler.querymodel;

import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.Value;
import java.util.Objects;
import java.util.stream.Stream;

public class Bind
implements SparqlNode {
    SparqlNode value;
    Value var;

    public Bind(SparqlNode value, Value var) {
        this.value = value;
        this.var = var;
    }

    public void setValue(SparqlNode value) {
        this.value = value;
    }

    @Override
    public String toSparql() {
        return "BIND (" + this.value.toSparql() + " as " + this.var.toSparql() + ") . ";
    }

    @Override
    public Stream<SparqlNode> streamNodes() {
        if (this.value.streamNodes().findFirst().isPresent()) {
            return Stream.concat(this.value.streamNodes(), Stream.of(this.var));
        }
        return Stream.of(this.value, this.var);
    }

    public SparqlNode getValue() {
        return this.value;
    }

    public Value getVar() {
        return this.var;
    }

    public String toString() {
        return this.toSparql();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Bind)) {
            return false;
        }
        Bind bind = (Bind)obj;
        return Objects.equals(this.value, bind.value) && Objects.equals(this.var, bind.var);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.var);
    }
}

