/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler;

import com.ontotext.graphql.compiler.ConstraintGenerator;
import com.ontotext.graphql.compiler.FilterBuildResult;
import com.ontotext.graphql.compiler.FilterBuilder;
import com.ontotext.graphql.compiler.FilterFactory;
import com.ontotext.graphql.compiler.SparqlBuilderUtil;
import com.ontotext.graphql.compiler.SparqlCompileException;
import com.ontotext.graphql.compiler.querymodel.Iri;
import com.ontotext.graphql.compiler.querymodel.PatternNode;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.TriplePatternBlock;
import com.ontotext.graphql.compiler.querymodel.Value;
import com.ontotext.graphql.compiler.querymodel.Var;
import com.ontotext.models.ActionFilter;
import com.ontotext.models.Constraints;
import com.ontotext.models.Operation;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Selectable;
import com.ontotext.models.Shape;
import com.ontotext.models.query.Arguments;
import com.ontotext.models.subscriptions.Subscription;
import com.ontotext.soaas.common.sparql.OperationBuilderOptions;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class PatternBuilder {
    private final Supplier<FilterBuilder> filterBuilder;
    private final ConstraintGenerator constraintGenerator;
    private final OperationBuilderOptions options;
    private final FilterFactory filterFactory;

    PatternBuilder(Supplier<FilterBuilder> filterBuilder, ConstraintGenerator constraintGenerator, OperationBuilderOptions options, FilterFactory filterFactory) {
        this.filterBuilder = filterBuilder;
        this.constraintGenerator = constraintGenerator;
        this.options = options;
        this.filterFactory = filterFactory;
    }

    public PatternNode createTriplePattern(Selectable selection, Var subject) {
        Var varName = new Var(subject, selection.getResponseName(), selection.isCollection());
        Arguments arguments = selection.getArguments();
        boolean isUsedForFiltering = arguments.getOrder().isPresent() || arguments.isAscendingOrder().isPresent();
        return this.createPatternNode(subject, selection, varName, isUsedForFiltering);
    }

    public PatternNode createPatternNode(Var subject, Selectable selection, Var object, boolean usedForFiltering) {
        Value predicate = this.getRealPredicate(selection, usedForFiltering);
        return PatternNode.createPattern(subject, predicate, object, selection.isRestrictive());
    }

    private Value getRealPredicate(Selectable selection, boolean usedForFilters) {
        return selection.getCountedSelection().map(countedSelection -> this.createPropertyCountBlock((Selectable)countedSelection, usedForFilters)).orElseGet(() -> SparqlBuilderUtil.getPropertyPredicate((PropertyShape)selection.getProperty().orElseThrow(PatternBuilder.missingPropertyInModel(selection)), selection.getArguments().get((Object)"args")));
    }

    @NotNull
    private Value createPropertyCountBlock(Selectable countedSelection, boolean usedForFilters) {
        TriplePatternBlock countBlock = new TriplePatternBlock();
        Var subject = new Var("_subject");
        Var counted = new Var("counted");
        PatternNode pattern = this.createPatternNode(subject, countedSelection, counted, false);
        countBlock.addNode(pattern);
        this.addFilter(counted, countedSelection, countBlock);
        if (PatternBuilder.shouldRestrictCountSelection(countedSelection)) {
            Set<Object> fragmentSpreads;
            Optional shapeType = countedSelection.getShapeType();
            if (shapeType.filter(shape -> shape.isAbstract() || shape.isUnion()).isPresent()) {
                boolean withoutFragment = countedSelection.getSelections().stream().filter(Predicate.not(Selectable.byName((String)"__typename"))).anyMatch(Predicate.not(Selectable::isInFragment));
                fragmentSpreads = countedSelection.getSelections().stream().filter(Selectable::isInFragment).map(Selectable::getDefinedIn).collect(Collectors.toSet());
                if (withoutFragment || fragmentSpreads.isEmpty()) {
                    fragmentSpreads = Set.of(((Shape)shapeType.get()).getId());
                }
            } else {
                fragmentSpreads = shapeType.map(Shape::getId).map(Set::of).orElse(Set.of());
            }
            LinkedList<SparqlNode> sparqlNodes = new LinkedList<SparqlNode>();
            this.constraintGenerator.addBoTypeConstraint(Constraints.fromShapeIds(fragmentSpreads), sparqlNodes, ConstraintGenerator.SparqlBuildingContext.contextBuilder().subject(counted).filterGenerator(this.filterGenerator(counted)).service(countedSelection.getService()).soTypeOptimizationThreshold(this.options.getSoTypeOptimizationThreshold()).setSinglePredicateTypeOptimization(this.options.isSingleSoTypeOptimizationEnabled()).exportSoType(true).build());
            countBlock.addAll(sparqlNodes);
        }
        String suffix = "";
        if (!usedForFilters) {
            suffix = "VALUES ?_subject {}";
        }
        return new Iri(String.format("SELECT ?_subject (COUNT(?counted) as ?_value) WHERE %s GROUP BY ?_subject %s", countBlock.toSparql(), suffix));
    }

    private static boolean shouldRestrictCountSelection(Selectable countedSelection) {
        if (countedSelection.getShapeType().filter(Shape::isUnion).isPresent()) {
            return true;
        }
        if (countedSelection.isRangeCheck()) {
            return true;
        }
        if (!countedSelection.isComplexType()) {
            return false;
        }
        return countedSelection.getShapeType().filter(Shape::isAbstract).isPresent();
    }

    private static Supplier<SparqlCompileException> missingPropertyInModel(Selectable selection) {
        return () -> new SparqlCompileException(String.format("Could not find %s in the model", selection.getName()));
    }

    private Function<ActionFilter, Optional<SparqlNode>> filterGenerator(Var subject) {
        return FilterFactory.filterGenerator(subject, this.filterBuilder.get());
    }

    private void addFilter(Var subject, Selectable selectable, TriplePatternBlock block) {
        if (selectable instanceof Subscription || !(selectable instanceof Operation) && selectable.isCountSelection()) {
            return;
        }
        Optional<FilterBuildResult> filterBuildResult = this.filterFactory.getFilterFromExistingBuilder(subject, selectable, this.filterBuilder.get());
        filterBuildResult.ifPresent(result -> block.addNode(result.getSparql()));
    }
}

