/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler;

import com.ontotext.graphql.compiler.ConstraintGenerator;
import com.ontotext.graphql.compiler.EntityUpdateSparqlGenerator;
import com.ontotext.graphql.compiler.FilterFactory;
import com.ontotext.graphql.compiler.FilterVarProvider;
import com.ontotext.graphql.compiler.PatternBuilder;
import com.ontotext.graphql.compiler.SparqlBuilderUtil;
import com.ontotext.graphql.compiler.SparqlCompileException;
import com.ontotext.graphql.compiler.SparqlTermFunctions;
import com.ontotext.graphql.compiler.SpecialPredicates;
import com.ontotext.graphql.compiler.querymodel.And;
import com.ontotext.graphql.compiler.querymodel.Empty;
import com.ontotext.graphql.compiler.querymodel.Equals;
import com.ontotext.graphql.compiler.querymodel.Exists;
import com.ontotext.graphql.compiler.querymodel.FederatedBlock;
import com.ontotext.graphql.compiler.querymodel.Filter;
import com.ontotext.graphql.compiler.querymodel.FilterVar;
import com.ontotext.graphql.compiler.querymodel.Gt;
import com.ontotext.graphql.compiler.querymodel.Gte;
import com.ontotext.graphql.compiler.querymodel.In;
import com.ontotext.graphql.compiler.querymodel.Inverse;
import com.ontotext.graphql.compiler.querymodel.Iri;
import com.ontotext.graphql.compiler.querymodel.Literal;
import com.ontotext.graphql.compiler.querymodel.Lt;
import com.ontotext.graphql.compiler.querymodel.Lte;
import com.ontotext.graphql.compiler.querymodel.Minus;
import com.ontotext.graphql.compiler.querymodel.Not;
import com.ontotext.graphql.compiler.querymodel.NotEquals;
import com.ontotext.graphql.compiler.querymodel.Or;
import com.ontotext.graphql.compiler.querymodel.PatternNode;
import com.ontotext.graphql.compiler.querymodel.Regex;
import com.ontotext.graphql.compiler.querymodel.SelectDistinct;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.SparqlNodeSequence;
import com.ontotext.graphql.compiler.querymodel.TriplePatternBlock;
import com.ontotext.graphql.compiler.querymodel.Value;
import com.ontotext.graphql.compiler.querymodel.Var;
import com.ontotext.graphql.compiler.querymodel.functions.Contains;
import com.ontotext.graphql.compiler.querymodel.functions.StringEnds;
import com.ontotext.graphql.compiler.querymodel.functions.StringStarts;
import com.ontotext.graphql.compiler.querymodel.functions.UpperCase;
import com.ontotext.graphql.compiler.specialpredicates.BoType;
import com.ontotext.graphql.parser.argument.optimization.AbstractFilterOptimization;
import com.ontotext.graphql.parser.argument.optimization.FilterExpressionOptimization;
import com.ontotext.graphql.parser.argument.optimization.FilterExpressionOptimizer;
import com.ontotext.graphql.parser.argument.optimization.OptimizationContext;
import com.ontotext.graphql.parser.argument.optimization.RemoveSingleExpressions;
import com.ontotext.models.Constraints;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Selectable;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.query.AbstractExpressionVisitor;
import com.ontotext.models.query.All;
import com.ontotext.models.query.AllExists;
import com.ontotext.models.query.CaseInsensitiveRegex;
import com.ontotext.models.query.CaseInsensitiveRegexMismatch;
import com.ontotext.models.query.Expression;
import com.ontotext.models.query.ExpressionCollection;
import com.ontotext.models.query.ExpressionTerm;
import com.ontotext.models.query.ExpressionTraverserContext;
import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.ExpressionVisitor;
import com.ontotext.models.query.ExpressionVisitorContext;
import com.ontotext.models.query.FilterExpressionTraverser;
import com.ontotext.models.query.GreaterThan;
import com.ontotext.models.query.GreaterThanEquals;
import com.ontotext.models.query.LessThan;
import com.ontotext.models.query.LessThanEquals;
import com.ontotext.models.query.Node;
import com.ontotext.models.query.NotIn;
import com.ontotext.models.query.RegexMismatch;
import com.ontotext.models.query.StringContains;
import com.ontotext.models.query.StringEndsWith;
import com.ontotext.models.query.StringStartWith;
import com.ontotext.models.query.TraversalControl;
import com.ontotext.models.query.UniqueLang;
import com.ontotext.soaas.common.sparql.OperationBuilderOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class FilterBuilder
implements ExpressionVisitor<SparqlNode, Context> {
    private static final Pattern ANY_LANG = Pattern.compile("['\"]\\*['\"]");
    private final SomlSchema schema;
    private final ConstraintGenerator constraintGenerator;
    private final OperationBuilderOptions options;
    private final FilterVarProvider varProvider;
    private final PatternBuilder patternBuilder;
    private final FilterExpressionOptimizer langFilterRemover = new FilterExpressionOptimizer().addOptimization((FilterExpressionOptimization)new AbstractFilterOptimization(this){

        public TraversalControl visit(Node target, OptimizationContext context) {
            if (target.getPropertyShape().getName().equals("lang")) {
                context.removeCurrent();
                return TraversalControl.CANCEL;
            }
            return TraversalControl.CONTINUE;
        }
    }).addOptimization((FilterExpressionOptimization)new RemoveSingleExpressions());

    public FilterBuilder(SomlSchema schema, ConstraintGenerator constraintGenerator, OperationBuilderOptions options, FilterFactory filterFactory) {
        this.schema = schema;
        this.constraintGenerator = constraintGenerator;
        this.options = options;
        this.varProvider = new FilterVarProvider(2);
        this.patternBuilder = new PatternBuilder(() -> this, constraintGenerator, options, filterFactory);
    }

    public FilterBuilder(FilterBuilder filterBuilder) {
        this.schema = filterBuilder.schema;
        this.constraintGenerator = filterBuilder.constraintGenerator;
        this.varProvider = filterBuilder.varProvider;
        this.options = filterBuilder.options;
        this.patternBuilder = filterBuilder.patternBuilder;
    }

    public SparqlNode visit(All target, Context context) {
        throw new UnsupportedOperationException();
    }

    public SparqlNode visit(AllExists target, Context context) {
        throw new UnsupportedOperationException();
    }

    public SparqlNode visit(com.ontotext.models.query.And target, Context context) {
        if (target.getTerms().isEmpty()) {
            return Empty.INSTANCE;
        }
        return this.processAnd((Expression)target, context);
    }

    public SparqlNode visit(CaseInsensitiveRegex target, Context context) {
        context.checkBlankNodeNeeded(false);
        return this.contextAwareFilter(this.processRegex(context, target.getValue(), false), context, false);
    }

    public SparqlNode visit(CaseInsensitiveRegexMismatch target, Context context) {
        context.checkBlankNodeNeeded(false);
        return this.contextAwareFilter(this.processRegex(context, target.getValue(), false), context, true);
    }

    public SparqlNode visit(com.ontotext.models.query.Equals target, Context context) {
        Value value = this.getValue(target.getValue());
        SparqlNode var = FilterBuilder.getVarOrString(context, Collections.singletonList(value));
        Equals filterExpression = new Equals(var, value);
        return this.contextAwareFilter(filterExpression, context);
    }

    public SparqlNode visit(com.ontotext.models.query.Exists target, Context context) {
        if (this.isLiteralLanguage(context)) {
            return new Filter(SparqlTermFunctions.hasLanguageCheck(context.parent));
        }
        if (target.getValue() == null) {
            return Empty.INSTANCE;
        }
        SparqlNode node = this.processAnd((Expression)target, context);
        if (FilterBuilder.isLiteralLangExistCheck(target, context)) {
            return node;
        }
        return this.wrapNodeInFilterExists(node, context);
    }

    public SparqlNode visit(GreaterThan target, Context context) {
        return this.contextAwareFilter(new Gt(context.parent, this.getValue(target.getValue())), context);
    }

    public SparqlNode visit(GreaterThanEquals target, Context context) {
        return this.contextAwareFilter(new Gte(context.parent, this.getValue(target.getValue())), context);
    }

    public SparqlNode visit(com.ontotext.models.query.In target, Context context) {
        List values = (List)target.getValue();
        return this.contextAwareFilter(this.processInValues(values, context), context);
    }

    public SparqlNode visit(LessThan target, Context context) {
        return this.contextAwareFilter(new Lt(context.parent, this.getValue(target.getValue())), context);
    }

    public SparqlNode visit(LessThanEquals target, Context context) {
        return this.contextAwareFilter(new Lte(context.parent, this.getValue(target.getValue())), context);
    }

    public SparqlNode visit(com.ontotext.models.query.Minus target, Context context) {
        SparqlNode innerNode = this.combineInAnd(this.processForTerms(context, target.getTerms()), false);
        return new Minus(innerNode);
    }

    public SparqlNode visit(Node target, Context context) {
        LinkedList<SparqlNode> sparqlNodes = new LinkedList<SparqlNode>();
        boolean putInFederationBlock = this.shouldPutNodeInFederatedBlock(target, context);
        String serviceInWhichTheNodeShouldBe = putInFederationBlock ? this.getServiceInWhichANodeShouldBe(target) : context.service;
        Var childVar = FilterBuilder.hasUniqueLangFilter((ExpressionValue)target.getValue()) ? this.createChildVar(target, context) : this.addNodePatternSelection(target, context, sparqlNodes);
        Selectable childSelection = this.findSelectionFor(context, target);
        Context childContext = context.createSubContext(childVar, childSelection, serviceInWhichTheNodeShouldBe, target.isUCase());
        SparqlNode childNode = (SparqlNode)((Expression)target.getValue()).accept((ExpressionVisitor)this, (ExpressionVisitorContext)childContext);
        sparqlNodes.add(childNode);
        if (sparqlNodes.stream().allMatch(Predicate.isEqual(Empty.INSTANCE))) {
            return Empty.INSTANCE;
        }
        SparqlNode combined = this.combineInAnd(sparqlNodes, false);
        if (putInFederationBlock) {
            combined = FederatedBlock.of(new Iri(serviceInWhichTheNodeShouldBe), combined);
        }
        return combined;
    }

    public SparqlNode visit(com.ontotext.models.query.Not target, Context context) {
        return this.processAnd((Expression)target, context.createNegateContext());
    }

    public SparqlNode visit(com.ontotext.models.query.NotEquals target, Context context) {
        context.checkBlankNodeNeeded(false);
        return this.contextAwareFilter(new NotEquals(context.parent, this.getValue(target.getValue())), context);
    }

    public SparqlNode visit(NotIn target, Context context) {
        List values = (List)target.getValue();
        return this.contextAwareFilter(this.processInValues(values, context), context, true);
    }

    public SparqlNode visit(com.ontotext.models.query.Or target, Context context) {
        return this.processOr((Expression)target, context);
    }

    public SparqlNode visit(com.ontotext.models.query.Regex target, Context context) {
        context.checkBlankNodeNeeded(false);
        return this.contextAwareFilter(this.processRegex(context, target.getValue(), true), context, false);
    }

    public SparqlNode visit(RegexMismatch target, Context context) {
        context.checkBlankNodeNeeded(false);
        return this.contextAwareFilter(this.processRegex(context, target.getValue(), true), context, true);
    }

    public SparqlNode visit(com.ontotext.models.query.SelectDistinct target, Context context) {
        LinkedList<SparqlNode> nodes = new LinkedList<SparqlNode>();
        this.constraintGenerator.addBoTypeConstraint(Constraints.fromShapeIds((String[])new String[]{this.schema.getPrefixes().nameToShortIri(context.selection.getType())}), nodes, ConstraintGenerator.SparqlBuildingContext.contextBuilder().subject(context.parent).boTypeAlias(BoType.getAlias(context.selection)).build());
        SparqlNode innerNode = this.combineInAnd(this.processForTerms(context, target.getTerms()), false);
        nodes.add(innerNode);
        return new SelectDistinct(context.parent, new SparqlNodeSequence(nodes));
    }

    public SparqlNode visit(com.ontotext.models.query.Value target, Context context) {
        if (target.getValue() instanceof ExpressionValue) {
            return (SparqlNode)((ExpressionValue)target.getValue()).accept((ExpressionVisitor)this, (ExpressionVisitorContext)context);
        }
        return Empty.INSTANCE;
    }

    public SparqlNode visit(ExpressionCollection target, Context context) {
        List terms = target.getTerms();
        if (terms.isEmpty()) {
            return Empty.INSTANCE;
        }
        if (terms.size() == 1) {
            return (SparqlNode)((ExpressionTerm)terms.get(0)).accept((ExpressionVisitor)this, (ExpressionVisitorContext)context);
        }
        SparqlNodeSequence sequence = new SparqlNodeSequence();
        for (ExpressionTerm term : terms) {
            sequence.add((SparqlNode)term.accept((ExpressionVisitor)this, (ExpressionVisitorContext)context));
        }
        return sequence;
    }

    public SparqlNode visit(StringStartWith target, Context context) {
        context.checkBlankNodeNeeded(true);
        if (this.isLiteralLanguage(context)) {
            return this.contextAwareFilter(SparqlTermFunctions.langMatches(context.parent, target.getValue().toString()), context);
        }
        return this.contextAwareFilter(new StringStarts((SparqlNode)context.parent, target.getValue().toString()), context);
    }

    public SparqlNode visit(StringEndsWith target, Context context) {
        context.checkBlankNodeNeeded(true);
        return this.contextAwareFilter(new StringEnds((SparqlNode)context.parent, target.getValue().toString()), context);
    }

    public SparqlNode visit(StringContains target, Context context) {
        context.checkBlankNodeNeeded(true);
        return this.contextAwareFilter(new Contains((SparqlNode)context.parent, target.getValue().toString()), context);
    }

    public SparqlNode visit(UniqueLang target, Context context) {
        this.checkIfValidTargetField(context);
        context.checkBlankNodeNeeded(true);
        if (context.not) {
            return this.createNoneUniqueFilter(target, context);
        }
        return this.createUniqueFilter(target, context);
    }

    private Var addNodePatternSelection(Node target, Context context, List<SparqlNode> parentBlock) {
        Var childVar;
        String propName = target.getName();
        Selectable nodeSelection = this.findSelectionFor(context, target);
        LinkedList<SparqlNode> sparqlNodes = new LinkedList<SparqlNode>();
        if (SpecialPredicates.get(propName).isPresent()) {
            this.addSpecialPredicateSelection(context, sparqlNodes, propName, nodeSelection);
            Var object = SpecialPredicates.getVar(propName, nodeSelection, context.parent).orElseThrow(IllegalStateException::new);
            childVar = "id".equals(propName) ? context.parent : this.varProvider.getExistingVar(object).orElse(context.parent);
            if ("lang".equals(propName) && target.isExistsCheck()) {
                sparqlNodes.add(this.contextAwareFilter(SparqlTermFunctions.hasLanguageCheck(childVar), context));
            }
        } else {
            childVar = this.varProvider.getNewVar(new Var(context.parent, propName));
            this.addNormalPredicateSelection(context, sparqlNodes, nodeSelection, childVar);
        }
        if (nodeSelection.isRangeCheck()) {
            this.constraintGenerator.addBoTypeConstraint(Constraints.fromShapeIds((String[])new String[]{this.schema.getPrefixes().nameToShortIri(nodeSelection.getType())}), sparqlNodes, ConstraintGenerator.SparqlBuildingContext.contextBuilder().subject(childVar).boTypeAlias(BoType.getAlias(nodeSelection)).varProcessor(this.changeVarToFilterVar()).build());
        }
        parentBlock.addAll(sparqlNodes);
        return childVar;
    }

    protected void addNormalPredicateSelection(Context context, List<SparqlNode> sparqlNodes, Selectable nodeSelection, Var childVar) {
        sparqlNodes.add(this.patternBuilder.createPatternNode(context.parent, nodeSelection, childVar, true));
    }

    protected void addSpecialPredicateSelection(Context context, List<SparqlNode> sparqlNodes, String propName, Selectable nodeSelection) {
        Optional<SparqlNode> specialPred = SpecialPredicates.handle(propName, nodeSelection, context.parent, this.constraintGenerator, this.changeVarToFilterVar(), UnaryOperator.identity());
        sparqlNodes.add(specialPred.orElse(Empty.INSTANCE));
    }

    private boolean shouldPutNodeInFederatedBlock(Node target, Context context) {
        if (target.getName().equals("id")) {
            return false;
        }
        String service = this.getServiceInWhichANodeShouldBe(target);
        return service != null && !service.equals(context.service);
    }

    private String getServiceInWhichANodeShouldBe(Node target) {
        PropertyShape targetProp = target.getPropertyShape();
        String explicitService = targetProp.getInverseAlias() != null && targetProp.getRangeShape() != null ? targetProp.getRangeShape().getServiceAddress() : target.getShape().getServiceAddress();
        return explicitService;
    }

    private SparqlNode createNoneUniqueFilter(UniqueLang target, Context context) {
        List<SparqlNode> uniqueCheck = this.createUniqueLangCheck(context);
        Var secondVar = this.varProvider.getExistingVar(new Var(context.parentContext.parent, context.selection.getName())).orElseThrow(RuntimeException::new);
        Context subContext = context.createNegateContext();
        this.appendAdditionalLangFilters(target, subContext, uniqueCheck::add);
        this.appendAdditionalValueFilters(target, context, secondVar, uniqueCheck::add);
        uniqueCheck = this.mergeNoneExistsFilters(uniqueCheck);
        return this.combineInAnd(uniqueCheck, false);
    }

    private SparqlNode createUniqueFilter(UniqueLang target, Context context) {
        List<SparqlNode> uniqueCheck = this.createUniqueLangCheck(context);
        Var secondVar = this.varProvider.getExistingVar(new Var(context.parentContext.parent, context.selection.getName())).orElseThrow(RuntimeException::new);
        List<SparqlNode> existenceCheck = new LinkedList<SparqlNode>();
        existenceCheck.add(this.createLangPropertyExistCheck(context));
        Consumer<SparqlNode> uniqueFilter = uniqueCheck::add;
        this.appendAdditionalLangFilters(target, context, uniqueFilter.andThen(existenceCheck::add));
        this.appendAdditionalValueFilters(target, context, secondVar, uniqueFilter);
        uniqueCheck = this.mergeNoneExistsFilters(uniqueCheck);
        existenceCheck = this.mergeNoneExistsFilters(existenceCheck);
        return this.filter(this.and(this.not(this.exists(new SparqlNodeSequence(uniqueCheck))), this.exists(new SparqlNodeSequence(existenceCheck))));
    }

    private List<SparqlNode> mergeNoneExistsFilters(List<SparqlNode> uniqueCheck) {
        List<SparqlNode> expandedSequences = uniqueCheck.stream().flatMap(SparqlNodeSequence::flatten).collect(Collectors.toList());
        List mergeableFilters = expandedSequences.stream().filter(Filter.class::isInstance).map(Filter.class::cast).collect(Collectors.toList());
        if (mergeableFilters.size() <= 1) {
            return uniqueCheck;
        }
        expandedSequences.removeAll(mergeableFilters);
        List<SparqlNode> filterConditions = mergeableFilters.stream().map(Filter::getNode).collect(Collectors.toList());
        expandedSequences.add(this.filter(this.and(filterConditions)));
        return expandedSequences;
    }

    private void appendAdditionalValueFilters(UniqueLang target, Context context, Var secondVar, Consumer<SparqlNode> uniqueFilter) {
        UniqueLang copy = target.deepCopy();
        this.langFilterRemover.optimize((ExpressionValue)copy, null);
        if (copy.getTerms().isEmpty()) {
            return;
        }
        Context subContext = context.parentContext.createSubContext(secondVar, context.selection, context.service, false);
        this.appendAdditionalLangFilters(copy, subContext, uniqueFilter);
    }

    private void appendAdditionalLangFilters(UniqueLang target, Context context, Consumer<SparqlNode> nodeConsumer) {
        List terms = (List)target.getValue();
        if (terms.size() == 1) {
            SparqlNode childNode = (SparqlNode)((ExpressionTerm)terms.get(0)).accept((ExpressionVisitor)this, (ExpressionVisitorContext)context);
            nodeConsumer.accept(childNode);
        } else if (!terms.isEmpty()) {
            for (ExpressionTerm term : terms) {
                SparqlNode childNode = (SparqlNode)term.accept((ExpressionVisitor)this, (ExpressionVisitorContext)context);
                nodeConsumer.accept(childNode);
            }
        }
    }

    private SparqlNode createLangPropertyExistCheck(Context context) {
        Var parentVar = context.parentContext.parent;
        String propName = context.selection.getName();
        Selectable nodeSelection = this.findSelectionFor(context.parentContext, propName, context.selection.getDefinedInType().getId());
        Var childVar = this.varProvider.getExistingVar(parentVar).orElse(context.parent);
        Value predicate = this.getPredicate(nodeSelection);
        return PatternNode.createPattern(parentVar, predicate, childVar);
    }

    private List<SparqlNode> createUniqueLangCheck(Context context) {
        String propName = context.selection.getName();
        Var parentVar = context.parentContext.parent;
        Var childVar1 = this.varProvider.getExistingVar(parentVar).orElse(context.parent);
        FilterVar childVar2 = this.varProvider.getNewVar(new Var(parentVar, propName));
        Selectable nodeSelection = this.findSelectionFor(context.parentContext, propName, context.selection.getDefinedInType().getId());
        ArrayList<SparqlNode> uniqueCheck = new ArrayList<SparqlNode>();
        Value predicate = this.getPredicate(nodeSelection);
        uniqueCheck.add(PatternNode.createPattern(parentVar, predicate, childVar1));
        uniqueCheck.add(PatternNode.createPattern(parentVar, predicate, childVar2));
        uniqueCheck.add(this.filter(this.and(this.notEquals(childVar1, childVar2), this.equals(SparqlTermFunctions.lang(childVar1), SparqlTermFunctions.lang(childVar2)))));
        return uniqueCheck;
    }

    private Var createChildVar(Node target, Context context) {
        Var childVar;
        Selectable nodeSelection;
        String propName = target.getName();
        Optional<SparqlNode> specialPred = SpecialPredicates.handle(propName, nodeSelection = this.findSelectionFor(context, target), context.parent, this.constraintGenerator, this.changeVarToFilterVar(), UnaryOperator.identity());
        if (specialPred.isPresent()) {
            Var object = SpecialPredicates.getVar(propName, nodeSelection, context.parent).orElseThrow(IllegalStateException::new);
            childVar = "id".equals(propName) ? context.parent : this.varProvider.getExistingVar(object).orElse(context.parent);
        } else {
            childVar = this.varProvider.getNewVar(new Var(context.parent, propName));
        }
        return childVar;
    }

    private SparqlNode and(SparqlNode ... nodes) {
        return this.and(Arrays.asList(nodes));
    }

    private SparqlNode and(List<SparqlNode> nodes) {
        return new And(nodes);
    }

    private SparqlNode notEquals(SparqlNode first, SparqlNode second) {
        return new NotEquals(first, second);
    }

    private SparqlNode equals(SparqlNode first, SparqlNode second) {
        return new Equals(first, second);
    }

    private void checkIfValidTargetField(Context context) {
        Selectable selection = context.selection;
        String propName = selection.getName();
        if (!"Literal".equals(selection.getType())) {
            PropertyShape property = (PropertyShape)selection.getProperty().orElseThrow(FilterBuilder.throwPropertySelectionNotDefined(propName));
            if (property.isLiteral() && property.getScalarType().isLangStringSupported()) {
                return;
            }
            throw new IllegalArgumentException("Not allowed to use UNIQ filter for non 'langString' or 'stringOrLangString' Literal field");
        }
        if (SpecialPredicates.get(propName).isPresent()) {
            throw FilterBuilder.createNotSupportedUniqueCheck(propName).get();
        }
    }

    private static boolean isLiteralLangExistCheck(com.ontotext.models.query.Exists target, Context context) {
        return context.selection.getType().equals("Literal") && FilterBuilder.isExistLangCheck(target);
    }

    private static boolean isExistLangCheck(com.ontotext.models.query.Exists target) {
        return target.getTerms().stream().filter(Node.class::isInstance).map(Node.class::cast).filter((? super T node) -> node.getName().equals("lang")).findFirst().filter(FilterBuilder::isLangExistCheck).isPresent();
    }

    private static boolean isLangExistCheck(Node node) {
        if (node.isExistsCheck()) {
            return true;
        }
        Expression expression = (Expression)node.getValue();
        if (expression.getTerms().size() == 1) {
            ExpressionTerm term = (ExpressionTerm)expression.getTerms().get(0);
            return term instanceof StringStartWith && ANY_LANG.matcher(term.getValue().toString()).matches();
        }
        return false;
    }

    private SparqlNode processAnd(Expression target, Context context) {
        List terms = target.getTerms();
        if (terms.isEmpty()) {
            return Empty.INSTANCE;
        }
        if (terms.size() == 1) {
            return (SparqlNode)((ExpressionTerm)terms.get(0)).accept((ExpressionVisitor)this, (ExpressionVisitorContext)context);
        }
        Context childContext = context;
        if (context.not) {
            childContext = childContext.createNegateContext();
        }
        List<SparqlNode> subNodes = this.processForTerms(childContext, terms);
        return this.combineInAnd(subNodes, context.not);
    }

    private SparqlNode processOr(Expression target, Context context) {
        List terms = target.getTerms();
        if (terms.size() < 2) {
            return Empty.INSTANCE;
        }
        Context childContext = context;
        if (context.not) {
            childContext = childContext.createNegateContext();
        }
        List<SparqlNode> subNodes = this.processForTerms(childContext, terms);
        return this.combineInOr(subNodes, context.not);
    }

    private SparqlNode combineInAnd(List<SparqlNode> sequence, boolean negate) {
        return this.combine(sequence, this.combineInFilter(this::and, negate), this.combineInAndFilter(negate));
    }

    private SparqlNode combineInOr(List<SparqlNode> sequence, boolean negate) {
        return this.combine(sequence, this.combineInFilter(Or::new, negate), this.combineInFilter(this.addInExistsCombinedInOr(), negate));
    }

    private SparqlNode combine(List<SparqlNode> subNodes, Function<List<SparqlNode>, SparqlNode> filterTransformer, Function<List<SparqlNode>, SparqlNode> defaultTransformer) {
        if (subNodes.isEmpty()) {
            return Empty.INSTANCE;
        }
        if (subNodes.size() == 1) {
            return subNodes.get(0);
        }
        if (subNodes.stream().allMatch(Filter.class::isInstance)) {
            List innerNodes = subNodes.stream().map(Filter.class::cast).map(Filter::getNode).collect(Collectors.toList());
            return filterTransformer.apply(innerNodes);
        }
        subNodes = this.reduceNodesBasedOnFederatedServices(subNodes, filterTransformer, defaultTransformer);
        return defaultTransformer.apply(subNodes);
    }

    private List<SparqlNode> reduceNodesBasedOnFederatedServices(List<SparqlNode> subNodes, Function<List<SparqlNode>, SparqlNode> filterTransformer, Function<List<SparqlNode>, SparqlNode> defaultTransformer) {
        List federatedNodes = subNodes.stream().filter(FederatedBlock.class::isInstance).map(FederatedBlock.class::cast).collect(Collectors.toList());
        if (federatedNodes.isEmpty() || federatedNodes.size() != subNodes.size()) {
            return subNodes;
        }
        LinkedList<SparqlNode> reducesNodes = new LinkedList<SparqlNode>();
        for (SparqlNode subNode : subNodes) {
            if (subNode instanceof FederatedBlock) continue;
            reducesNodes.add(subNode);
        }
        Map<Iri, List> serviceNodesMap = federatedNodes.stream().collect(Collectors.toMap(FederatedBlock::getService, TriplePatternBlock::getPatterns, (list1, list2) -> {
            list1.addAll(list2);
            return list1;
        }));
        for (Map.Entry<Iri, List> serviceNodesEntry : serviceNodesMap.entrySet()) {
            reducesNodes.add(FederatedBlock.of(serviceNodesEntry.getKey(), this.combine(serviceNodesEntry.getValue(), filterTransformer, defaultTransformer)));
        }
        return reducesNodes;
    }

    private Function<List<SparqlNode>, SparqlNode> combineInFilter(Function<List<SparqlNode>, SparqlNode> combineFunction, boolean negate) {
        return nodes -> {
            SparqlNode combined = (SparqlNode)combineFunction.apply((List<SparqlNode>)nodes);
            if (negate) {
                combined = this.not(combined);
            }
            return this.filter(combined);
        };
    }

    private Function<List<SparqlNode>, SparqlNode> addInExistsCombinedInOr() {
        return sparqlNodes -> new Or(sparqlNodes.stream().filter(Empty.notEmpty()).map(Exists::new).collect(Collectors.toList()));
    }

    private Function<List<SparqlNode>, SparqlNode> combineInAndFilter(boolean negate) {
        return sparqlNodes -> {
            if (!negate) {
                return new SparqlNodeSequence((Collection<SparqlNode>)sparqlNodes);
            }
            List<SparqlNode> exists = sparqlNodes.stream().filter(Empty.notEmpty()).filter((? super T node) -> !(node instanceof SelectDistinct)).map(this::exists).collect(Collectors.toList());
            List<SparqlNode> selectDistincts = sparqlNodes.stream().filter(Empty.notEmpty()).filter((? super T node) -> node instanceof SelectDistinct).collect(Collectors.toList());
            if (!selectDistincts.isEmpty() && !exists.isEmpty()) {
                exists = exists.stream().map(exist -> {
                    SparqlNodeSequence seq = new SparqlNodeSequence(selectDistincts);
                    seq.add(exist.getNode());
                    return seq;
                }).map(this::exists).collect(Collectors.toList());
            } else if (!selectDistincts.isEmpty()) {
                exists = Collections.singletonList(this.exists(new SparqlNodeSequence(selectDistincts)));
            }
            return this.filter(this.not(this.and(exists)));
        };
    }

    private List<SparqlNode> processForTerms(Context context, List<ExpressionTerm> terms) {
        return terms.stream().map(expressionTerm -> expressionTerm.accept((ExpressionVisitor)this, (ExpressionVisitorContext)context)).map(SparqlNode.class::cast).filter(Empty.notEmpty()).collect(Collectors.toList());
    }

    private SparqlNode processInValues(List<Object> input, Context context) {
        List<Value> values = input.stream().map(this::getValue).collect(Collectors.toList());
        if (this.isLiteralLanguage(context)) {
            List<SparqlNode> valueChecks = values.stream().map(value -> SparqlTermFunctions.langMatches(context.parent, value)).collect(Collectors.toList());
            return new Or(valueChecks);
        }
        SparqlNode var = FilterBuilder.getVarOrString(context, values);
        return new In(var, values, this.options.getInThreshold());
    }

    private boolean isLiteralLanguage(Context context) {
        return context.selection.getName().equals("lang") && context.selection.getParent() != null && context.selection.getParent().getProperty().filter(PropertyShape::isLiteral).isPresent();
    }

    private Regex processRegex(Context context, Object value, boolean caseSensitive) {
        return new Regex(context.parent, context.selection.getType(), value.toString(), caseSensitive);
    }

    private SparqlNode wrapNodeInFilterExists(SparqlNode node, Context parentContext) {
        if (node instanceof Filter) {
            return node;
        }
        node = this.exists(node);
        if (parentContext.addNodeInNot()) {
            node = this.not(node);
        }
        node = this.filter(node);
        return node;
    }

    private Value getValue(Object value) {
        return Value.valueFromObject(value, this.schema);
    }

    private SparqlNode contextAwareFilter(SparqlNode node, Context context) {
        return this.contextAwareFilter(node, context, false);
    }

    private SparqlNode contextAwareFilter(SparqlNode node, Context context, boolean flipNegation) {
        if (context.skipOperators) {
            return Empty.INSTANCE;
        }
        if (context.not ^ flipNegation) {
            node = this.not(node);
        }
        return this.filter(node);
    }

    private Value getPredicate(Selectable selection) {
        String predicate = selection.getName();
        Optional<String> inverseAlias = this.getInverseAlias(selection);
        if (inverseAlias.isPresent()) {
            return new Inverse(predicate, inverseAlias.get());
        }
        Object args = selection.getArguments().get((Object)"args");
        return selection.getProperty().map(PropertyShape::getSparqlTemplate).map(template -> new Iri(SparqlBuilderUtil.applyTemplateArguments(template, args))).orElseGet(() -> new Iri(this.getRdfProperty(predicate, selection)));
    }

    private String getRdfProperty(String predicate, Selectable selection) {
        return selection.getProperty().map(PropertyShape::getRdfProperty).orElseThrow(() -> new SparqlCompileException("Could not resolve rdf property for " + predicate));
    }

    private Optional<String> getInverseAlias(Selectable selection) {
        PropertyShape shape = (PropertyShape)selection.getProperty().orElseThrow(() -> new IllegalStateException("Inverse alias defined in non-existent property."));
        return shape.getInverseAliasProperty();
    }

    private UnaryOperator<Var> changeVarToFilterVar() {
        return this.varProvider::getNewVar;
    }

    private SparqlNode filter(SparqlNode node) {
        return new Filter(node);
    }

    private SparqlNode not(SparqlNode node) {
        return new Not(node);
    }

    private Exists exists(SparqlNode node) {
        return new Exists(node);
    }

    private static Supplier<IllegalArgumentException> throwPropertySelectionNotDefined(String propName) {
        return () -> new IllegalArgumentException("Could not find " + propName + " in the 'where' selection");
    }

    private static Supplier<IllegalArgumentException> createNotSupportedUniqueCheck(String propName) {
        return () -> new IllegalArgumentException(propName + " is not supported for a UNIQUE check");
    }

    private Selectable findSelectionFor(Context context, Node node) {
        String propertyName = this.schema.getPrefixes().toName(node.getPropertyShape().getName());
        String shapeName = node.getShape().getId();
        return (Selectable)context.selection.getWhereSelections().stream().filter(Selectable.byNameAndParentType((String)propertyName, (String)shapeName)).findFirst().orElseThrow(FilterBuilder.throwPropertySelectionNotDefined(node.getName()));
    }

    private Selectable findSelectionFor(Context context, String propName, String parentType) {
        String propertyName = this.schema.getPrefixes().toName(propName);
        return (Selectable)context.selection.getWhereSelections().stream().filter(Selectable.byNameAndParentType((String)propertyName, (String)parentType)).findFirst().orElseThrow(FilterBuilder.throwPropertySelectionNotDefined(propName));
    }

    private static boolean hasUniqueLangFilter(ExpressionValue<?> value) {
        UniqueLangCollector collector = new UniqueLangCollector();
        FilterExpressionTraverser.traversePreOrder(value, (ExpressionVisitor)collector);
        return collector.getFoundNode() != null;
    }

    private static SparqlNode getVarOrString(Context context, List<Value> values) {
        boolean hasLang = values.stream().filter(Literal.class::isInstance).map(Literal.class::cast).allMatch(literal -> literal.getLang() != null);
        SparqlNode var = context.parent;
        if (FilterBuilder.isLiteralCompatibleSelection(context) && !hasLang) {
            var = SparqlTermFunctions.str(var);
        }
        if (context.isVarUCase) {
            return new UpperCase(var);
        }
        return var;
    }

    private static boolean isLiteralCompatibleSelection(Context context) {
        String name = context.selection.getName();
        if (!"name".equals(name)) {
            return "Literal".equals(context.selection.getType());
        }
        Shape type = context.selection.getDefinedInType();
        return type.getName() != null && type.getProperty(type.getName()).filter(PropertyShape::isLiteral).isPresent();
    }

    public static class Context
    implements ExpressionVisitorContext {
        final Context parentContext;
        final Var parent;
        final Selectable selection;
        final boolean inAll;
        final boolean not;
        final boolean skipOperators;
        final boolean isVarUCase;
        final String service;
        private boolean needsBlankNode;

        public Context(Var parent, Selectable selection) {
            this(null, parent, selection, false, false, false, false, selection.getParent() == null ? selection.getService() : selection.getParent().getService());
        }

        private Context(Context parentContext, Var parent, Selectable selection, boolean inAll, boolean not, boolean skipOperators, boolean isVarUCase, String service) {
            this.parentContext = parentContext;
            this.parent = parent;
            this.selection = selection;
            this.inAll = inAll;
            this.not = not;
            this.skipOperators = skipOperators;
            this.isVarUCase = isVarUCase;
            this.service = service;
        }

        private Context(Context parentContext, Var parent, Selectable selection, boolean inAll, boolean not, boolean skipOperators, String service) {
            this(parentContext, parent, selection, inAll, not, skipOperators, false, service);
        }

        Context createSubContext(Var childVar, Selectable childSelection, String federatedService, boolean isVarUCase) {
            return new Context(this, childVar, childSelection, false, this.addNodeInNot() ? !this.not : this.not, this.skipOperators, isVarUCase, federatedService);
        }

        Context createNegateContext() {
            return new Context(this.parentContext, this.parent, this.selection, this.inAll, !this.not, this.skipOperators, this.service);
        }

        boolean addNodeInNot() {
            return this.not;
        }

        private void checkBlankNodeNeeded(boolean force) {
            Context targetContext = this;
            while (null != targetContext) {
                if (EntityUpdateSparqlGenerator.ENTITY_IRI_VAR.equals(targetContext.parent) || targetContext.parentContext == null && targetContext.parent.getName().startsWith(EntityUpdateSparqlGenerator.ENTITY_IRI_VAR.getName()) || force) {
                    targetContext.needsBlankNode = true;
                }
                targetContext = targetContext.parentContext;
            }
        }

        boolean needsBlankNode() {
            return this.needsBlankNode;
        }
    }

    private static class UniqueLangCollector
    extends AbstractExpressionVisitor<TraversalControl, ExpressionTraverserContext> {
        private UniqueLang foundNode;

        private UniqueLangCollector() {
        }

        public TraversalControl visit(UniqueLang target, ExpressionTraverserContext context) {
            this.foundNode = target;
            return TraversalControl.QUIT;
        }

        UniqueLang getFoundNode() {
            return this.foundNode;
        }
    }
}

