/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler;

import com.ontotext.graphql.compiler.BaseMutationSparqlGenerator;
import com.ontotext.graphql.compiler.ConstraintGenerator;
import com.ontotext.graphql.compiler.FilterBuildResult;
import com.ontotext.graphql.compiler.FilterFactory;
import com.ontotext.graphql.compiler.FilterVarProvider;
import com.ontotext.graphql.compiler.SparqlCompilationResult;
import com.ontotext.graphql.compiler.SparqlTermFunctions;
import com.ontotext.graphql.compiler.querymodel.Bind;
import com.ontotext.graphql.compiler.querymodel.DeleteInsertQuery;
import com.ontotext.graphql.compiler.querymodel.Exists;
import com.ontotext.graphql.compiler.querymodel.Filter;
import com.ontotext.graphql.compiler.querymodel.FilterVar;
import com.ontotext.graphql.compiler.querymodel.Inverse;
import com.ontotext.graphql.compiler.querymodel.Iri;
import com.ontotext.graphql.compiler.querymodel.Literal;
import com.ontotext.graphql.compiler.querymodel.NamedGraphTriplePatternBlock;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.SparqlNodeSequence;
import com.ontotext.graphql.compiler.querymodel.SparqlUpdateQuery;
import com.ontotext.graphql.compiler.querymodel.TempVar;
import com.ontotext.graphql.compiler.querymodel.TriplePattern;
import com.ontotext.graphql.compiler.querymodel.TriplePatternBlock;
import com.ontotext.graphql.compiler.querymodel.TriplePatternChain;
import com.ontotext.graphql.compiler.querymodel.UnionCollection;
import com.ontotext.graphql.compiler.querymodel.UnionNode;
import com.ontotext.graphql.compiler.querymodel.Value;
import com.ontotext.graphql.compiler.querymodel.Values;
import com.ontotext.graphql.compiler.querymodel.Var;
import com.ontotext.models.Constraint;
import com.ontotext.models.InvalidSchemaException;
import com.ontotext.models.OperationType;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.mutation.Change;
import com.ontotext.models.mutation.ChangePreconditions;
import com.ontotext.models.mutation.Mutation;
import com.ontotext.models.mutation.PropertyChange;
import com.ontotext.models.mutation.ReferenceId;
import com.ontotext.models.mutation.UpdateMutation;
import com.ontotext.models.query.Arguments;
import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.FilteredSelection;
import com.ontotext.models.query.SelectDistinct;
import com.ontotext.soaas.common.StringManipulation;
import com.ontotext.soaas.common.sparql.CompilationResult;
import com.ontotext.soaas.common.sparql.OperationBuilderOptions;
import com.ontotext.soaas.common.sparql.PreviousExecution;
import com.ontotext.soaas.common.sparql.SparqlExecutionStep;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

class EntityUpdateSparqlGenerator
extends BaseMutationSparqlGenerator {
    private static final String GRAPH_PREFIX = "http://www.ontotext.com/changes/";
    private static final String GRAPH_SUFFIX = "_graph";
    private static final String INSERT_SUFFIX = "_insert";
    private static final String DELETE_SUFFIX = "_delete";
    private static final Iri CHANGE_PREDICATE = new Iri("http://www.ontotext.com/change");
    private static final String ID = "id";
    private static final String ENTITY_IRI = "entity_iri";
    private static final String PARENT = "parent";
    public static final Var ENTITY_IRI_VAR = new Var("entity_iri");
    public static final Var ENTITY_IRI_PARENT_VAR = new Var(ENTITY_IRI_VAR, "parent");
    private static final String ENTITY_IRI_GRAPH = "entity_iri_graph";
    private static final Var ENTITY_IRI_GRAPH_VAR = new Var("entity_iri_graph");

    EntityUpdateSparqlGenerator(SomlSchema schema, OperationBuilderOptions options, FilterFactory filterFactory) {
        super(schema, options, filterFactory);
    }

    static NamedGraphTriplePatternBlock createFetchPreviousResultsBlock(Var parentVar, String transactionId) {
        return EntityUpdateSparqlGenerator.createFetchPreviousResultsBlock(null, parentVar, transactionId);
    }

    static NamedGraphTriplePatternBlock createFetchPreviousResultsBlock(UpdateMutation mutation, Var parentVar, String transactionId) {
        Arguments arguments;
        String changesPrefix = GRAPH_PREFIX + transactionId;
        Value graphName = null;
        if (mutation != null && ((arguments = mutation.getArguments()).getUsing().isPresent() || arguments.getWith().isPresent())) {
            graphName = new TempVar(parentVar, "g");
            arguments.put((Object)"fromNamed", (Object)(changesPrefix + "/ng"));
        }
        if (graphName == null) {
            graphName = new Iri(changesPrefix + "/ng");
        }
        NamedGraphTriplePatternBlock fetchPreviousData = new NamedGraphTriplePatternBlock(graphName);
        fetchPreviousData.addNode(new TriplePattern((Value)new Iri(changesPrefix), (Value)CHANGE_PREDICATE, parentVar));
        return fetchPreviousData;
    }

    CompilationResult generate(UpdateMutation mutation) {
        List changes = mutation.getChanges();
        SparqlCompilationResult compilationResult = new SparqlCompilationResult();
        for (Change change : this.getRootChanges(changes)) {
            UpdateNode updateNode = new UpdateNode(change, (Mutation)mutation);
            updateNode.generate(compilationResult);
        }
        return compilationResult;
    }

    List<Change> getRootChanges(List<Change> changes) {
        return changes.stream().filter(Change::isRootChange).toList();
    }

    protected class UpdateNode {
        static final String IGNORE = "ignore";
        final Change change;
        private final Mutation mutation;
        private final UpdateNode parentNode;
        private final List<UpdateNode> subNodes = new LinkedList<UpdateNode>();

        UpdateNode(Change change, Mutation mutation) {
            this(null, change, mutation);
        }

        private UpdateNode(UpdateNode parentNode, Change change, Mutation mutation) {
            this.parentNode = parentNode;
            this.change = change;
            this.mutation = mutation;
            for (Change nestedChange : change.getNestedChanges()) {
                this.subNodes.add(new UpdateNode(this, nestedChange, mutation));
            }
        }

        UpdateNode(UpdateNode copy) {
            this(copy.parentNode, copy.change, copy.mutation);
        }

        void generate(SparqlCompilationResult compilationResult) {
            this.processNestedCreates(compilationResult);
            this.createUpdateQuery().ifPresent(compilationResult::add);
            if (this.change.getNestedChanges().isEmpty()) {
                return;
            }
            List<UpdateNode> subUpdates = this.getSubUpdates();
            for (UpdateNode nestedChange : subUpdates) {
                nestedChange.generate(compilationResult);
            }
        }

        void processNestedCreates(SparqlCompilationResult compilationResult) {
            List<UpdateNode> subCreates = this.getSubCreates();
            for (UpdateNode nestedCreate : subCreates) {
                nestedCreate.processNestedCreates(compilationResult);
            }
            if (this.isCreate()) {
                this.createUpdateQuery().ifPresent(compilationResult::add);
            }
        }

        private Optional<UpdateExecutionStep> createUpdateQuery() {
            String entityId = this.change.getEntityId().orElse(null);
            Value id = ENTITY_IRI_VAR;
            if (entityId != null) {
                id = new Iri(EntityUpdateSparqlGenerator.this.toRelativeIri(entityId));
            }
            SparqlUpdateQuery mutationQuery = new SparqlUpdateQuery();
            this.processEntityUpdate(id, mutationQuery);
            EntityUpdateSparqlGenerator.this.addBase(mutationQuery);
            EntityUpdateSparqlGenerator.this.configureMutation(mutationQuery, this.mutation);
            EntityUpdateSparqlGenerator.this.addPrefixes(mutationQuery);
            if (mutationQuery.getQueries().isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new UpdateExecutionStep(this.change.getTransactionId(), mutationQuery));
        }

        void processEntityUpdate(Value idConst, SparqlUpdateQuery mutationQuery) {
            this.createEntityIdChangeQueries(idConst).forEach(mutationQuery::add);
            DeleteInsertQuery deleteInsertQuery = new DeleteInsertQuery();
            TriplePatternBlock where = deleteInsertQuery.getWhere();
            this.addCollectChangesGraph(deleteInsertQuery);
            if (this.change.hasPreconditions()) {
                SparqlNodeSequence sequence = new SparqlNodeSequence();
                this.generatePreconditions(sequence, ENTITY_IRI_VAR);
                where.addNode(sequence);
            }
            this.generateConstraints(where, this.change);
            if (EntityUpdateSparqlGenerator.this.mutationMode == OperationBuilderOptions.MutationMode.APPEND_ONLY || EntityUpdateSparqlGenerator.this.mutationMode == OperationBuilderOptions.MutationMode.CHANGES && this.change.getGraph() == null) {
                where.addNodeFirst(new Bind(SparqlTermFunctions.iri(SparqlTermFunctions.concat(SparqlTermFunctions.str(ENTITY_IRI_VAR), Literal.asString("/ng"))), ENTITY_IRI_GRAPH_VAR));
            }
            this.addEntityIdBinding(idConst, where);
            this.addFetchPreviousResults(deleteInsertQuery);
            PropertyChangeProcessor processor = new PropertyChangeProcessor(ENTITY_IRI_VAR, this.change, deleteInsertQuery, where);
            this.getChanges().stream().filter(this.isIdChange().negate()).forEach(processor::processChange);
            processor.done();
            mutationQuery.add(deleteInsertQuery);
        }

        void addEntityIdBinding(Value idConst, TriplePatternBlock where) {
            Value newId = this.change.getNewEntityId().map(EntityUpdateSparqlGenerator.this::toRelativeIri).map(Iri::new).orElse(idConst);
            if (newId instanceof Iri) {
                where.addNodeFirst(new Values(ENTITY_IRI_VAR, Collections.singletonList(newId)));
            }
        }

        void generatePreconditions(SparqlNodeSequence block, Var entityVar) {
            ChangePreconditions preconditions = this.change.getPreconditions();
            PropertyShape incomingRelation = preconditions.getIncomingRelation();
            if (incomingRelation == null) {
                this.generateRootPreconditions(block, this.change, entityVar);
                return;
            }
            Change parentChange = this.parentNode.change;
            assert (Objects.nonNull(parentChange)) : "The parent change should be present";
            Var parentVar = new Var(entityVar, EntityUpdateSparqlGenerator.PARENT);
            if (this.isCreate()) {
                this.parentNode.generatePreconditions(block, parentVar);
            }
            if (this.isCreate()) {
                return;
            }
            String parentId = this.resolveId(parentChange);
            if (parentId != null) {
                block.addFirst(new Values(parentVar, Collections.singletonList(new Iri(EntityUpdateSparqlGenerator.this.toRelativeIri(parentId)))));
            }
            block.add(new TriplePattern((Value)parentVar, (Value)new Iri(incomingRelation.getRdfProperty()), entityVar));
            if (preconditions.getPrecondition() != null) {
                FilterBuildResult filter = EntityUpdateSparqlGenerator.this.filterFactory.getMutationFilter(entityVar, this.change.getShape(), preconditions.getPreconditionSelection(), "Precondition", EntityUpdateSparqlGenerator.this.options);
                block.add(filter.getSparql());
            }
        }

        private void generateRootPreconditions(SparqlNodeSequence block, Change change, Var currentEntity) {
            if (!change.hasPreconditions()) {
                return;
            }
            ChangePreconditions preconditions = change.getPreconditions();
            if (preconditions.getPrecondition() != null) {
                FilterBuildResult filter = EntityUpdateSparqlGenerator.this.filterFactory.getMutationFilter(currentEntity, change.getShape(), preconditions.getPreconditionSelection(), "Root", EntityUpdateSparqlGenerator.this.options);
                block.add(filter.getSparql());
            }
        }

        void generateConstraints(TriplePatternBlock block, Change change) {
            Set<Constraint> constraints;
            if (change.getType().equals((Object)OperationType.CREATE)) {
                return;
            }
            if (change.getConstraints() != null && !change.getConstraints().isEmpty()) {
                constraints = this.change.getConstraints();
            } else if (change.getPreconditions() != null && change.getPreconditions().getIncomingRelation() == null) {
                constraints = Collections.singleton(new Constraint(change.getShape().getId()));
            } else {
                return;
            }
            LinkedList<SparqlNode> sparqlNodes = new LinkedList<SparqlNode>();
            new ConstraintGenerator(EntityUpdateSparqlGenerator.this.schema, EntityUpdateSparqlGenerator.this.options).addBoTypeConstraint(constraints, sparqlNodes, ConstraintGenerator.SparqlBuildingContext.contextBuilder().subject(ENTITY_IRI_VAR).filterGenerator(FilterFactory.filterGenerator(ENTITY_IRI_VAR, FilterFactory.getFilterBuilder(EntityUpdateSparqlGenerator.this.schema, EntityUpdateSparqlGenerator.this.options, EntityUpdateSparqlGenerator.this.filterFactory))).build());
            if (!sparqlNodes.isEmpty()) {
                block.addNode(new SparqlNodeSequence(sparqlNodes));
            }
        }

        List<UpdateNode> getSubUpdates() {
            return this.subNodes.stream().filter(nestedChange -> !nestedChange.isCreate()).toList();
        }

        private List<UpdateNode> getSubCreates() {
            return this.subNodes.stream().filter(UpdateNode::isCreate).toList();
        }

        public Collection<PropertyChange> getChanges() {
            return this.change.getChanges();
        }

        public boolean isCreate() {
            return this.change.getType() == OperationType.CREATE;
        }

        private String resolveId(Change change) {
            if (change == null) {
                return null;
            }
            String id = change.getId();
            if (ReferenceId.isNotReferenceId((String)id)) {
                return id;
            }
            Optional newEntityId = change.getNewEntityId();
            if (newEntityId.isPresent()) {
                return (String)newEntityId.get();
            }
            if (change.hasPreconditions() && change.getPreconditions().getActualChangeId() != null && change.getPreconditions().getIdSelection().isEmpty()) {
                return change.getPreconditions().getActualChangeId();
            }
            return null;
        }

        private void addCollectChangesGraph(DeleteInsertQuery query) {
            if (this.change.getType() == OperationType.CREATE) {
                return;
            }
            NamedGraphTriplePatternBlock graphBlock = EntityUpdateSparqlGenerator.createFetchPreviousResultsBlock(ENTITY_IRI_VAR, this.change.getCollectChangesIn());
            query.getInsert().addNodeFirst(graphBlock);
        }

        void addFetchPreviousResults(DeleteInsertQuery query) {
            NamedGraphTriplePatternBlock fetchPreviousData = this.computeFetchPreviousResults(ENTITY_IRI_PARENT_VAR);
            if (fetchPreviousData == null) {
                return;
            }
            query.getWhere().addNode(fetchPreviousData);
        }

        private NamedGraphTriplePatternBlock computeFetchPreviousResults(Var parentVar) {
            if (this.change.isRootChange()) {
                return null;
            }
            if (this.isCreate()) {
                return this.parentNode.computeFetchPreviousResults(new Var(parentVar, EntityUpdateSparqlGenerator.PARENT));
            }
            Change parentChange = this.change.getPreconditions().getParentChange();
            return EntityUpdateSparqlGenerator.createFetchPreviousResultsBlock(parentVar, parentChange.getCollectChangesIn());
        }

        private Stream<DeleteInsertQuery> createEntityIdChangeQueries(Value currentId) {
            if (this.change.getType() != OperationType.UPDATE) {
                return Stream.empty();
            }
            Optional idChange = this.change.getNewEntityId();
            if (idChange.isPresent()) {
                this.checkIfChangeIdIsAllowed();
                Iri newId = new Iri(EntityUpdateSparqlGenerator.this.toRelativeIri((String)idChange.get()));
                Stream.Builder<DeleteInsertQuery> builder = Stream.builder();
                builder.add(this.createPreconditionsQuery(currentId)).add(this.changeForwardExplicitStatements(newId)).add(this.changeBackwardExplicitStatements(newId));
                if (EntityUpdateSparqlGenerator.this.mutationMode == OperationBuilderOptions.MutationMode.CHANGES && this.change.getGraph() == null) {
                    builder.add(this.changeForwardGraphsStatements(currentId, newId));
                }
                builder.add(this.changeRemainingGraphsStatements(newId)).add(this.changeBackwardGraphsStatements(newId));
                return builder.build();
            }
            return Stream.empty();
        }

        private DeleteInsertQuery createPreconditionsQuery(Value currentId) {
            DeleteInsertQuery preconditionsQuery = new DeleteInsertQuery();
            this.addCollectChangesGraph(preconditionsQuery);
            TriplePatternBlock where = preconditionsQuery.getWhere();
            if (this.change.hasPreconditions()) {
                SparqlNodeSequence sequence = new SparqlNodeSequence();
                this.generatePreconditions(sequence, ENTITY_IRI_VAR);
                where.addNode(sequence);
            }
            this.generateConstraints(where, this.change);
            where.addNodeFirst(new Values(ENTITY_IRI_VAR, Collections.singletonList(currentId)));
            return preconditionsQuery;
        }

        private DeleteInsertQuery changeForwardExplicitStatements(Iri newId) {
            return this.changeExplicitStatements(newId, ENTITY_IRI_VAR, new Var("o"));
        }

        private DeleteInsertQuery changeBackwardExplicitStatements(Iri newId) {
            return this.changeExplicitStatements(newId, new Var("s"), ENTITY_IRI_VAR);
        }

        private DeleteInsertQuery changeExplicitStatements(Iri newId, Var subject, Var object) {
            DeleteInsertQuery explicitQuery = new DeleteInsertQuery();
            Var predicate = new Var("p");
            explicitQuery.getDelete().addNode(new TriplePattern((Value)subject, (Value)predicate, object));
            if (subject.equals(ENTITY_IRI_VAR)) {
                explicitQuery.getInsert().addNode(new TriplePattern((Value)newId, (Value)predicate, object));
            } else {
                explicitQuery.getInsert().addNode(new TriplePattern((Value)subject, (Value)predicate, newId));
            }
            this.fetchAffectedEntitiesForIdChange(explicitQuery);
            explicitQuery.getWhere().addNode(new TriplePattern((Value)subject, (Value)predicate, object));
            NamedGraphTriplePatternBlock explicitGraph = new NamedGraphTriplePatternBlock(new Var("g"));
            explicitGraph.addNode(new TriplePattern((Value)subject, (Value)predicate, object));
            explicitQuery.getWhere().addNode(new Filter(Exists.notExists(explicitGraph)));
            return explicitQuery;
        }

        private void fetchAffectedEntitiesForIdChange(DeleteInsertQuery explicitQuery) {
            NamedGraphTriplePatternBlock fetchPreviousResultsBlock = EntityUpdateSparqlGenerator.createFetchPreviousResultsBlock(ENTITY_IRI_VAR, this.change.getCollectChangesIn());
            explicitQuery.getWhere().addNode(fetchPreviousResultsBlock);
        }

        private DeleteInsertQuery changeForwardGraphsStatements(Value currentId, Iri newId) {
            DeleteInsertQuery namedQuery = new DeleteInsertQuery();
            NamedGraphTriplePatternBlock namedGraph = new NamedGraphTriplePatternBlock(new Iri(newId.getName() + "/ng"));
            Var predicate = new Var("p");
            Var object = new Var("o");
            namedGraph.addNode(new TriplePattern((Value)newId, (Value)predicate, object));
            namedQuery.getInsert().addNode(namedGraph);
            this.fetchAffectedEntitiesForIdChange(namedQuery);
            namedQuery.getDelete().addNode(new TriplePattern((Value)ENTITY_IRI_VAR, (Value)predicate, object));
            NamedGraphTriplePatternBlock currentIdNamedGraph = new NamedGraphTriplePatternBlock(new Iri(currentId.getName() + "/ng"));
            currentIdNamedGraph.addNode(new TriplePattern((Value)ENTITY_IRI_VAR, (Value)predicate, object));
            namedQuery.getWhere().addNode(currentIdNamedGraph);
            return namedQuery;
        }

        private DeleteInsertQuery changeRemainingGraphsStatements(Iri newId) {
            Var predicate = new Var("p");
            Var object = new Var("o");
            return this.populateDeleteInsertQuery(new TriplePattern((Value)newId, (Value)predicate, object), new TriplePattern((Value)ENTITY_IRI_VAR, (Value)predicate, object));
        }

        private DeleteInsertQuery changeBackwardGraphsStatements(Iri newId) {
            Var subject = new Var("s");
            Var predicate = new Var("p");
            return this.populateDeleteInsertQuery(new TriplePattern((Value)subject, (Value)predicate, newId), new TriplePattern((Value)subject, (Value)predicate, ENTITY_IRI_VAR));
        }

        private DeleteInsertQuery populateDeleteInsertQuery(SparqlNode insertPatterns, SparqlNode deletePatterns) {
            Var subjectGraph = new Var("subject_graph");
            DeleteInsertQuery namedQuery = new DeleteInsertQuery();
            NamedGraphTriplePatternBlock insertGraph = new NamedGraphTriplePatternBlock(subjectGraph);
            insertGraph.addNode(insertPatterns);
            namedQuery.getInsert().addNode(insertGraph);
            this.fetchAffectedEntitiesForIdChange(namedQuery);
            NamedGraphTriplePatternBlock namedGraph = new NamedGraphTriplePatternBlock(subjectGraph);
            namedGraph.addNode(deletePatterns);
            namedQuery.getWhere().addNode(namedGraph);
            namedQuery.getDelete().addNode(namedGraph);
            return namedQuery;
        }

        private Predicate<PropertyChange> isIdChange() {
            return propertyChange -> propertyChange.getName().equals(EntityUpdateSparqlGenerator.ID);
        }

        private void checkIfChangeIdIsAllowed() {
            if (!EntityUpdateSparqlGenerator.this.mutationMode.allowIdChange()) {
                throw new IllegalArgumentException("Not allowed to change entity id in " + String.valueOf(EntityUpdateSparqlGenerator.this.mutationMode) + " mode");
            }
        }
    }

    private static class UpdateExecutionStep
    implements SparqlExecutionStep {
        private final String id;
        private final SparqlUpdateQuery updateQuery;

        UpdateExecutionStep(String id, SparqlUpdateQuery updateQuery) {
            this.id = id;
            this.updateQuery = updateQuery;
        }

        public Optional<String> getDependsOn() {
            return Optional.empty();
        }

        public String getId() {
            return this.id;
        }

        public String getQuery(PreviousExecution previousExecution) {
            return this.updateQuery.toSparql();
        }

        public Map<String, List<String>> getBindings() {
            return Collections.emptyMap();
        }

        public boolean isUpdate() {
            return true;
        }
    }

    private class PropertyChangeProcessor {
        private final Value id;
        private final Shape shape;
        private final Map<Value, TriplePatternChain> insertChainMap = new LinkedHashMap<Value, TriplePatternChain>();
        private final Map<Value, TriplePatternChain> deleteChainMap = new LinkedHashMap<Value, TriplePatternChain>();
        private final TriplePatternChain insertChain;
        private final TriplePatternChain deleteChain;
        private final DeleteInsertQuery query;
        private final FilterVarProvider varProvider = new FilterVarProvider();
        private final UnionCollection selectionUnion;
        private final Change change;
        private final TriplePatternBlock whereBlock;
        private int count;
        private final SparqlNodeSequence propertySelections;

        private PropertyChangeProcessor(Value id, Change change, DeleteInsertQuery query, TriplePatternBlock whereBlock) {
            this.id = id;
            this.shape = change.getShape();
            this.change = change;
            this.insertChain = new TriplePatternChain(id);
            this.deleteChain = new TriplePatternChain(id);
            this.insertChainMap.put(this.insertChain.getRoot(), this.insertChain);
            this.deleteChainMap.put(this.deleteChain.getRoot(), this.deleteChain);
            this.query = query;
            this.selectionUnion = new UnionCollection();
            this.whereBlock = whereBlock;
            this.propertySelections = new SparqlNodeSequence();
        }

        void processChange(PropertyChange change) {
            Value predicate;
            ++this.count;
            String propertyName = change.getName();
            Optional<PropertyShape> rootProp = this.getProperty(propertyName);
            if (rootProp.filter(this::hasInverseAlias).isPresent()) {
                PropertyShape property = rootProp.get();
                predicate = EntityUpdateSparqlGenerator.this.createInversePredicate(property.getInverseAlias(), (String)property.getInverseAliasProperty().orElseThrow(() -> new InvalidSchemaException("Invalid schema.")), (Shape)EntityUpdateSparqlGenerator.this.schema.getObjects().get((Object)property.getRange()));
            } else {
                predicate = EntityUpdateSparqlGenerator.this.createPredicate(propertyName, this.shape);
            }
            if (rootProp.filter(this::isInverseOf).isPresent()) {
                PropertyShape property = rootProp.get();
                String inverseOf = property.getInverseOf();
                Shape inverseShape = (Shape)this.shape.getContainedIn().get((Object)property.getRange());
                Optional inverseProp = inverseShape.getProperty(inverseOf);
                if (inverseProp.isPresent()) {
                    Value inverseOfPredicate = EntityUpdateSparqlGenerator.this.createInversePredicate(propertyName, ((PropertyShape)inverseProp.get()).getRdfProperty(), inverseShape);
                    this.processChangeForPredicate(change, inverseOf, inverseOfPredicate, predicate);
                }
            } else {
                this.processChangeForPredicate(change, propertyName, predicate);
            }
        }

        private Optional<PropertyShape> getProperty(String propertyName) {
            if ("name".equals(propertyName)) {
                if (this.shape.getName() != null) {
                    return this.shape.getProperty(this.shape.getName());
                }
                return Optional.empty();
            }
            return this.shape.getProperty(EntityUpdateSparqlGenerator.this.schema.getPrefixes().nameToShortIri(propertyName));
        }

        private void processChangeForPredicate(PropertyChange change, String propertyName, Value inversePredicate, Value predicate) {
            Object value = change.getValue();
            Object patch = change.getPatch();
            if (value != null) {
                this.updateExistingValue(change, propertyName, inversePredicate, predicate);
            } else if (change.hasWhere()) {
                this.updateValue(this.id, inversePredicate, predicate, Collections.emptyList(), this.buildExpressionFilter(change.getWhereSelection(), propertyName));
            } else if (patch == null || change.isReplace()) {
                Value selection = this.selectAnyValue(this.id, predicate);
                this.appendToChain(predicate, selection, this.deleteChainMap, this.deleteChain);
                if (null != inversePredicate) {
                    this.appendToChain(inversePredicate, selection, this.deleteChainMap, this.deleteChain);
                }
            } else {
                this.updateValue(this.id, inversePredicate, predicate, Collections.emptyList(), this.buildPatchFilter(patch));
            }
        }

        private void processChangeForPredicate(PropertyChange change, String propertyName, Value predicate) {
            this.processChangeForPredicate(change, propertyName, null, predicate);
        }

        private void updateExistingValue(PropertyChange change, String propertyName, Value inversePredicate, Value predicate) {
            Object value = change.getValue();
            Object patch = change.getPatch();
            LinkedList<Value> values = new LinkedList<Value>();
            EntityUpdateSparqlGenerator.this.convertValue(value, values::add);
            if (change.hasWhere()) {
                this.updateValue(this.id, inversePredicate, predicate, values, this.buildExpressionFilter(change.getWhereSelection(), propertyName));
                if (patch != null) {
                    this.updateValue(this.id, inversePredicate, predicate, values, this.buildPatchFilter(patch));
                }
            } else if (patch != null) {
                this.updateValue(this.id, inversePredicate, predicate, values, this.buildPatchFilter(patch));
            } else {
                EntityUpdateSparqlGenerator.this.convertValue(value, val -> this.appendToChain(predicate, (Value)val, this.insertChainMap, this.insertChain));
                if (null != inversePredicate) {
                    EntityUpdateSparqlGenerator.this.convertValue(value, val -> this.appendToChain(inversePredicate, (Value)val, this.insertChainMap, this.insertChain));
                }
                if (change.isReplace()) {
                    Value selection = this.selectAnyValue(this.id, predicate);
                    this.appendToChain(predicate, selection, this.deleteChainMap, this.deleteChain);
                    if (null != inversePredicate) {
                        this.appendToChain(inversePredicate, selection, this.deleteChainMap, this.deleteChain);
                    }
                }
            }
        }

        private void updateValue(Value subject, Value inversePredicate, Value predicate, List<Value> values, Function<FilterVar, SparqlNode> filterBuilder) {
            Var variable = new Var(StringManipulation.toGraphQlModelName((String)predicate.getName()));
            FilterVar deleteVar = this.varProvider.getNewVar(variable);
            SparqlNode filter = filterBuilder.apply(deleteVar);
            TriplePatternBlock patternBlock = new TriplePatternBlock();
            patternBlock.addNode(new TriplePattern(subject, predicate, deleteVar));
            patternBlock.addNode(filter);
            this.selectionUnion.addNode(new UnionNode(patternBlock));
            this.appendToChain(predicate, deleteVar, this.deleteChainMap, this.deleteChain);
            if (null != inversePredicate) {
                this.appendToChain(inversePredicate, deleteVar, this.deleteChainMap, this.deleteChain);
            }
            if (!values.isEmpty()) {
                FilterVar insertVar = this.varProvider.getNewVar(variable);
                patternBlock.addNode(new Values(insertVar, values));
                this.appendToChain(predicate, insertVar, this.insertChainMap, this.insertChain);
                if (null != inversePredicate) {
                    this.appendToChain(inversePredicate, insertVar, this.insertChainMap, this.insertChain);
                }
            }
        }

        private Function<FilterVar, SparqlNode> buildExpressionFilter(FilteredSelection filteredSelection, String propertyName) {
            return subjectVar -> {
                ExpressionValue filterValue = filteredSelection.getExpression();
                Shape targetType = this.shape;
                if (propertyName != null && filterValue instanceof SelectDistinct) {
                    SomlSchema schema = this.shape.getContainedIn().getContainedIn();
                    String property = schema.getPrefixes().nameToShortIri(propertyName);
                    targetType = this.shape.getProperty(property).map(PropertyShape::getRange).map(arg_0 -> schema.getObjects().get(arg_0)).orElseThrow(IllegalArgumentException::new);
                }
                return EntityUpdateSparqlGenerator.this.filterFactory.getMutationFilter((Var)subjectVar, targetType, filteredSelection, String.valueOf(this.count), EntityUpdateSparqlGenerator.this.options).getSparql();
            };
        }

        private Function<FilterVar, SparqlNode> buildPatchFilter(Object filterValue) {
            return subjectVar -> {
                BaseMutationSparqlGenerator.EqualsOrInNode filterNode = new BaseMutationSparqlGenerator.EqualsOrInNode((Var)subjectVar, EntityUpdateSparqlGenerator.this.options.getInThreshold());
                EntityUpdateSparqlGenerator.this.convertValue(filterValue, filterNode::add);
                return new Filter(filterNode);
            };
        }

        private Value selectAnyValue(Value idConstant, Value predicate) {
            Var variable = new Var(StringManipulation.toGraphQlModelName((String)predicate.getName()));
            TriplePattern pattern = new TriplePattern(idConstant, predicate, variable);
            this.propertySelections.add(pattern);
            this.selectionUnion.addNode(new UnionNode(pattern));
            return variable;
        }

        void done() {
            if (this.count == 0 && this.change.isRootChange() && this.change.getEntityId().isEmpty()) {
                this.query.getWhere().addNode(new TriplePattern(this.id, (Value)new Var("p"), new Var("o")));
            }
            if (!this.propertySelections.isEmpty()) {
                this.selectionUnion.addNode(new UnionNode(new Filter(Exists.notExists(this.propertySelections))));
            }
            if (!this.selectionUnion.isEmpty()) {
                this.query.getWhere().addNode(this.selectionUnion);
            }
            for (Map.Entry<Value, TriplePatternChain> chain : this.insertChainMap.entrySet()) {
                EntityUpdateSparqlGenerator.this.appendToInsertBlock(this.generateGraphIri(chain, false), this.change.getGraph(), this.query, chain.getValue());
            }
            for (Map.Entry<Value, TriplePatternChain> chain : this.deleteChainMap.entrySet()) {
                EntityUpdateSparqlGenerator.this.appendToDeleteBlock(this.generateGraphIri(chain, true), this.query, chain.getValue());
            }
        }

        private Value generateGraphIri(Map.Entry<Value, TriplePatternChain> chain, boolean isDelete) {
            Value graphId = chain.getKey();
            if (graphId instanceof Var) {
                Var varId = (Var)graphId;
                if (varId.getLocalName().equals(EntityUpdateSparqlGenerator.ENTITY_IRI)) {
                    graphId = ENTITY_IRI_GRAPH_VAR;
                } else {
                    String graphRoot = chain.getKey().toSparql().substring(1);
                    String suffix = this.setSuffixForOperation(isDelete);
                    graphId = new Var(graphRoot + EntityUpdateSparqlGenerator.GRAPH_SUFFIX + suffix);
                    if (EntityUpdateSparqlGenerator.this.mutationMode == OperationBuilderOptions.MutationMode.APPEND_ONLY || !isDelete && EntityUpdateSparqlGenerator.this.mutationMode == OperationBuilderOptions.MutationMode.CHANGES) {
                        this.whereBlock.addNodeFirst(new Bind(SparqlTermFunctions.iri(SparqlTermFunctions.concat(chain.getKey(), Literal.asString("/ng"))), graphId));
                    }
                }
            }
            return graphId;
        }

        private String setSuffixForOperation(boolean isDelete) {
            String suffix = isDelete ? EntityUpdateSparqlGenerator.DELETE_SUFFIX : EntityUpdateSparqlGenerator.INSERT_SUFFIX;
            return suffix;
        }

        private boolean hasInverseAlias(PropertyShape rootProp) {
            return !rootProp.isScalarType() && null != rootProp.getInverseAlias();
        }

        private boolean isInverseOf(PropertyShape rootProp) {
            return !rootProp.isScalarType() && null != rootProp.getInverseOf();
        }

        private void appendToChain(Value predicate, Value targetVar, Map<Value, TriplePatternChain> chainMap, TriplePatternChain targetChain) {
            if (predicate instanceof Inverse) {
                Inverse inverse = (Inverse)predicate;
                predicate = inverse.toIri();
                Value rootValue = targetChain.getRoot();
                Value graphKey = targetVar;
                if (targetVar instanceof Iri) {
                    graphKey = new Iri(EntityUpdateSparqlGenerator.this.toRelativeIri(targetVar.getName()));
                }
                targetChain = chainMap.computeIfAbsent(graphKey, value -> new TriplePatternChain(targetVar));
                targetChain.add(predicate, rootValue);
            } else {
                targetChain.add(predicate, targetVar);
            }
        }
    }
}

