/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler;

import com.ontotext.graphql.compiler.BaseMutationSparqlGenerator;
import com.ontotext.graphql.compiler.ConstraintGenerator;
import com.ontotext.graphql.compiler.FilterFactory;
import com.ontotext.graphql.compiler.SparqlBuilderUtil;
import com.ontotext.graphql.compiler.SparqlTermFunctions;
import com.ontotext.graphql.compiler.querymodel.Bind;
import com.ontotext.graphql.compiler.querymodel.DeleteInsertQuery;
import com.ontotext.graphql.compiler.querymodel.Exists;
import com.ontotext.graphql.compiler.querymodel.Filter;
import com.ontotext.graphql.compiler.querymodel.Inverse;
import com.ontotext.graphql.compiler.querymodel.Iri;
import com.ontotext.graphql.compiler.querymodel.Literal;
import com.ontotext.graphql.compiler.querymodel.NamedGraphTriplePatternBlock;
import com.ontotext.graphql.compiler.querymodel.Or;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.SparqlNodeSequence;
import com.ontotext.graphql.compiler.querymodel.SparqlUpdateQuery;
import com.ontotext.graphql.compiler.querymodel.TriplePattern;
import com.ontotext.graphql.compiler.querymodel.TriplePatternBlock;
import com.ontotext.graphql.compiler.querymodel.UnionCollection;
import com.ontotext.graphql.compiler.querymodel.Value;
import com.ontotext.graphql.compiler.querymodel.Values;
import com.ontotext.graphql.compiler.querymodel.Var;
import com.ontotext.models.Constraints;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.mutation.Change;
import com.ontotext.models.mutation.DeleteMutation;
import com.ontotext.models.mutation.Mutation;
import com.ontotext.soaas.common.SparqlUtil;
import com.ontotext.soaas.common.sparql.OperationBuilderOptions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class EntityDeleteSparqlGenerator
extends BaseMutationSparqlGenerator {
    EntityDeleteSparqlGenerator(SomlSchema schema, OperationBuilderOptions options, FilterFactory filterFactory) {
        super(schema, options, filterFactory);
    }

    List<SparqlNode> generate(DeleteMutation mutation) {
        SparqlUpdateQuery mutationQuery = new SparqlUpdateQuery();
        List<String> entitiesToDelete = mutation.getChanges().stream().map(Change::getId).map(this::toRelativeIri).collect(Collectors.toList());
        if (entitiesToDelete.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.mutationMode == OperationBuilderOptions.MutationMode.APPEND_ONLY) {
            this.deletedEntityNamedGraphs(entitiesToDelete, mutationQuery, mutation);
        } else if (this.mutationMode == OperationBuilderOptions.MutationMode.READ_WRITE || this.mutationMode == OperationBuilderOptions.MutationMode.CHANGES) {
            this.deleteAllEntityData(entitiesToDelete, mutationQuery, mutation);
        }
        if (mutationQuery.getQueries().isEmpty()) {
            return Collections.emptyList();
        }
        this.addBase(mutationQuery);
        this.configureMutation(mutationQuery, (Mutation)mutation);
        this.addPrefixes(mutationQuery);
        return Collections.singletonList(mutationQuery);
    }

    private void deleteAllEntityData(List<String> ids, SparqlUpdateQuery updateQuery, DeleteMutation mutation) {
        Var subject = new Var("entity");
        TriplePattern pattern = new TriplePattern((Value)subject, (Value)new Var("p"), new Var("o"));
        UnionCollection union = new UnionCollection();
        union.addNode(pattern);
        DeleteInsertQuery query = new DeleteInsertQuery();
        query.getDelete().addNode(pattern);
        List subjects = ids.stream().map(Iri::new).collect(Collectors.toList());
        query.getWhere().addNode(new Values(subject, subjects));
        query.getWhere().addNode(union);
        this.deleteInverseRelations(mutation, subject, query, union);
        this.addConstraints(mutation, query.getWhere(), subject);
        updateQuery.add(query);
    }

    private void deleteInverseRelations(DeleteMutation mutation, Var subject, DeleteInsertQuery query, UnionCollection union) {
        List<PropertyShape> inverseAliasProperties = this.getInverseAliasProperties(mutation);
        if (inverseAliasProperties.isEmpty()) {
            return;
        }
        ConstraintGenerator generator = new ConstraintGenerator(this.schema, this.options);
        Var inverseSubject = new Var("is");
        for (PropertyShape property : inverseAliasProperties) {
            Value predicate = SparqlBuilderUtil.getPropertyPredicate(property, null);
            SparqlNodeSequence sequence = new SparqlNodeSequence();
            TriplePattern inverse = new TriplePattern((Value)subject, predicate, inverseSubject);
            sequence.add(inverse);
            this.generatePropertyRangeConstraint(generator, inverseSubject, property).forEach(sequence::add);
            union.addNode(sequence);
            Inverse inversePredicate = (Inverse)predicate;
            query.getDelete().addNode(new TriplePattern((Value)inverseSubject, inversePredicate.toIri(), subject));
        }
    }

    @NotNull
    private List<PropertyShape> getInverseAliasProperties(DeleteMutation mutation) {
        return mutation.getResponseTypeInstance().getAllProperties().values().stream().filter(property -> property.getInverseAlias() != null).filter(property -> !property.getInverseAliasProperty().filter(SparqlUtil::isSparqlTemplate).isPresent()).collect(Collectors.toList());
    }

    private void deletedEntityNamedGraphs(List<String> ids, SparqlUpdateQuery updateQuery, DeleteMutation mutation) {
        Var graph = new Var("graph");
        List graphNames = ids.stream().map(id -> id + "/ng").map(Iri::new).collect(Collectors.toList());
        Values values = new Values(graph, graphNames);
        NamedGraphTriplePatternBlock namedGraph = new NamedGraphTriplePatternBlock(graph);
        Var subject = new Var("s");
        namedGraph.addNode(new TriplePattern((Value)subject, (Value)new Var("p"), new Var("o")));
        UnionCollection union = new UnionCollection();
        union.addNode(new SparqlNodeSequence(values, namedGraph));
        DeleteInsertQuery query = new DeleteInsertQuery();
        query.getDelete().addNode(namedGraph);
        query.getWhere().addNode(union);
        this.deleteInverseRelations(mutation, subject, query, union);
        this.deleteIncomingRelationsInGraphs(ids, subject, query, union, mutation);
        this.addConstraints(mutation, query.getWhere(), subject);
        updateQuery.add(query);
    }

    private void deleteIncomingRelationsInGraphs(List<String> ids, Var subject, DeleteInsertQuery query, UnionCollection union, DeleteMutation mutation) {
        List<PropertyShape> inverseAliasProperties = this.getInverseAliasProperties(mutation);
        if (inverseAliasProperties.isEmpty()) {
            return;
        }
        ConstraintGenerator generator = new ConstraintGenerator(this.schema, this.options);
        Var forwardGraph = new Var("graph");
        Var inverseGraph = new Var("inverseGraph");
        Var inverseSubject = new Var("is");
        UnionCollection propertySelections = new UnionCollection();
        for (PropertyShape property : inverseAliasProperties) {
            SparqlNodeSequence sequence = new SparqlNodeSequence();
            Value predicate = SparqlBuilderUtil.getPropertyPredicate(property, null);
            TriplePattern inverse = new TriplePattern((Value)subject, predicate, inverseSubject);
            sequence.add(new Bind(SparqlTermFunctions.iri(SparqlTermFunctions.concat(SparqlTermFunctions.str(inverseSubject), Literal.asString("/ng"))), inverseGraph));
            sequence.add(new Filter(new Or(new Exists(new NamedGraphTriplePatternBlock(forwardGraph).addNode(inverse)), new Exists(new NamedGraphTriplePatternBlock(inverseGraph).addNode(inverse)))));
            this.generatePropertyRangeConstraint(generator, inverseSubject, property).forEach(sequence::add);
            propertySelections.addNode(sequence);
            Inverse inversePredicate = (Inverse)predicate;
            query.getDelete().addNode(new TriplePattern((Value)inverseSubject, inversePredicate.toIri(), subject));
        }
        if (!propertySelections.isEmpty()) {
            SparqlNodeSequence sequence = new SparqlNodeSequence();
            List subjects = ids.stream().map(Iri::new).collect(Collectors.toList());
            sequence.add(new Values(subject, subjects));
            sequence.add(propertySelections);
            union.addNode(sequence);
        }
    }

    private List<SparqlNode> generatePropertyRangeConstraint(ConstraintGenerator generator, Var inverseSubject, PropertyShape property) {
        ArrayList<SparqlNode> constraints = new ArrayList<SparqlNode>();
        Shape rangeShape = property.getRangeShape();
        if (rangeShape != null) {
            generator.addBoTypeConstraint(Constraints.fromShapeIds((String[])new String[]{rangeShape.getId()}), constraints, ConstraintGenerator.SparqlBuildingContext.contextBuilder().subject(inverseSubject).filterGenerator(FilterFactory.filterGenerator(inverseSubject, FilterFactory.getFilterBuilder(this.schema, this.options, this.filterFactory))).build());
        }
        return constraints;
    }

    private void addConstraints(DeleteMutation mutation, TriplePatternBlock sparqlBlock, Var subject) {
        this.getMutationConstraintsSparql(mutation, subject, this.schema, this.options).ifPresent(sparqlBlock::addNode);
    }

    Optional<SparqlNode> getMutationConstraintsSparql(DeleteMutation mutation, Var subject, SomlSchema schema, OperationBuilderOptions options) {
        if (mutation.getConstraints() == null) {
            return Optional.empty();
        }
        Set typeConstraints = mutation.getConstraints().getTypeConstraints();
        if (typeConstraints == null || typeConstraints.isEmpty()) {
            return Optional.empty();
        }
        LinkedList<SparqlNode> sparqlNodes = new LinkedList<SparqlNode>();
        new ConstraintGenerator(schema, options).addBoTypeConstraint(typeConstraints, sparqlNodes, ConstraintGenerator.SparqlBuildingContext.contextBuilder().subject(subject).filterGenerator(FilterFactory.filterGenerator(subject, FilterFactory.getFilterBuilder(schema, options, this.filterFactory))).build());
        if (!sparqlNodes.isEmpty()) {
            return Optional.of(new SparqlNodeSequence(sparqlNodes));
        }
        return Optional.empty();
    }
}

