/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler;

import com.ontotext.graphql.compiler.BaseMutationSparqlGenerator;
import com.ontotext.graphql.compiler.FilterBuildResult;
import com.ontotext.graphql.compiler.FilterFactory;
import com.ontotext.graphql.compiler.querymodel.DeleteInsertQuery;
import com.ontotext.graphql.compiler.querymodel.Iri;
import com.ontotext.graphql.compiler.querymodel.Optional;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.SparqlUpdateQuery;
import com.ontotext.graphql.compiler.querymodel.TriplePattern;
import com.ontotext.graphql.compiler.querymodel.TriplePatternBlock;
import com.ontotext.graphql.compiler.querymodel.TriplePatternChain;
import com.ontotext.graphql.compiler.querymodel.UnionCollection;
import com.ontotext.graphql.compiler.querymodel.UnionNode;
import com.ontotext.graphql.compiler.querymodel.Value;
import com.ontotext.graphql.compiler.querymodel.Var;
import com.ontotext.models.InvalidSchemaException;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.mutation.Change;
import com.ontotext.models.mutation.CreateMutation;
import com.ontotext.models.mutation.Mutation;
import com.ontotext.models.mutation.PropertyChange;
import com.ontotext.models.query.FilteredSelection;
import com.ontotext.soaas.common.sparql.OperationBuilderOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

class EntityCreateSparqlGenerator
extends BaseMutationSparqlGenerator {
    EntityCreateSparqlGenerator(SomlSchema schema, OperationBuilderOptions options, FilterFactory filterFactory) {
        super(schema, options, filterFactory);
    }

    List<SparqlNode> generate(CreateMutation mutation) {
        List changes = mutation.getChanges();
        ArrayList<SparqlNode> mutationQueries = new ArrayList<SparqlNode>(changes.size());
        for (Change change : changes) {
            Iri id = new Iri(this.toRelativeIri(change.getId()));
            SparqlUpdateQuery mutationQuery = new SparqlUpdateQuery();
            this.processEntityCreate(change, id, mutationQuery);
            this.addBase(mutationQuery);
            this.configureMutation(mutationQuery, (Mutation)mutation);
            this.addPrefixes(mutationQuery);
            mutationQueries.add(mutationQuery);
        }
        return mutationQueries;
    }

    private void processEntityCreate(Change change, Iri idConst, SparqlUpdateQuery mutationQuery) {
        DeleteInsertQuery deleteInsertQuery = new DeleteInsertQuery();
        this.addChanges(idConst, change.getGraph(), change.getShape(), change.getChanges(), change.getAllFilteredObjects(), deleteInsertQuery);
        mutationQuery.add(deleteInsertQuery);
    }

    private void addChanges(Iri id, String graph, Shape shape, List<PropertyChange> changes, Map<String, List<FilteredSelection>> filters, DeleteInsertQuery query) {
        TriplePatternChain insertChain = new TriplePatternChain(id);
        changes.stream().filter(PropertyChange::hasValue).forEach(change -> this.processChange((PropertyChange)change, shape, insertChain, id, query, graph));
        filters.forEach((propName, value) -> {
            UnionCollection unionCollection = new UnionCollection();
            for (int i = 0; i < value.size(); ++i) {
                Value filterPredicate = this.createPredicate((String)propName, shape);
                java.util.Optional propShape = shape.getProperty(propName);
                Shape nestedShape = shape;
                if (propShape.filter(PropertyShape::isObjectType).isPresent()) {
                    nestedShape = (Shape)shape.getContainedIn().get((Object)((PropertyShape)propShape.get()).getRange());
                }
                Var object = new Var("nested_" + propName + "_" + i);
                insertChain.add(filterPredicate, object);
                FilterFactory filterFactory = new FilterFactory();
                FilterBuildResult filter = filterFactory.getMutationFilter(object, nestedShape, (FilteredSelection)value.get(i), "change" + i, this.options);
                TriplePatternBlock filterBlock = new TriplePatternBlock(filter.getSparql());
                filterBlock.addNode(new TriplePattern((Value)object, (Value)new Var("p"), new Var("o")));
                SparqlNode filterNode = filterBlock;
                if (propShape.filter(prop -> !prop.isRequired()).isPresent()) {
                    filterNode = new Optional(filterNode);
                }
                filterNode = new UnionNode(filterNode);
                unionCollection.addNode(filterNode);
            }
            query.getWhere().addNode(unionCollection);
        });
        this.appendToInsertBlock(id, graph, query, insertChain);
    }

    private void processChange(PropertyChange change, Shape shape, TriplePatternChain insertChain, Iri parentId, DeleteInsertQuery query, String graph) {
        String normalizedName = this.schema.getPrefixes().nameToShortIri(change.getName());
        PropertyShape propShape = shape.getPropertyOrFail(normalizedName);
        if (null != propShape.getInverseAlias()) {
            Iri inverseId = new Iri(this.toRelativeIri(change.getValue().toString()));
            TriplePatternChain inverseChain = new TriplePatternChain(inverseId);
            this.addInverseAliasProps(propShape, shape, parentId, inverseChain);
            this.appendToInsertBlock(inverseId, graph, query, inverseChain);
        } else {
            this.convertValue(change.getValue(), value -> insertChain.add(this.createPredicate(change.getName(), shape), (Value)value));
        }
        if (null != propShape.getInverseOf()) {
            Shape targetShape = (Shape)shape.getContainedIn().get((Object)propShape.getRange());
            if (null == targetShape || !targetShape.getProperty(propShape.getInverseOf()).isPresent()) {
                throw new InvalidSchemaException(String.format("The inverse of %s.%s, %s targets an invalid property!", shape.getId(), propShape.getName(), propShape.getInverseOf()));
            }
            Iri inverseId = new Iri(change.getValue().toString());
            TriplePatternChain inverseChain = new TriplePatternChain(inverseId);
            PropertyShape targetProp = targetShape.getPropertyOrFail(propShape.getInverseOf());
            inverseChain.add(this.createPredicate(targetProp.getName(), targetShape), parentId);
            this.appendToInsertBlock(inverseId, graph, query, inverseChain);
        }
    }

    private void addInverseAliasProps(PropertyShape propShape, Shape shape, Iri parentId, TriplePatternChain inverseChain) {
        Iri aliasPredicate = propShape.getInverseAliasProperty().map(Iri::new).orElseThrow(this.unknownProperty(propShape.getName(), shape.getId()));
        inverseChain.add(aliasPredicate, parentId);
        Shape targetShape = (Shape)shape.getContainedIn().get((Object)propShape.getRange());
        if (null == targetShape) {
            throw new InvalidSchemaException(String.format("The inverse alias of %s.%s, %s targets an invalid property!", shape.getId(), propShape.getName(), propShape.getInverseOf()));
        }
        targetShape.getProperty(propShape.getInverseAlias()).ifPresent(referredPropShape -> {
            if (null != referredPropShape.getInverseAlias()) {
                this.addInverseAliasProps((PropertyShape)referredPropShape, targetShape, parentId, inverseChain);
            }
        });
    }

    private Supplier<InvalidSchemaException> unknownProperty(String propName, String shapeId) {
        return () -> InvalidSchemaException.propertyNotFound((String)propName, (String)shapeId);
    }
}

