/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.mapping;

import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.statistics.StatisticsListener;
import com.ontotext.trree.plugin.externalsync.SearchOptions;
import com.ontotext.trree.plugin.externalsync.api.ConnectorServerException;
import com.ontotext.trree.plugin.externalsync.api.ConnectorUserException;
import com.ontotext.trree.plugin.externalsync.impl.embedding.EmbeddingModelUtil;
import com.ontotext.trree.plugin.externalsync.impl.embedding.VectorBuilder;
import com.ontotext.trree.plugin.externalsync.impl.opensearch.mapping.SemanticProperty;
import com.ontotext.trree.plugin.externalsync.impl.opensearch.util.GraphDBPropertyWrapper;
import com.ontotext.trree.plugin.externalsync.impl.opensearch.util.GraphDBSearchRequestBuilder;
import com.ontotext.trree.plugin.externalsync.iterators.master.MasterResultIterator;
import com.ontotext.trree.plugin.externalsync.util.EntitiesUtil;
import com.ontotext.trree.plugin.externalsync.util.StatisticsUtil;
import com.ontotext.trree.sdk.PluginConnection;
import com.ontotext.trree.sdk.Repository;
import dev.langchain4j.data.embedding.Embedding;
import jakarta.json.Json;
import jakarta.json.stream.JsonGenerator;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.eclipse.rdf4j.model.Value;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.jackson.JacksonJsonProvider;
import org.opensearch.client.json.jackson.JacksonJsonpMapper;
import org.opensearch.client.opensearch._types.ErrorCause;
import org.opensearch.client.opensearch._types.OpenSearchException;
import org.opensearch.client.opensearch._types.mapping.AggregateMetricDoubleProperty;
import org.opensearch.client.opensearch._types.mapping.BinaryProperty;
import org.opensearch.client.opensearch._types.mapping.BooleanProperty;
import org.opensearch.client.opensearch._types.mapping.ByteNumberProperty;
import org.opensearch.client.opensearch._types.mapping.CompletionProperty;
import org.opensearch.client.opensearch._types.mapping.CorePropertyBase;
import org.opensearch.client.opensearch._types.mapping.DateNanosProperty;
import org.opensearch.client.opensearch._types.mapping.DateProperty;
import org.opensearch.client.opensearch._types.mapping.DateRangeProperty;
import org.opensearch.client.opensearch._types.mapping.DoubleNumberProperty;
import org.opensearch.client.opensearch._types.mapping.DoubleRangeProperty;
import org.opensearch.client.opensearch._types.mapping.FieldAliasProperty;
import org.opensearch.client.opensearch._types.mapping.FlatObjectProperty;
import org.opensearch.client.opensearch._types.mapping.FloatNumberProperty;
import org.opensearch.client.opensearch._types.mapping.FloatRangeProperty;
import org.opensearch.client.opensearch._types.mapping.GeoPointProperty;
import org.opensearch.client.opensearch._types.mapping.GeoShapeProperty;
import org.opensearch.client.opensearch._types.mapping.HalfFloatNumberProperty;
import org.opensearch.client.opensearch._types.mapping.HistogramProperty;
import org.opensearch.client.opensearch._types.mapping.IndexOptions;
import org.opensearch.client.opensearch._types.mapping.IntegerNumberProperty;
import org.opensearch.client.opensearch._types.mapping.IntegerRangeProperty;
import org.opensearch.client.opensearch._types.mapping.IpProperty;
import org.opensearch.client.opensearch._types.mapping.IpRangeProperty;
import org.opensearch.client.opensearch._types.mapping.JoinProperty;
import org.opensearch.client.opensearch._types.mapping.KeywordProperty;
import org.opensearch.client.opensearch._types.mapping.KnnVectorProperty;
import org.opensearch.client.opensearch._types.mapping.LongNumberProperty;
import org.opensearch.client.opensearch._types.mapping.LongRangeProperty;
import org.opensearch.client.opensearch._types.mapping.Murmur3HashProperty;
import org.opensearch.client.opensearch._types.mapping.NestedProperty;
import org.opensearch.client.opensearch._types.mapping.ObjectProperty;
import org.opensearch.client.opensearch._types.mapping.PercolatorProperty;
import org.opensearch.client.opensearch._types.mapping.Property;
import org.opensearch.client.opensearch._types.mapping.PropertyBase;
import org.opensearch.client.opensearch._types.mapping.PropertyVariant;
import org.opensearch.client.opensearch._types.mapping.RankFeatureProperty;
import org.opensearch.client.opensearch._types.mapping.RankFeaturesProperty;
import org.opensearch.client.opensearch._types.mapping.ScaledFloatNumberProperty;
import org.opensearch.client.opensearch._types.mapping.SearchAsYouTypeProperty;
import org.opensearch.client.opensearch._types.mapping.ShortNumberProperty;
import org.opensearch.client.opensearch._types.mapping.TextIndexPrefixes;
import org.opensearch.client.opensearch._types.mapping.TextProperty;
import org.opensearch.client.opensearch._types.mapping.TokenCountProperty;
import org.opensearch.client.opensearch._types.mapping.TypeMapping;
import org.opensearch.client.opensearch._types.mapping.UnsignedLongNumberProperty;
import org.opensearch.client.opensearch._types.mapping.VersionProperty;
import org.opensearch.client.opensearch._types.mapping.WildcardProperty;
import org.opensearch.client.opensearch._types.mapping.XyShapeProperty;
import org.opensearch.client.opensearch._types.query_dsl.BoolQuery;
import org.opensearch.client.opensearch._types.query_dsl.IdsQuery;
import org.opensearch.client.opensearch._types.query_dsl.KnnQuery;
import org.opensearch.client.opensearch._types.query_dsl.NeuralQuery;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBuilders;
import org.opensearch.client.opensearch._types.query_dsl.QueryHighlighter;
import org.opensearch.client.opensearch.core.BulkResponse;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.bulk.BulkResponseItem;
import org.opensearch.client.opensearch.core.search.Highlight;
import org.opensearch.client.opensearch.core.search.HighlightField;
import org.opensearch.client.opensearch.core.search.InnerHits;
import org.opensearch.client.opensearch.core.search.SourceConfig;
import org.opensearch.client.opensearch.core.search.TrackHits;
import org.opensearch.client.opensearch.indices.IndexSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpensearchUtil {
    private static final Logger logger = LoggerFactory.getLogger(OpensearchUtil.class);
    private static final Map<String, Property.Kind> PROPERTY_KIND_MAP = new HashMap<String, Property.Kind>();
    private static final String COERCE = "coerce";
    private static final String COPY_TO = "copy_to";
    private static final String DOC_VALUES = "doc_values";
    private static final String EAGER_GLOBAL_ORDINALS = "eager_global_ordinals";
    private static final String ENABLED = "enabled";
    private static final String IGNORE_ABOVE = "ignore_above";
    private static final String IGNORE_MALFORMED = "ignore_malformed";
    private static final String INDEX_OPTIONS = "index_options";
    private static final String INDEX_PHRASES = "index_phrases";
    private static final String INDEX_PREFIXES = "index_prefixes";
    private static final String META = "meta";
    private static final String NORMALIZER = "normalizer";
    private static final String NORMS = "norms";
    private static final String POSITION_INCREMENT_GAP = "position_increment_gap";
    private static final String SEARCH_ANALYZER = "search_analyzer";
    private static final String SIMILARITY = "similarity";
    private static final String OPENSEARCH_CONNECTOR_NAME = "opensearch-connector";
    public static final int DEFAULT_KNN_K = Config.getPropertyAsInt((String)"graphdb.opensearch.connector.knn_k", (int)10);

    private OpensearchUtil() {
    }

    public static SearchRequest.Builder searchBuilderWithCustomParameters(String indexName, VectorBuilder vectorBuilder, MasterResultIterator mri, Function<String, Property> propertyResolver) {
        Query query;
        String queryString;
        GraphDBSearchRequestBuilder searchBuilder = new GraphDBSearchRequestBuilder(vectorBuilder);
        searchBuilder.index(indexName, new String[0]);
        Highlight highlight = null;
        boolean useSubjectFilter = true;
        boolean useMriTrackHits = true;
        SearchOptions searchOptions = mri.getSearchOptions();
        if (mri.isSnippets()) {
            highlight = OpensearchUtil.buildHighlight(searchOptions);
            searchBuilder.highlight(highlight);
        }
        if ((queryString = mri.getQueryString()) == null || queryString.isEmpty()) {
            query = QueryBuilders.matchAll().build().toQuery();
        } else if ((queryString = queryString.trim()).startsWith("{")) {
            Integer offset;
            SearchRequest parsedRequest = searchBuilder.withJson(new StringReader(queryString)).build();
            useSubjectFilter = parsedRequest.postFilter() == null;
            useMriTrackHits = parsedRequest.trackTotalHits() == null;
            Integer size = parsedRequest.size();
            if (size != null) {
                searchOptions.setLimit(size.toString());
            }
            if ((offset = parsedRequest.from()) != null) {
                searchOptions.setOffset(offset.toString());
            }
            searchBuilder.size(null);
            searchBuilder.from(null);
            if (highlight != null && !OpensearchUtil.hasNestedHighlighter(parsedRequest.query())) {
                QueryHighlighter highlighter = new QueryHighlighter(highlight);
                query = highlighter.withJson(queryString);
            } else {
                query = parsedRequest.query();
            }
        } else {
            query = QueryBuilders.queryString().query(queryString).build().toQuery();
        }
        searchBuilder.query(query);
        String similarityQueryString = mri.getSimilarityQueryString();
        if (similarityQueryString != null && !similarityQueryString.isEmpty()) {
            Query vectorQuery;
            String[] similarityQueryParts = similarityQueryString.trim().split(":", 2);
            if (similarityQueryParts.length != 2) {
                throw new ConnectorUserException("Invalid similarity query format. Expected format: <field>:<text>");
            }
            Property field = propertyResolver.apply(similarityQueryParts[0]);
            AtomicReference<String> modelId = new AtomicReference<String>();
            if (field != null) {
                if (field._get() instanceof SemanticProperty) {
                    modelId.set(((SemanticProperty)field._get()).modelId());
                } else if (field._get() instanceof KnnVectorProperty) {
                    modelId.set(((KnnVectorProperty)field._get()).modelId());
                }
            }
            if (modelId.get() != null) {
                NeuralQuery neuralQuery = new NeuralQuery.Builder().field(similarityQueryParts[0]).queryText(similarityQueryParts[1]).modelId((String)modelId.get()).k(Integer.valueOf(DEFAULT_KNN_K)).build();
                vectorQuery = Query.of(k -> k.neural(neuralQuery));
            } else {
                if (vectorBuilder == null) {
                    EmbeddingModelUtil.throwNoProvidedEmbeddingModelImplementation();
                }
                Embedding embedding = vectorBuilder.embeddingFromText(similarityQueryParts[1]);
                KnnQuery knnQuery = new KnnQuery.Builder().k(Integer.valueOf(DEFAULT_KNN_K)).field(similarityQueryParts[0]).vector(embedding.vectorAsList()).build();
                vectorQuery = Query.of(k -> k.knn(knnQuery));
            }
            if (query._kind() == Query.Kind.MatchAll) {
                searchBuilder.query(vectorQuery);
            } else {
                searchBuilder.query(Query.of(q -> q.bool(b -> b.should(query, new Query[]{vectorQuery}))));
            }
        }
        OpensearchUtil.incrementVectorQueryStatistics(searchBuilder.build().query(), mri.getPluginConnection());
        searchBuilder.source((SourceConfig)new SourceConfig.Builder().fetch(Boolean.valueOf(false)).build());
        if (useSubjectFilter) {
            OpensearchUtil.setSubjectFilter(searchBuilder, mri);
        }
        if (mri.isTrackTotalHits() && useMriTrackHits) {
            searchBuilder.trackTotalHits((TrackHits)new TrackHits.Builder().enabled(Boolean.valueOf(true)).build());
        }
        return searchBuilder;
    }

    private static void incrementVectorQueryStatistics(@Nullable Query query, PluginConnection pluginConnection) {
        StatisticsListener statistics = StatisticsUtil.getStatisticsListenerFromRepository((Repository)pluginConnection.getRepository());
        if (statistics != null && query != null) {
            if (query.isKnn() || query.isNeural()) {
                statistics.incrementConnectorVectorQueriesCount(OPENSEARCH_CONNECTOR_NAME);
            }
            if (query.isBool()) {
                BoolQuery boolQuery = query.bool();
                if (boolQuery.should().stream().anyMatch(q -> q.isNeural() || q.isKnn())) {
                    statistics.incrementConnectorVectorQueriesCount(OPENSEARCH_CONNECTOR_NAME);
                }
                if (boolQuery.must().stream().anyMatch(q -> q.isNeural() || q.isKnn())) {
                    statistics.incrementConnectorVectorQueriesCount(OPENSEARCH_CONNECTOR_NAME);
                }
                if (boolQuery.filter().stream().anyMatch(q -> q.isNeural() || q.isKnn())) {
                    statistics.incrementConnectorVectorQueriesCount(OPENSEARCH_CONNECTOR_NAME);
                }
                if (boolQuery.mustNot().stream().anyMatch(q -> q.isNeural() || q.isKnn())) {
                    statistics.incrementConnectorVectorQueriesCount(OPENSEARCH_CONNECTOR_NAME);
                }
            }
        }
    }

    public static IndexSettings settingsFromJson(Object settings) {
        JacksonJsonpMapper mapper = new JacksonJsonpMapper();
        return (IndexSettings)IndexSettings._DESERIALIZER.deserialize(mapper.jsonProvider().createParser((Reader)new StringReader(settings.toString())), (JsonpMapper)mapper);
    }

    public static String toString(JsonpSerializable value) {
        JacksonJsonpMapper mapper = new JacksonJsonpMapper();
        JacksonJsonProvider provider = new JacksonJsonProvider();
        StringWriter string = new StringWriter();
        JsonGenerator generator = provider.createGenerator((Writer)string);
        value.serialize(generator, (JsonpMapper)mapper);
        generator.close();
        return string.toString();
    }

    public static TypeMapping mappingFromJson(String mapping) {
        JacksonJsonpMapper mapper = new JacksonJsonpMapper();
        return (TypeMapping)TypeMapping._DESERIALIZER.deserialize(mapper.jsonProvider().createParser((Reader)new StringReader(mapping)), (JsonpMapper)mapper);
    }

    public static <T> T handleOpenSearchException(String message, Exception e) {
        String specificMessage = null;
        if (e instanceof OpenSearchException) {
            try {
                OpenSearchException openSearchException = (OpenSearchException)e;
                List rootCause = openSearchException.response().error().rootCause();
                if (rootCause != null && !rootCause.isEmpty()) {
                    specificMessage = ((ErrorCause)rootCause.get(0)).reason();
                }
            }
            catch (Exception ex) {
                logger.error("Could not parse error response from ES due to: ", (Throwable)ex);
            }
        }
        if (specificMessage == null) {
            specificMessage = e.getMessage();
        }
        throw new ConnectorServerException(message + ": " + specificMessage, (Throwable)e);
    }

    public static String buildFailureMessage(BulkResponse response) {
        List responses = response.items();
        StringBuilder sb = new StringBuilder();
        sb.append("failure in bulk execution:");
        for (int i = 0; i < responses.size(); ++i) {
            BulkResponseItem tmp = (BulkResponseItem)responses.get(i);
            if (tmp.error() == null) continue;
            sb.append("\n[").append(i).append("]: index [").append(tmp.index()).append("], type [").append(tmp.operationType()).append("], id [").append(tmp.id()).append("], message [").append(tmp.error()).append("]");
        }
        return sb.toString();
    }

    public static void addMutableProperties(Map<String, Property> source, Map<String, Property> destination) {
        for (Map.Entry<String, Property> entry : source.entrySet()) {
            Property prop = entry.getValue();
            if ((prop.isNested() || prop.isObject() || prop.isGeoPoint()) && !(prop instanceof GraphDBPropertyWrapper)) {
                HashMap<String, Property> newMap = new HashMap<String, Property>();
                if (prop.isNested()) {
                    NestedProperty nested = prop.nested();
                    OpensearchUtil.addMutableProperties(nested.properties(), newMap);
                    destination.put(entry.getKey(), OpensearchUtil.buildNestedProperty(newMap));
                    continue;
                }
                if (prop.isObject()) {
                    ObjectProperty obj = prop.object();
                    OpensearchUtil.addMutableProperties(obj.properties(), newMap);
                    destination.put(entry.getKey(), OpensearchUtil.buildObjectProperty(newMap));
                    continue;
                }
                GeoPointProperty geo = prop.geoPoint();
                OpensearchUtil.addMutableProperties(geo.properties(), newMap);
                destination.put(entry.getKey(), OpensearchUtil.buildGeopointProperty(newMap, null, Collections.emptyMap()));
                continue;
            }
            destination.put(entry.getKey(), entry.getValue());
        }
    }

    public static Property buildProperty(String type, VectorBuilder vectorBuilder, Map<String, Property> properties) {
        return OpensearchUtil.buildProperty(type, false, null, null, null, null, vectorBuilder, properties, Collections.emptyMap());
    }

    public static Property buildProperty(String type, boolean fielddata, boolean index, boolean stored, String format, String analyzer, VectorBuilder vectorBuilder, Map<String, ?> nativeSettings) {
        return OpensearchUtil.buildProperty(type, fielddata, index, stored, format, analyzer, vectorBuilder, null, nativeSettings);
    }

    /*
     * Unable to fully structure code
     */
    private static Property buildProperty(String type, boolean fielddata, Boolean index, Boolean stored, String format, String analyzer, VectorBuilder vectorBuilder, Map<String, Property> properties, Map<String, ?> nativeSettings) {
        kind = OpensearchUtil.PROPERTY_KIND_MAP.get(type);
        switch (1.$SwitchMap$org$opensearch$client$opensearch$_types$mapping$Property$Kind[kind.ordinal()]) {
            case 1: {
                builder = new AggregateMetricDoubleProperty.Builder();
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                return builder.build().toProperty();
            }
            case 2: {
                builder = new BinaryProperty.Builder();
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get("doc_values"));
                return builder.build().toProperty();
            }
            case 3: {
                builder = (BooleanProperty.Builder)new BooleanProperty.Builder().index(index).store(stored);
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get("doc_values"));
                return builder.build().toProperty();
            }
            case 4: {
                builder = (ByteNumberProperty.Builder)((ByteNumberProperty.Builder)((ByteNumberProperty.Builder)((ByteNumberProperty.Builder)new ByteNumberProperty.Builder().index(index)).store(stored)).coerce((Boolean)nativeSettings.get("coerce"))).ignoreMalformed((Boolean)nativeSettings.get("ignore_malformed"));
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get("doc_values"));
                return builder.build().toProperty();
            }
            case 5: {
                builder = new CompletionProperty.Builder().analyzer(analyzer);
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get("doc_values"));
                return builder.build().toProperty();
            }
            case 6: {
                builder = ((DateNanosProperty.Builder)new DateNanosProperty.Builder().index(index).store(stored)).format(format).ignoreMalformed((Boolean)nativeSettings.get("ignore_malformed"));
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get("doc_values"));
                return builder.build().toProperty();
            }
            case 7: {
                builder = ((DateProperty.Builder)new DateProperty.Builder().index(index).store(stored)).format(format).ignoreMalformed((Boolean)nativeSettings.get("ignore_malformed"));
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get("doc_values"));
                return builder.build().toProperty();
            }
            case 8: {
                builder = ((DateRangeProperty.Builder)((DateRangeProperty.Builder)((DateRangeProperty.Builder)new DateRangeProperty.Builder().index(index)).store(stored)).coerce((Boolean)nativeSettings.get("coerce"))).format(format);
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get("doc_values"));
                return builder.build().toProperty();
            }
            case 9: {
                builder = (DoubleNumberProperty.Builder)((DoubleNumberProperty.Builder)((DoubleNumberProperty.Builder)((DoubleNumberProperty.Builder)new DoubleNumberProperty.Builder().index(index)).store(stored)).ignoreMalformed((Boolean)nativeSettings.get("ignore_malformed"))).coerce((Boolean)nativeSettings.get("coerce"));
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get("doc_values"));
                return builder.build().toProperty();
            }
            case 10: {
                builder = (DoubleRangeProperty.Builder)((DoubleRangeProperty.Builder)((DoubleRangeProperty.Builder)new DoubleRangeProperty.Builder().index(index)).store(stored)).coerce((Boolean)nativeSettings.get("coerce"));
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get("doc_values"));
                return builder.build().toProperty();
            }
            case 11: {
                builder = new FieldAliasProperty.Builder();
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                return builder.build().toProperty();
            }
            case 12: {
                builder = new FlatObjectProperty.Builder();
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                return builder.build().toProperty();
            }
            case 13: {
                builder = (FloatNumberProperty.Builder)((FloatNumberProperty.Builder)((FloatNumberProperty.Builder)((FloatNumberProperty.Builder)new FloatNumberProperty.Builder().ignoreMalformed((Boolean)nativeSettings.get("ignore_malformed"))).index(index)).coerce((Boolean)nativeSettings.get("coerce"))).store(stored);
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get("doc_values"));
                return builder.build().toProperty();
            }
            case 14: {
                builder = (FloatRangeProperty.Builder)((FloatRangeProperty.Builder)((FloatRangeProperty.Builder)new FloatRangeProperty.Builder().index(index)).store(stored)).coerce((Boolean)nativeSettings.get("coerce"));
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get("doc_values"));
                return builder.build().toProperty();
            }
            case 15: {
                return OpensearchUtil.buildGeopointProperty(properties, stored, nativeSettings);
            }
            case 16: {
                builder = (GeoShapeProperty.Builder)new GeoShapeProperty.Builder().ignoreMalformed((Boolean)nativeSettings.get("ignore_malformed")).coerce((Boolean)nativeSettings.get("coerce")).store(stored);
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get("doc_values"));
                return builder.build().toProperty();
            }
            case 17: {
                builder = (HalfFloatNumberProperty.Builder)((HalfFloatNumberProperty.Builder)((HalfFloatNumberProperty.Builder)((HalfFloatNumberProperty.Builder)new HalfFloatNumberProperty.Builder().index(index)).store(stored)).ignoreMalformed((Boolean)nativeSettings.get("ignore_malformed"))).coerce((Boolean)nativeSettings.get("coerce"));
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get("doc_values"));
                return builder.build().toProperty();
            }
            case 18: {
                builder = new HistogramProperty.Builder().ignoreMalformed((Boolean)nativeSettings.get("ignore_malformed"));
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                return builder.build().toProperty();
            }
            case 19: {
                builder = (IntegerNumberProperty.Builder)((IntegerNumberProperty.Builder)((IntegerNumberProperty.Builder)((IntegerNumberProperty.Builder)new IntegerNumberProperty.Builder().index(index)).store(stored)).ignoreMalformed((Boolean)nativeSettings.get("ignore_malformed"))).coerce((Boolean)nativeSettings.get("coerce"));
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get("doc_values"));
                return builder.build().toProperty();
            }
            case 20: {
                builder = (IntegerRangeProperty.Builder)((IntegerRangeProperty.Builder)((IntegerRangeProperty.Builder)new IntegerRangeProperty.Builder().index(index)).coerce((Boolean)nativeSettings.get("coerce"))).store(stored);
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get("doc_values"));
                return builder.build().toProperty();
            }
            case 21: {
                builder = (IpProperty.Builder)new IpProperty.Builder().ignoreMalformed((Boolean)nativeSettings.get("ignore_malformed")).index(index).store(stored);
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get("doc_values"));
                return builder.build().toProperty();
            }
            case 22: {
                builder = (IpRangeProperty.Builder)((IpRangeProperty.Builder)((IpRangeProperty.Builder)new IpRangeProperty.Builder().index(index)).coerce((Boolean)nativeSettings.get("coerce"))).store(stored);
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get("doc_values"));
                return builder.build().toProperty();
            }
            case 23: {
                builder = new JoinProperty.Builder();
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                return builder.build().toProperty();
            }
            case 24: {
                builder = (KeywordProperty.Builder)new KeywordProperty.Builder().index(index).store(stored);
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get("doc_values"));
                builder.eagerGlobalOrdinals((Boolean)nativeSettings.get("eager_global_ordinals"));
                if (nativeSettings.get("index_options") != null) {
                    builder.indexOptions(IndexOptions.valueOf((String)((String)nativeSettings.get("index_options"))));
                }
                builder.normalizer((String)nativeSettings.get("normalizer"));
                builder.norms((Boolean)nativeSettings.get("norms"));
                return builder.build().toProperty();
            }
            case 25: {
                builder = (LongNumberProperty.Builder)((LongNumberProperty.Builder)((LongNumberProperty.Builder)((LongNumberProperty.Builder)new LongNumberProperty.Builder().index(index)).store(stored)).ignoreMalformed((Boolean)nativeSettings.get("ignore_malformed"))).coerce((Boolean)nativeSettings.get("coerce"));
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get("doc_values"));
                return builder.build().toProperty();
            }
            case 26: {
                builder = (LongRangeProperty.Builder)((LongRangeProperty.Builder)((LongRangeProperty.Builder)new LongRangeProperty.Builder().index(index)).coerce((Boolean)nativeSettings.get("coerce"))).store(stored);
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get("doc_values"));
                return builder.build().toProperty();
            }
            case 27: {
                builder = (Murmur3HashProperty.Builder)new Murmur3HashProperty.Builder().store(stored);
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get("doc_values"));
                return builder.build().toProperty();
            }
            case 28: {
                return OpensearchUtil.buildNestedProperty(properties);
            }
            case 29: {
                return OpensearchUtil.buildObjectProperty(properties, nativeSettings);
            }
            case 30: {
                builder = new PercolatorProperty.Builder();
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                return builder.build().toProperty();
            }
            case 31: {
                builder = new RankFeatureProperty.Builder();
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                return builder.build().toProperty();
            }
            case 32: {
                builder = new RankFeaturesProperty.Builder();
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                return builder.build().toProperty();
            }
            case 33: {
                builder = (ScaledFloatNumberProperty.Builder)((ScaledFloatNumberProperty.Builder)((ScaledFloatNumberProperty.Builder)((ScaledFloatNumberProperty.Builder)new ScaledFloatNumberProperty.Builder().index(index)).store(stored)).ignoreMalformed((Boolean)nativeSettings.get("ignore_malformed"))).coerce((Boolean)nativeSettings.get("coerce"));
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get("doc_values"));
                builder.scalingFactor(Double.valueOf(nativeSettings.get("scaling_factor").toString()));
                return builder.build().toProperty();
            }
            case 34: {
                builder = ((SearchAsYouTypeProperty.Builder)new SearchAsYouTypeProperty.Builder().index(index).store(stored)).analyzer(analyzer);
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                return builder.build().toProperty();
            }
            case 35: {
                builder = (XyShapeProperty.Builder)new XyShapeProperty.Builder().ignoreMalformed((Boolean)nativeSettings.get("ignore_malformed")).coerce((Boolean)nativeSettings.get("coerce")).store(stored);
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get("doc_values"));
                return builder.build().toProperty();
            }
            case 36: {
                builder = (ShortNumberProperty.Builder)((ShortNumberProperty.Builder)((ShortNumberProperty.Builder)((ShortNumberProperty.Builder)new ShortNumberProperty.Builder().index(index)).store(stored)).ignoreMalformed((Boolean)nativeSettings.get("ignore_malformed"))).coerce((Boolean)nativeSettings.get("coerce"));
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get("doc_values"));
                return builder.build().toProperty();
            }
            case 37: {
                if (!"semantic".equals(type)) ** GOTO lbl245
                jsonWriter = new StringWriter();
                generator = Json.createGenerator((Writer)jsonWriter);
                try {
                    OpensearchUtil.writeJsonFromMap(generator, nativeSettings);
                }
                finally {
                    if (generator != null) {
                        generator.close();
                    }
                }
                parser = Json.createParser((Reader)new StringReader(jsonWriter.toString()));
                try {
                    property = (SemanticProperty)SemanticProperty._DESERIALIZER.deserialize(parser, (JsonpMapper)new JacksonJsonpMapper());
                    var13_59 = property.toProperty();
                    return var13_59;
                }
                finally {
                    if (parser != null) {
                        parser.close();
                    }
                }
lbl245:
                // 1 sources

                builder = ((TextProperty.Builder)new TextProperty.Builder().index(index).store(stored)).analyzer(analyzer);
                if (fielddata) {
                    builder.fielddata(Boolean.valueOf(true));
                }
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.indexPhrases((Boolean)nativeSettings.get("index_phrases"));
                prefixes = nativeSettings.get("index_prefixes");
                if (prefixes != null) {
                    prefBuilder = new TextIndexPrefixes.Builder();
                    prefMap = (Map)prefixes;
                    if (prefMap.containsKey("max_chars")) {
                        prefBuilder.maxChars(((Integer)prefMap.get("max_chars")).intValue());
                    }
                    if (prefMap.containsKey("min_chars")) {
                        prefBuilder.minChars(((Integer)prefMap.get("min_chars")).intValue());
                    }
                    builder.indexPrefixes(prefBuilder.build());
                }
                builder.searchAnalyzer((String)nativeSettings.get("search_analyzer"));
                builder.positionIncrementGap((Integer)nativeSettings.get("position_increment_gap"));
                builder.norms((Boolean)nativeSettings.get("norms"));
                builder.eagerGlobalOrdinals((Boolean)nativeSettings.get("eager_global_ordinals"));
                if (nativeSettings.get("index_options") != null) {
                    builder.indexOptions(IndexOptions.valueOf((String)((String)nativeSettings.get("index_options"))));
                }
                return builder.build().toProperty();
            }
            case 38: {
                builder = ((TokenCountProperty.Builder)new TokenCountProperty.Builder().index(index).store(stored)).analyzer(analyzer);
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get("doc_values"));
                return builder.build().toProperty();
            }
            case 39: {
                builder = (UnsignedLongNumberProperty.Builder)((UnsignedLongNumberProperty.Builder)((UnsignedLongNumberProperty.Builder)new UnsignedLongNumberProperty.Builder().index(index)).store(stored)).ignoreMalformed((Boolean)nativeSettings.get("ignore_malformed"));
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get("doc_values"));
                return builder.build().toProperty();
            }
            case 40: {
                builder = (VersionProperty.Builder)new VersionProperty.Builder().store(stored);
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get("doc_values"));
                return builder.build().toProperty();
            }
            case 41: {
                builder = (WildcardProperty.Builder)new WildcardProperty.Builder().store(stored);
                OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
                OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
                builder.docValues((Boolean)nativeSettings.get("doc_values"));
                return builder.build().toProperty();
            }
            case 42: {
                safeSettings = new HashMap<String, ?>(nativeSettings);
                if (!safeSettings.containsKey("dimension")) {
                    if (!safeSettings.containsKey("model_id")) {
                        if (vectorBuilder == null) {
                            EmbeddingModelUtil.throwNoProvidedEmbeddingModelImplementation();
                        }
                        safeSettings.put("dimension", vectorBuilder.embeddingModelDimension());
                    } else {
                        throw new IllegalArgumentException("Cannot determine dimension for KNN vector property. The 'dimension' field is missing, and a 'model_id' was provided (" + String.valueOf(safeSettings.get("model_id")) + "). Please provide a 'dimension' explicitly for the selected model.");
                    }
                }
                jsonWriter = new StringWriter();
                generator = Json.createGenerator((Writer)jsonWriter);
                try {
                    OpensearchUtil.writeJsonFromMap(generator, safeSettings);
                }
                finally {
                    if (generator != null) {
                        generator.close();
                    }
                }
                parser = Json.createParser((Reader)new StringReader(jsonWriter.toString()));
                try {
                    property = (KnnVectorProperty)KnnVectorProperty._DESERIALIZER.deserialize(parser, (JsonpMapper)new JacksonJsonpMapper());
                    var14_66 = property.toProperty();
                    return var14_66;
                }
                finally {
                    if (parser != null) {
                        parser.close();
                    }
                }
            }
        }
        throw new IllegalArgumentException("Unknown property type " + type);
    }

    private static void setSubjectFilter(SearchRequest.Builder searchRequest, MasterResultIterator mri) {
        if (mri.getEntitySubjectFilter() != 0L) {
            IdsQuery queryBuilder = QueryBuilders.ids().values(EntitiesUtil.valueToString((Value)mri.getEntities().get(mri.getEntitySubjectFilter())), new String[0]).build();
            searchRequest.postFilter(queryBuilder.toQuery());
        }
    }

    private static Highlight buildHighlight(SearchOptions searchOptions) {
        Highlight.Builder highlightBuilder = new Highlight.Builder();
        highlightBuilder.fields("*", new HighlightField.Builder().build());
        highlightBuilder.preTags(searchOptions.snippetPre, new String[0]);
        highlightBuilder.postTags(searchOptions.snippetPost, new String[0]);
        if (searchOptions.snippetSize > 0) {
            highlightBuilder.fragmentSize(Integer.valueOf(searchOptions.snippetSize));
        }
        return highlightBuilder.build();
    }

    private static boolean hasNestedHighlighter(Query query) {
        if (query == null) {
            return true;
        }
        boolean result = false;
        if (query.isNested()) {
            InnerHits hits = query.nested().innerHits();
            if (hits != null) {
                result = hits.highlight() != null;
            }
        } else if (query.isBool()) {
            for (Query q : query.bool().should()) {
                result |= OpensearchUtil.hasNestedHighlighter(q);
            }
            if (!result) {
                for (Query q : query.bool().must()) {
                    result |= OpensearchUtil.hasNestedHighlighter(q);
                }
            }
        }
        return result;
    }

    private static <U extends CorePropertyBase.AbstractBuilder> void addCopyAndSimilarityToProperty(U builder, Map<String, ?> nativeSettings) {
        Object copyTo = nativeSettings.get(COPY_TO);
        if (copyTo != null) {
            if (copyTo instanceof List) {
                builder.copyTo((List)copyTo);
            } else {
                builder.copyTo((String)copyTo, new String[0]);
            }
        }
        builder.similarity((String)nativeSettings.get(SIMILARITY));
    }

    private static <U extends PropertyBase.AbstractBuilder> void addIgnoreAboveAndMetaToProperty(U builder, Map<String, ?> nativeSettings) {
        builder.ignoreAbove((Integer)nativeSettings.get(IGNORE_ABOVE));
        Object meta = nativeSettings.get(META);
        if (meta != null) {
            builder.meta((Map)meta);
        }
    }

    private static Property buildNestedProperty(Map<String, Property> properties) {
        if (properties == null) {
            properties = new HashMap<String, Property>();
        }
        NestedProperty.Builder builder = (NestedProperty.Builder)new NestedProperty.Builder().properties(properties);
        return new GraphDBPropertyWrapper((PropertyVariant)builder.build(), properties);
    }

    private static Property buildGeopointProperty(Map<String, Property> properties, Boolean stored, Map<String, ?> nativeSettings) {
        if (properties == null) {
            properties = new HashMap<String, Property>();
        }
        GeoPointProperty.Builder builder = new GeoPointProperty.Builder().ignoreMalformed((Boolean)nativeSettings.get(IGNORE_MALFORMED));
        builder.store(stored);
        OpensearchUtil.addCopyAndSimilarityToProperty(builder, nativeSettings);
        OpensearchUtil.addIgnoreAboveAndMetaToProperty(builder, nativeSettings);
        builder.docValues((Boolean)nativeSettings.get(DOC_VALUES));
        return new GraphDBPropertyWrapper((PropertyVariant)builder.build(), properties);
    }

    private static Property buildObjectProperty(Map<String, Property> properties) {
        return OpensearchUtil.buildObjectProperty(properties, Collections.emptyMap());
    }

    private static Property buildObjectProperty(Map<String, Property> properties, Map<String, ?> nativeSettings) {
        if (properties == null) {
            properties = new HashMap<String, Property>();
        }
        ObjectProperty.Builder builder = ((ObjectProperty.Builder)new ObjectProperty.Builder().properties(properties)).enabled((Boolean)nativeSettings.get(ENABLED));
        return new GraphDBPropertyWrapper((PropertyVariant)builder.build(), properties);
    }

    private static void writeJsonFromMap(JsonGenerator generator, Map<String, ?> map) {
        generator.writeStartObject();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                generator.writeKey(key);
                OpensearchUtil.writeJsonFromMap(generator, (Map)value);
                continue;
            }
            if (value instanceof List) {
                generator.writeKey(key);
                generator.writeStartArray();
                for (Object item : (List)value) {
                    if (item instanceof Map) {
                        OpensearchUtil.writeJsonFromMap(generator, (Map)item);
                        continue;
                    }
                    if (item instanceof String) {
                        generator.write((String)item);
                        continue;
                    }
                    if (item instanceof Number) {
                        generator.write(((Number)item).doubleValue());
                        continue;
                    }
                    if (!(item instanceof Boolean)) continue;
                    generator.write(((Boolean)item).booleanValue());
                }
                generator.writeEnd();
                continue;
            }
            if (value instanceof String) {
                generator.write(key, (String)value);
                continue;
            }
            if (value instanceof Number) {
                generator.write(key, ((Number)value).doubleValue());
                continue;
            }
            if (value instanceof Boolean) {
                generator.write(key, ((Boolean)value).booleanValue());
                continue;
            }
            if (value != null) continue;
            generator.writeNull(key);
        }
        generator.writeEnd();
    }

    static {
        for (Property.Kind type : Property.Kind.values()) {
            PROPERTY_KIND_MAP.put(type.jsonValue(), type);
        }
        PROPERTY_KIND_MAP.put("semantic", Property.Kind.Text);
    }
}

