/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.opensearch.util;

import com.ontotext.trree.plugin.externalsync.impl.embedding.VectorBuilder;
import com.ontotext.trree.plugin.externalsync.impl.opensearch.util.GraphDBQuery;
import jakarta.json.stream.JsonParser;
import java.io.Reader;
import org.opensearch.client.json.DelegatingDeserializer;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpMapperBase;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.jackson.JacksonJsonpMapper;
import org.opensearch.client.opensearch.core.SearchRequest;

public class GraphDBSearchRequestBuilder
extends SearchRequest.Builder {
    private final VectorBuilder vectorBuilder;

    public GraphDBSearchRequestBuilder(VectorBuilder vectorBuilder) {
        this.vectorBuilder = vectorBuilder;
    }

    public GraphDBSearchRequestBuilder withJson(Reader input) {
        JacksonJsonpMapper mapper = new JacksonJsonpMapper();
        return this.withJson(mapper.jsonProvider().createParser(input), (JsonpMapper)mapper);
    }

    public GraphDBSearchRequestBuilder withJson(JsonParser parser, JsonpMapper mapper) {
        JsonpDeserializer classDeser = JsonpMapperBase.findDeserializer(SearchRequest.class);
        if (classDeser == null) {
            throw new IllegalArgumentException("Class SearchRequest cannot be read from JSON");
        }
        ObjectDeserializer builderDeser = (ObjectDeserializer)DelegatingDeserializer.unwrap((JsonpDeserializer)classDeser);
        builderDeser.ignore("_source");
        GraphDBQuery.TEXT_TO_VECTOR_DESERIALIZER.setVectorBuilder(this.vectorBuilder);
        builderDeser.add(SearchRequest.Builder::query, GraphDBQuery._DESERIALIZER, "query");
        return (GraphDBSearchRequestBuilder)((Object)builderDeser.deserialize((Object)this, parser, mapper, parser.next()));
    }

    protected void _checkSingleUse() {
    }
}

