/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.opensearch.mapping;

import jakarta.json.stream.JsonGenerator;
import org.jetbrains.annotations.NotNull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.mapping.Property;
import org.opensearch.client.opensearch._types.mapping.PropertyBase;
import org.opensearch.client.opensearch._types.mapping.PropertyVariant;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class SemanticProperty
extends PropertyBase
implements PropertyVariant {
    private final String modelId;
    private final String searchModelId;
    private final String chunking;
    private final Integer dimension;
    private final Boolean knn;
    public static final JsonpDeserializer<SemanticProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(SemanticPropertyBuilder::new, SemanticProperty::setupSemanticPropertyDeserializer);

    public SemanticProperty(SemanticPropertyBuilder builder) {
        super((PropertyBase.AbstractBuilder)builder);
        this.modelId = builder.modelId;
        this.searchModelId = builder.searchModelId;
        this.chunking = builder.chunking;
        this.dimension = builder.dimension;
        this.knn = builder.knn;
    }

    public String modelId() {
        return this.modelId;
    }

    public String searchModelId() {
        return this.searchModelId;
    }

    public String chunking() {
        return this.chunking;
    }

    public Integer dimension() {
        return this.dimension;
    }

    public Boolean knn() {
        return this.knn;
    }

    public Property.Kind _propertyKind() {
        return Property.Kind.Text;
    }

    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.write("type", "semantic");
        generator.write("model_id", this.modelId);
        if (this.searchModelId != null) {
            generator.write("search_model_id", this.searchModelId);
        }
        if (this.chunking != null) {
            generator.write("chunking", this.chunking);
        }
        if (this.dimension != null) {
            generator.write("dimension", this.dimension.intValue());
        }
        if (this.knn != null) {
            generator.write("knn", this.knn.booleanValue());
        }
        generator.writeEnd();
    }

    public static SemanticPropertyBuilder builder() {
        return new SemanticPropertyBuilder();
    }

    protected static void setupSemanticPropertyDeserializer(ObjectDeserializer<SemanticPropertyBuilder> op) {
        op.add(SemanticPropertyBuilder::modelId, JsonpDeserializer.stringDeserializer(), "model_id");
        op.add(SemanticPropertyBuilder::searchModelId, JsonpDeserializer.stringDeserializer(), "search_model_id");
        op.add(SemanticPropertyBuilder::chunking, JsonpDeserializer.stringDeserializer(), "chunking");
        op.add(SemanticPropertyBuilder::dimension, JsonpDeserializer.integerDeserializer(), "dimension");
        op.add(SemanticPropertyBuilder::knn, JsonpDeserializer.booleanDeserializer(), "knn");
    }

    public static class SemanticPropertyBuilder
    extends PropertyBase.AbstractBuilder<SemanticPropertyBuilder>
    implements ObjectBuilder<SemanticProperty> {
        String modelId;
        String searchModelId;
        String chunking;
        Integer dimension;
        Boolean knn;

        public SemanticPropertyBuilder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public SemanticPropertyBuilder searchModelId(String searchModelId) {
            this.searchModelId = searchModelId;
            return this;
        }

        public SemanticPropertyBuilder chunking(String chunking) {
            this.chunking = chunking;
            return this;
        }

        public SemanticPropertyBuilder dimension(Integer dimension) {
            this.dimension = dimension;
            return this;
        }

        public SemanticPropertyBuilder knn(Boolean knn) {
            this.knn = knn;
            return this;
        }

        public SemanticProperty build() {
            return new SemanticProperty(this);
        }

        @NotNull
        protected SemanticPropertyBuilder self() {
            return this;
        }
    }
}

