/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.opensearch;

import com.google.common.annotations.VisibleForTesting;
import com.ontotext.graphdb.Config;
import com.ontotext.trree.plugin.externalsync.SearchOptions;
import com.ontotext.trree.plugin.externalsync.api.ConnectorServerException;
import com.ontotext.trree.plugin.externalsync.api.ConnectorUserException;
import com.ontotext.trree.plugin.externalsync.api.ExternalStore;
import com.ontotext.trree.plugin.externalsync.auth.HttpClient5Configurator;
import com.ontotext.trree.plugin.externalsync.auth.UsernamePasswordProvider;
import com.ontotext.trree.plugin.externalsync.config.Options;
import com.ontotext.trree.plugin.externalsync.config.OptionsUtil;
import com.ontotext.trree.plugin.externalsync.impl.embedding.EmbeddingModelUtil;
import com.ontotext.trree.plugin.externalsync.impl.embedding.VectorBuilder;
import com.ontotext.trree.plugin.externalsync.impl.opensearch.OpensearchClientSupplier;
import com.ontotext.trree.plugin.externalsync.impl.opensearch.OpensearchPlugin;
import com.ontotext.trree.plugin.externalsync.impl.opensearch.OpensearchResult;
import com.ontotext.trree.plugin.externalsync.impl.opensearch.util.GraphDBBulkRequestBuilder;
import com.ontotext.trree.plugin.externalsync.iterators.master.MasterResultIterator;
import com.ontotext.trree.plugin.externalsync.util.EntitiesUtil;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.HealthCheckable;
import com.ontotext.trree.sdk.HealthResult;
import com.ontotext.trree.sdk.PluginException;
import com.ontotext.trree.sdk.ServerErrorException;
import dev.langchain4j.data.embedding.Embedding;
import java.io.Closeable;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.CredentialsStore;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.util.Timeout;
import org.eclipse.rdf4j.model.Value;
import org.opensearch.client.RestClient;
import org.opensearch.client.RestClientBuilder;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.jackson.JacksonJsonpMapper;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.FieldSort;
import org.opensearch.client.opensearch._types.Refresh;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationBuilders;
import org.opensearch.client.opensearch._types.mapping.OpensearchUtil;
import org.opensearch.client.opensearch._types.mapping.Property;
import org.opensearch.client.opensearch._types.mapping.TypeMapping;
import org.opensearch.client.opensearch._types.query_dsl.MatchAllQuery;
import org.opensearch.client.opensearch.core.BulkResponse;
import org.opensearch.client.opensearch.core.DeleteByQueryRequest;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.bulk.BulkOperation;
import org.opensearch.client.opensearch.core.bulk.DeleteOperation;
import org.opensearch.client.opensearch.core.search.SourceConfig;
import org.opensearch.client.opensearch.indices.CreateIndexRequest;
import org.opensearch.client.opensearch.indices.DeleteIndexRequest;
import org.opensearch.client.opensearch.indices.ExistsRequest;
import org.opensearch.client.opensearch.indices.GetIndicesSettingsRequest;
import org.opensearch.client.opensearch.indices.GetMappingRequest;
import org.opensearch.client.opensearch.indices.IndexSettings;
import org.opensearch.client.opensearch.indices.IndexState;
import org.opensearch.client.opensearch.indices.PutMappingRequest;
import org.opensearch.client.opensearch.indices.get_mapping.IndexMappingRecord;
import org.opensearch.client.sniff.SniffOnFailureListener;
import org.opensearch.client.sniff.Sniffer;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.client.transport.rest_client.RestClientTransport;
import org.slf4j.Logger;

public class OpensearchDriver
implements HealthCheckable {
    private static final String PROPERTY_NAME_FOR_ALWAYS_REFRESH = "connectors.opensearch.alwaysrefresh";
    private static final String OPENSEARCH_CONNECTION_TIMEOUT_PROPERTY = "opensearch.connection.timeout";
    private static final int OPENSEARCH_CONNECTION_TIMEOUT_DEFAULT = 30000;
    private static final String OPENSEARCH_SO_TIMEOUT_PROPERTY = "opensearch.so.timeout";
    private static final int OPENSEARCH_SO_TIMEOUT_DEFAULT = 120000;
    private static final String SCORE_FIELD_NAME = "_score";
    private static final int MAX_RESULT_WINDOW_DEFAULT = 10000;
    private static final int OPENSEARCH_ID_LENGTH_LIMIT = 512;
    private final Logger logger;
    private final String indexName;
    private RestClient queryClient;
    private Sniffer sniffer;
    private OpenSearchClient client;
    private final boolean manageIndex;
    private VectorBuilder vectorBuilder;
    private int maxResultWindow;
    private long bulkUpdateBatchSize;
    private static final boolean isAlwaysRefreshEnabled;
    private Function<String, Property> propertyResolver;
    private ExternalStore store;
    private GraphDBBulkRequestBuilder bulkRequest;
    static final OpensearchClientSupplier DEFAULT_CLIENT_SUPPLIER;
    private static OpensearchClientSupplier supplier;

    private OpensearchDriver(Logger logger, String indexName, Options options) throws UnknownHostException {
        this.logger = logger;
        this.indexName = indexName;
        this.manageIndex = (Boolean)options.getValue(OpensearchPlugin.MANAGE_INDEX);
        this.applyUpdatableOptions(options);
        this.beginInternal();
    }

    protected void setExternalStore(ExternalStore store) {
        this.store = store;
    }

    protected String getIndexName() {
        return this.indexName;
    }

    public OpensearchResult query(MasterResultIterator mri) {
        SearchOptions searchOptions = mri.getSearchOptions();
        SearchRequest.Builder searchRequest = OpensearchUtil.searchBuilderWithCustomParameters(this.indexName, this.vectorBuilder, mri, this.propertyResolver);
        int numTopDocs = searchOptions.limit;
        if (numTopDocs > 0) {
            searchRequest.size(Integer.valueOf(numTopDocs));
        }
        if (mri.isTrackScore()) {
            searchRequest.trackScores(Boolean.valueOf(true));
        }
        for (SearchOptions.OrderPredicate p : searchOptions.orderBy) {
            SortOrder order;
            if (p.isScoreSpecial()) {
                order = SortOrder.Desc;
                if (p.reverse) {
                    order = SortOrder.Asc;
                }
                searchRequest.sort((SortOptions)new SortOptions.Builder().field(new FieldSort.Builder().field(SCORE_FIELD_NAME).order(order).build()).build(), new SortOptions[0]);
                continue;
            }
            order = SortOrder.Asc;
            if (p.reverse) {
                order = SortOrder.Desc;
            }
            searchRequest.sort((SortOptions)new SortOptions.Builder().field(new FieldSort.Builder().field(p.predicate).order(order).build()).build(), new SortOptions[0]);
        }
        this.addFacets(searchRequest, searchOptions.facets);
        return new OpensearchResult(this.indexName, this.logger, searchOptions.offset, numTopDocs, true, this.client, searchRequest, this.getMaxResultWindow());
    }

    void putMapping(Map<String, Property> mapping) throws IOException {
        if (this.store.isTestingTransaction()) {
            this.client.indices().putMapping(new PutMappingRequest.Builder().properties(mapping).index(this.indexName, new String[0]).build());
        }
    }

    private void addFacets(SearchRequest.Builder searchRequest, List<String> facets) {
        HashMap<String, Aggregation> map = new HashMap<String, Aggregation>();
        for (String facet : facets) {
            map.put(facet, AggregationBuilders.terms().field(facet).build().toAggregation());
        }
        searchRequest.aggregations(map);
    }

    public void createIndex() {
        if (this.manageIndex && this.store.isTestingTransaction()) {
            CreateIndexRequest.Builder createIndexRequest = supplier.newCreateIndexRequest(this.indexName);
            Object settings = this.store.getOptions().getValue(OpensearchPlugin.CREATE_SETTINGS);
            if (settings != null) {
                createIndexRequest.settings(OpensearchUtil.settingsFromJson(settings));
            }
            try {
                this.client.indices().create(createIndexRequest.build());
            }
            catch (IOException e) {
                throw new ConnectorServerException("Cannot create index", (Throwable)e);
            }
        }
    }

    protected TypeMapping getMapping() throws IOException {
        Map mappings = this.client.indices().getMapping(new GetMappingRequest.Builder().index(this.indexName, new String[0]).build()).result();
        if (mappings.size() > 1) {
            throw new ConnectorUserException("Mapping returned more than one record: '" + this.indexName + "' must be an index or a search alias with a single writable index");
        }
        return ((IndexMappingRecord)mappings.values().iterator().next()).mappings();
    }

    protected IndexSettings getIndexSettings() throws IOException {
        Map indexSettings = this.client.indices().getSettings(new GetIndicesSettingsRequest.Builder().index(this.indexName, new String[0]).build()).result();
        if (indexSettings.size() > 1) {
            throw new ConnectorUserException("Settings returned more than one record: '" + this.indexName + "' must be an index or a search alias with a single writable index");
        }
        return ((IndexState)indexSettings.values().iterator().next()).settings();
    }

    protected boolean indexExists() {
        try {
            return this.client.indices().exists(new ExistsRequest.Builder().index(this.indexName, new String[0]).build()).value();
        }
        catch (IOException e) {
            throw new ConnectorServerException("Unable to check if index exists", (Throwable)e);
        }
    }

    private int getMaxResultWindow() {
        if (this.maxResultWindow == 0) {
            try {
                IndexSettings indexSettings = this.getIndexSettings().index();
                this.maxResultWindow = indexSettings.maxResultWindow() != null ? indexSettings.maxResultWindow() : 10000;
            }
            catch (IOException e) {
                throw new ConnectorServerException("Cannot get index settings.", (Throwable)e);
            }
        }
        return this.maxResultWindow;
    }

    private void beginInternal() {
        if (this.bulkRequest == null || this.bulkRequest.numberOfOperations() > 0) {
            this.bulkRequest = new GraphDBBulkRequestBuilder();
            LinkedList documentsForEmbeddings = new LinkedList();
            this.bulkRequest.bulkPreprocessor(documents -> {
                this.logger.info("[{}] Preprocessing {} documents in bulk.", (Object)this.indexName, (Object)this.bulkRequest.numberOfDocsToPreprocess());
                for (Map doc : documents) {
                    for (Map.Entry entry : doc.entrySet()) {
                        if (!this.isAutoComputedKnnVector((String)entry.getKey())) continue;
                        if (this.vectorBuilder == null) {
                            EmbeddingModelUtil.throwNoProvidedEmbeddingModelImplementation();
                        }
                        String string = entry.getValue().toString();
                        documentsForEmbeddings.add(string);
                        entry.setValue(documentsForEmbeddings.size() - 1);
                    }
                }
                if (!documentsForEmbeddings.isEmpty()) {
                    List embeddings = this.vectorBuilder.embeddingsFromTexts(documentsForEmbeddings).stream().map(Embedding::vector).collect(Collectors.toList());
                    for (Map doc : documents) {
                        for (Map.Entry entry : doc.entrySet()) {
                            if (!this.isAutoComputedKnnVector((String)entry.getKey())) continue;
                            int index = (Integer)entry.getValue();
                            entry.setValue(embeddings.get(index));
                        }
                    }
                }
                this.logger.info("Preprocessed {} documents for embeddings.", (Object)documents.size());
                this.logger.info("Calculated {} embeddings for them.", (Object)documentsForEmbeddings.size());
            });
        }
    }

    @VisibleForTesting
    void flushIfNeeded() {
        if ((long)this.bulkRequest.numberOfOperations() >= this.bulkUpdateBatchSize) {
            this.flush();
        }
    }

    private void flush() {
        if (this.bulkRequest.numberOfOperations() > 0) {
            if (this.shouldRefresh()) {
                this.bulkRequest.refresh(Refresh.True);
            }
            this.bulkRequest.preprocessDocumentsInBulk();
            this.logger.info("[{}] Sending {} bulk actions to OpenSearch.", (Object)this.indexName, (Object)this.bulkRequest.numberOfOperations());
            try {
                BulkResponse bulkResponse = this.client.bulk(this.bulkRequest.build());
                if (bulkResponse.errors()) {
                    throw new PluginException(OpensearchUtil.buildFailureMessage(bulkResponse));
                }
            }
            catch (Exception e) {
                if (e instanceof PluginException) {
                    throw (PluginException)e;
                }
                throw new ConnectorServerException("Error on bulk request", (Throwable)e);
            }
            finally {
                this.beginInternal();
            }
        }
    }

    void rollback(Entities entities) {
        TreeSet entitiesToRefresh;
        if (this.store.isTestingTransaction() && (entitiesToRefresh = this.store.getEntitiesToRefresh()) != null) {
            this.beginInternal();
            for (Long subject : entitiesToRefresh) {
                Value value = entities.get(subject.longValue());
                if (value != null) {
                    this.delete(EntitiesUtil.valueToString((Value)value));
                    continue;
                }
                this.logger.warn("[{}] Value not found in entity pool. This is probably a bug.", (Object)this.store.getName());
            }
            this.flush();
        }
    }

    void commit() {
        this.flush();
    }

    static void setSupplier(OpensearchClientSupplier supplier) {
        OpensearchDriver.supplier = supplier;
    }

    private boolean isTestMode() {
        return supplier != DEFAULT_CLIENT_SUPPLIER;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static String canConnectToOpensearch(Options options, Logger logger) {
        try (RestClient tmpClient = supplier.createClient(null, null, options, logger);){
            String string;
            try (RestClientTransport opensearchTransport = new RestClientTransport(tmpClient, (JsonpMapper)new JacksonJsonpMapper());){
                OpenSearchClient pingClient = new OpenSearchClient((OpenSearchTransport)opensearchTransport);
                pingClient.ping();
                string = null;
            }
            return string;
        }
        catch (Exception ex) {
            return ex.getMessage() != null ? ex.getMessage() : ex.getClass().getName();
        }
    }

    public static OpensearchDriver from(Logger logger, String storeName, Options options) {
        try {
            return new OpensearchDriver(logger, storeName, options);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    void delete(String uri) {
        if (this.store.isTestingTransaction()) {
            DeleteOperation delete = ((DeleteOperation.Builder)((DeleteOperation.Builder)new DeleteOperation.Builder().index(this.indexName)).id(uri)).build();
            this.bulkRequest.viewableOperations((BulkOperation)new BulkOperation.Builder().delete(delete).build(), new BulkOperation[0]);
            this.flushIfNeeded();
        }
    }

    void deleteAll() {
        if (this.store.isTestingTransaction()) {
            try {
                DeleteByQueryRequest.Builder request = new DeleteByQueryRequest.Builder().index(this.indexName, new String[0]).query(new MatchAllQuery.Builder().build().toQuery());
                if (this.shouldRefresh()) {
                    request.refresh(Refresh.True);
                }
                this.client.deleteByQuery(request.build());
            }
            catch (IOException e) {
                throw new ServerErrorException("Unable to delete documents from OpenSearch on repository clear", (Throwable)e);
            }
        }
    }

    public void index(Map<String, Object> content, String uri) {
        if (this.store.isTestingTransaction()) {
            if (uri.length() <= 512) {
                this.bulkRequest.viewableOperations((BulkOperation)new BulkOperation.Builder().index(supplier.newIndexOperation(content, uri, this.indexName)).build(), new BulkOperation[0]);
                if (this.documentHasVectorFields(content)) {
                    this.bulkRequest.preprocessDocument(content);
                }
                this.flushIfNeeded();
            } else {
                this.logger.warn("[{}] Skipping document with id longer than {} characters (OpenSearch limitation): {}", new Object[]{this.indexName, 512, uri});
            }
        }
    }

    private boolean shouldRefresh() {
        return this.isTestMode() || isAlwaysRefreshEnabled;
    }

    public void dropIndex() {
        if (this.manageIndex && this.store.isTestingTransaction()) {
            try {
                this.client.indices().delete(new DeleteIndexRequest.Builder().index(this.indexName, new String[0]).build());
            }
            catch (IOException e) {
                throw new ConnectorServerException("Error dropping index", (Throwable)e);
            }
        }
    }

    void close() throws IOException {
        try {
            if (this.sniffer != null) {
                this.sniffer.close();
            }
        }
        catch (Exception e) {
            this.logger.warn("Error closing sniffer (ignored)", (Throwable)e);
        }
        this.queryClient.close();
        if (this.vectorBuilder != null && this.vectorBuilder.getEmbeddingModel() instanceof Closeable) {
            try {
                ((Closeable)this.vectorBuilder.getEmbeddingModel()).close();
            }
            catch (Exception e) {
                this.logger.warn("Error closing embedding model (ignored)", (Throwable)e);
            }
        }
    }

    public HealthResult runHealthCheck() {
        try {
            SearchRequest searchRequest = new SearchRequest.Builder().index(this.indexName, new String[0]).source((SourceConfig)new SourceConfig.Builder().fetch(Boolean.valueOf(false)).build()).size(Integer.valueOf(1)).build();
            SearchResponse searchResponse = this.client.search(searchRequest, Object.class);
            String message = String.format("query took %d ms, %d hits, %d failed shards", searchResponse.took(), searchResponse.hits().total() != null ? searchResponse.hits().total().value() : 0L, searchResponse.shards().failed());
            if (searchResponse.shards().failed() > 0 || searchResponse.hits().total() == null || searchResponse.hits().total().value() == 0L) {
                return new HealthResult(this.indexName, HealthResult.Status.YELLOW, message);
            }
            return new HealthResult(this.indexName, HealthResult.Status.GREEN, message);
        }
        catch (Exception e) {
            return new HealthResult(this.indexName, HealthResult.Status.RED, "query cannot be run: " + e.getMessage());
        }
    }

    void applyUpdatableOptions(Options options) throws UnknownHostException {
        boolean clusterSniff = (Boolean)options.getValue(OpensearchPlugin.OPENSEARCH_CLUSTER_SNIFF);
        SniffOnFailureListener snifferListener = null;
        if (clusterSniff) {
            snifferListener = new SniffOnFailureListener();
        }
        RestClient newQueryClient = supplier.createClient(this, snifferListener, options, this.logger);
        Sniffer newSniffer = null;
        if (clusterSniff) {
            newSniffer = supplier.createSniffer(newQueryClient, supplier.getDefaultScheme(options));
            snifferListener.setSniffer(newSniffer);
        }
        RestClient oldQueryClient = this.queryClient;
        Sniffer oldSniffer = this.sniffer;
        this.queryClient = newQueryClient;
        this.sniffer = newSniffer;
        this.client = new OpenSearchClient((OpenSearchTransport)new RestClientTransport(this.queryClient, (JsonpMapper)new JacksonJsonpMapper()));
        this.bulkUpdateBatchSize = (Long)options.getValue(OpensearchPlugin.BULK_UPDATE_BATCH_SIZE);
        VectorBuilder oldVectorBuilder = this.vectorBuilder;
        String embeddingModel = (String)options.getValue(OpensearchPlugin.EMBEDDING_MODEL);
        VectorBuilder vectorBuilder = this.vectorBuilder = embeddingModel != null && !embeddingModel.isEmpty() ? new VectorBuilder(EmbeddingModelUtil.createInstance((String)embeddingModel)) : null;
        if (oldSniffer != null) {
            oldSniffer.close();
        }
        if (oldQueryClient != null) {
            try {
                oldQueryClient.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (oldVectorBuilder != null && oldVectorBuilder.getEmbeddingModel() instanceof Closeable) {
            try {
                ((Closeable)oldVectorBuilder.getEmbeddingModel()).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean documentHasVectorFields(Map<String, Object> content) {
        for (String key : content.keySet()) {
            if (!this.isAutoComputedKnnVector(key)) continue;
            return true;
        }
        return false;
    }

    private boolean isAutoComputedKnnVector(String propertyName) {
        if (this.propertyResolver != null) {
            Property property = this.propertyResolver.apply(propertyName);
            return property != null && property._kind() == Property.Kind.KnnVector && StringUtils.isEmpty((String)property.knnVector().modelId()) && StringUtils.isEmpty((String)property.knnVector().spaceType());
        }
        return false;
    }

    public void setPropertyResolver(Function<String, Property> propertyResolver) {
        this.propertyResolver = propertyResolver;
    }

    public VectorBuilder getVectorBuilder() {
        return this.vectorBuilder;
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$static$3(CredentialsStore credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        httpClientBuilder.disableAuthCaching();
        return httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
    }

    static {
        String property = System.getProperty(PROPERTY_NAME_FOR_ALWAYS_REFRESH);
        isAlwaysRefreshEnabled = Boolean.parseBoolean(property);
        supplier = DEFAULT_CLIENT_SUPPLIER = (driver, sniffer, options, logger) -> {
            String nodes = (String)options.getValue(OpensearchPlugin.OPENSEARCH_NODE);
            assert (nodes != null);
            String[] nodesSplit = nodes.split("[,;\\s]+");
            HttpHost[] serverAddresses = new HttpHost[nodesSplit.length];
            for (int i = 0; i < nodesSplit.length; ++i) {
                try {
                    serverAddresses[i] = HttpHost.create((String)nodesSplit[i]);
                    continue;
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            if (serverAddresses.length == 0) {
                throw new ConnectorUserException("At least one OpenSearch node must be provided.");
            }
            RestClientBuilder builder = RestClient.builder((HttpHost[])serverAddresses);
            String username = null;
            String password = null;
            Object authenticationProvider = OptionsUtil.instantiateClassFromOption((Options)options, OpensearchPlugin.AUTHENTICATION_CONFIGURATOR_CLASS);
            RestClientBuilder.HttpClientConfigCallback httpClientConfigCallback = httpClientBuilder -> httpClientBuilder;
            if (authenticationProvider != null) {
                String storeName = options.getStoreName();
                if (authenticationProvider instanceof HttpClient5Configurator) {
                    httpClientConfigCallback = httpAsyncClientBuilder -> {
                        CredentialsProvider credentialsProvider;
                        HttpClient5Configurator httpClientConfigurator = (HttpClient5Configurator)authenticationProvider;
                        HttpRequestInterceptor authInterceptor = httpClientConfigurator.getHttpRequestInterceptor(nodes, storeName);
                        if (authInterceptor != null) {
                            httpAsyncClientBuilder.addRequestInterceptorLast(authInterceptor);
                        }
                        if ((credentialsProvider = httpClientConfigurator.getCredentialsProvider(nodes, storeName)) != null) {
                            httpAsyncClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
                        }
                        if (httpClientConfigurator.shouldDisableAuthCaching(nodes, storeName)) {
                            httpAsyncClientBuilder.disableAuthCaching();
                        }
                        return httpAsyncClientBuilder;
                    };
                } else {
                    if (!(authenticationProvider instanceof UsernamePasswordProvider)) throw new ConnectorUserException("Provided authentication class " + authenticationProvider.getClass().getName() + " does not implement any of the supported interfaces");
                    UsernamePasswordProvider.Credentials credentials = ((UsernamePasswordProvider)authenticationProvider).getCredentials(nodes, storeName);
                    if (credentials != null) {
                        username = credentials.getUsername();
                        password = credentials.getPassword();
                    }
                }
            } else {
                username = (String)options.getValue(OpensearchPlugin.BASIC_AUTH_USER);
                password = (String)options.getValue(OpensearchPlugin.BASIC_AUTH_PASSWORD);
            }
            if (StringUtils.isNotBlank((String)username) && StringUtils.isNotBlank((String)password)) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                AuthScope authScope = new AuthScope(null, null, -1, null, null);
                credentialsProvider.setCredentials(authScope, (Credentials)new UsernamePasswordCredentials(username, password.toCharArray()));
                httpClientConfigCallback = arg_0 -> OpensearchDriver.lambda$static$3((CredentialsStore)credentialsProvider, arg_0);
            }
            builder.setHttpClientConfigCallback(httpClientConfigCallback);
            builder.setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setConnectionRequestTimeout(Timeout.of((long)Config.getPropertyAsInt((String)OPENSEARCH_CONNECTION_TIMEOUT_PROPERTY, (int)30000), (TimeUnit)TimeUnit.MILLISECONDS)).setResponseTimeout(Timeout.of((long)Config.getPropertyAsInt((String)OPENSEARCH_SO_TIMEOUT_PROPERTY, (int)120000), (TimeUnit)TimeUnit.MILLISECONDS)));
            if (sniffer == null) return builder.build();
            builder.setFailureListener((RestClient.FailureListener)sniffer);
            return builder.build();
        };
    }
}

