/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.opensearch;

import com.ontotext.trree.plugin.externalsync.config.Options;
import com.ontotext.trree.plugin.externalsync.impl.opensearch.OpensearchDriver;
import com.ontotext.trree.plugin.externalsync.impl.opensearch.OpensearchPlugin;
import java.net.UnknownHostException;
import java.util.Map;
import javax.annotation.Nullable;
import org.opensearch.client.RestClient;
import org.opensearch.client.opensearch.core.bulk.IndexOperation;
import org.opensearch.client.opensearch.indices.CreateIndexRequest;
import org.opensearch.client.sniff.NodesSniffer;
import org.opensearch.client.sniff.OpenSearchNodesSniffer;
import org.opensearch.client.sniff.SniffOnFailureListener;
import org.opensearch.client.sniff.Sniffer;
import org.slf4j.Logger;

public interface OpensearchClientSupplier {
    public RestClient createClient(@Nullable OpensearchDriver var1, @Nullable SniffOnFailureListener var2, Options var3, Logger var4) throws UnknownHostException;

    default public Sniffer createSniffer(RestClient restClient, OpenSearchNodesSniffer.Scheme firstHostScheme) {
        return Sniffer.builder((RestClient)restClient).setNodesSniffer((NodesSniffer)new OpenSearchNodesSniffer(restClient, OpenSearchNodesSniffer.DEFAULT_SNIFF_REQUEST_TIMEOUT, firstHostScheme)).build();
    }

    default public OpenSearchNodesSniffer.Scheme getDefaultScheme(Options options) {
        String nodes = (String)options.getValue(OpensearchPlugin.OPENSEARCH_NODE);
        String[] nodesSplit = nodes.split("[,;\\s]+");
        if (nodesSplit[0].toLowerCase().startsWith("https:")) {
            return OpenSearchNodesSniffer.Scheme.HTTPS;
        }
        return OpenSearchNodesSniffer.Scheme.HTTP;
    }

    default public CreateIndexRequest.Builder newCreateIndexRequest(String indexName) {
        return new CreateIndexRequest.Builder().index(indexName);
    }

    default public IndexOperation<?> newIndexOperation(Map<String, Object> content, String uri, String indexName) {
        return ((IndexOperation.Builder)((IndexOperation.Builder)new IndexOperation.Builder().index(indexName)).document(content).id(uri)).build();
    }
}

