/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.answering.reformulation.generation.impl;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.answering.reformulation.generation.NativeQueryGenerator;
import it.unibz.inf.ontop.answering.reformulation.generation.PostProcessingProjectionSplitter;
import it.unibz.inf.ontop.datalog.UnionFlattener;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.generation.normalization.DialectExtraNormalizer;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.OntopReformulationSQLSettings;
import it.unibz.inf.ontop.injection.OptimizerFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.DistinctNode;
import it.unibz.inf.ontop.iq.node.NativeNode;
import it.unibz.inf.ontop.iq.node.OrderByNode;
import it.unibz.inf.ontop.iq.node.SliceNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.optimizer.PostProcessableFunctionLifter;
import it.unibz.inf.ontop.iq.optimizer.TermTypeTermLifter;
import it.unibz.inf.ontop.iq.optimizer.splitter.ProjectionSplitter;
import it.unibz.inf.ontop.iq.transform.IQTree2NativeNodeGenerator;
import it.unibz.inf.ontop.iq.transformer.BooleanExpressionPushDownTransformer;
import it.unibz.inf.ontop.iq.transformer.EmptyRowsValuesNodeTransformer;
import it.unibz.inf.ontop.utils.VariableGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLGeneratorImpl
implements NativeQueryGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLGeneratorImpl.class);
    private final DBParameters dbParameters;
    private final IntermediateQueryFactory iqFactory;
    private final UnionFlattener unionFlattener;
    private final OptimizerFactory optimizerFactory;
    private final PostProcessingProjectionSplitter projectionSplitter;
    private final TermTypeTermLifter rdfTypeLifter;
    private final PostProcessableFunctionLifter functionLifter;
    private final IQTree2NativeNodeGenerator defaultIQTree2NativeNodeGenerator;
    private final OntopReformulationSQLSettings settings;
    private final DialectExtraNormalizer extraNormalizer;
    private final BooleanExpressionPushDownTransformer pushDownTransformer;
    private final EmptyRowsValuesNodeTransformer valuesNodeTransformer;

    @AssistedInject
    private SQLGeneratorImpl(@Assisted DBParameters dbParameters, IntermediateQueryFactory iqFactory, UnionFlattener unionFlattener, OptimizerFactory optimizerFactory, PostProcessingProjectionSplitter projectionSplitter, TermTypeTermLifter rdfTypeLifter, PostProcessableFunctionLifter functionLifter, IQTree2NativeNodeGenerator defaultIQTree2NativeNodeGenerator, DialectExtraNormalizer extraNormalizer, BooleanExpressionPushDownTransformer pushDownTransformer, EmptyRowsValuesNodeTransformer valuesNodeTransformer, OntopReformulationSQLSettings settings) {
        this.functionLifter = functionLifter;
        this.extraNormalizer = extraNormalizer;
        this.pushDownTransformer = pushDownTransformer;
        this.valuesNodeTransformer = valuesNodeTransformer;
        this.dbParameters = dbParameters;
        this.iqFactory = iqFactory;
        this.unionFlattener = unionFlattener;
        this.optimizerFactory = optimizerFactory;
        this.projectionSplitter = projectionSplitter;
        this.rdfTypeLifter = rdfTypeLifter;
        this.defaultIQTree2NativeNodeGenerator = defaultIQTree2NativeNodeGenerator;
        this.settings = settings;
    }

    public IQ generateSourceQuery(IQ query) {
        return this.generateSourceQuery(query, this.settings.isPostProcessingAvoided());
    }

    public IQ generateSourceQuery(IQ query, boolean avoidPostProcessing) {
        return this.generateSourceQuery(query, avoidPostProcessing, false);
    }

    public IQ generateSourceQuery(IQ query, boolean avoidPostProcessing, boolean tolerateUnknownTypes) {
        if (query.getTree().isDeclaredAsEmpty()) {
            return query;
        }
        IQ rdfTypeLiftedIQ = this.rdfTypeLifter.optimize(query);
        LOGGER.debug("After lifting the RDF types:\n{}\n", (Object)rdfTypeLiftedIQ);
        IQ liftedIQ = this.functionLifter.optimize(rdfTypeLiftedIQ);
        LOGGER.debug("After lifting the post-processable function symbols:\n{}\n", (Object)liftedIQ);
        ProjectionSplitter.ProjectionSplit split = this.projectionSplitter.split(liftedIQ, avoidPostProcessing);
        IQTree normalizedSubTree = this.normalizeSubTree(split.getSubTree(), split.getVariableGenerator());
        if (normalizedSubTree.isDeclaredAsEmpty()) {
            return this.iqFactory.createIQ(query.getProjectionAtom(), (IQTree)this.iqFactory.createEmptyNode(query.getProjectionAtom().getVariables()));
        }
        NativeNode nativeNode = this.generateNativeNode(normalizedSubTree, tolerateUnknownTypes);
        UnaryIQTree newTree = this.iqFactory.createUnaryIQTree((UnaryOperatorNode)split.getConstructionNode(), (IQTree)nativeNode);
        return this.iqFactory.createIQ(query.getProjectionAtom(), (IQTree)newTree);
    }

    private IQTree normalizeSubTree(IQTree subTree, VariableGenerator variableGenerator) {
        IQTree sliceLiftedTree = this.liftSlice(subTree);
        LOGGER.debug("New query after lifting the slice:\n{}\n", (Object)sliceLiftedTree);
        IQTree flattenSubTree = this.unionFlattener.optimize(sliceLiftedTree, variableGenerator);
        LOGGER.debug("New query after flattening the union:\n{}\n", (Object)flattenSubTree);
        IQTree pushedDownSubTree = this.pushDownTransformer.transform(flattenSubTree);
        LOGGER.debug("New query after pushing down:\n{}\n", (Object)pushedDownSubTree);
        IQTree treeAfterPullOut = this.optimizerFactory.createEETransformer(variableGenerator).transform(pushedDownSubTree);
        LOGGER.debug("Query tree after pulling out equalities:\n{}\n", (Object)treeAfterPullOut);
        IQTree treeAfterTopConstructionNormalization = this.dropTopConstruct(treeAfterPullOut);
        LOGGER.debug("New query after top construction elimination in order by cases: \n" + treeAfterTopConstructionNormalization);
        IQTree treeAfterEmptyRowsValuesNodeNormalization = this.valuesNodeTransformer.transform(treeAfterTopConstructionNormalization, (Object)variableGenerator);
        LOGGER.debug("New query after empty rows values node transformation:\n{}\n", (Object)treeAfterEmptyRowsValuesNodeNormalization);
        IQTree afterDialectNormalization = this.extraNormalizer.transform(treeAfterEmptyRowsValuesNodeNormalization, variableGenerator);
        LOGGER.debug("New query after the dialect-specific extra normalization:\n{}\n", (Object)afterDialectNormalization);
        return afterDialectNormalization;
    }

    private IQTree liftSlice(IQTree subTree) {
        if (subTree.getRootNode() instanceof ConstructionNode) {
            ConstructionNode constructionNode = (ConstructionNode)subTree.getRootNode();
            IQTree childTree = ((UnaryIQTree)subTree).getChild();
            if (childTree.getRootNode() instanceof SliceNode) {
                SliceNode sliceNode = (SliceNode)childTree.getRootNode();
                IQTree grandChildTree = ((UnaryIQTree)childTree).getChild();
                return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)sliceNode, (IQTree)this.iqFactory.createUnaryIQTree((UnaryOperatorNode)constructionNode, grandChildTree));
            }
        }
        return subTree;
    }

    private IQTree dropTopConstruct(IQTree subTree) {
        if (subTree.getRootNode() instanceof SliceNode) {
            SliceNode sliceNode = (SliceNode)subTree.getRootNode();
            return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)sliceNode, this.dropTopConstruct(((UnaryIQTree)subTree).getChild()));
        }
        if (subTree.getRootNode() instanceof ConstructionNode) {
            IQTree grandGrandChildTree;
            IQTree grandChildTree;
            ConstructionNode constructionNode = (ConstructionNode)subTree.getRootNode();
            IQTree childTree = ((UnaryIQTree)subTree).getChild();
            if (childTree.getRootNode() instanceof DistinctNode && constructionNode.getSubstitution().isEmpty() && ((grandChildTree = ((UnaryIQTree)childTree).getChild()).getRootNode() instanceof ConstructionNode ? (grandGrandChildTree = ((UnaryIQTree)grandChildTree).getChild()).getRootNode() instanceof OrderByNode : grandChildTree.getRootNode() instanceof OrderByNode)) {
                return childTree;
            }
        }
        return subTree;
    }

    private NativeNode generateNativeNode(IQTree normalizedSubTree, boolean tolerateUnknownTypes) {
        return this.defaultIQTree2NativeNodeGenerator.generate(normalizedSubTree, this.dbParameters, tolerateUnknownTypes);
    }
}

