/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.ogc.gml.v_3_1_1.jts;

import net.opengis.gml.v_3_1_1.DirectPositionType;
import org.jvnet.ogc.gml.v_3_1_1.ObjectFactoryInterface;
import org.jvnet.ogc.gml.v_3_1_1.jts.JTSToGML311SRSReferenceGroupConverterInterface;
import org.locationtech.jts.geom.Coordinate;

public class JTSToGML311CoordinateConverter {
    private final ObjectFactoryInterface objectFactory;
    private final JTSToGML311SRSReferenceGroupConverterInterface srsReferenceGroupConverter;

    public JTSToGML311CoordinateConverter(ObjectFactoryInterface objectFactoryInterface, JTSToGML311SRSReferenceGroupConverterInterface jTSToGML311SRSReferenceGroupConverterInterface) {
        this.objectFactory = objectFactoryInterface;
        this.srsReferenceGroupConverter = jTSToGML311SRSReferenceGroupConverterInterface;
    }

    public DirectPositionType convertCoordinate(Coordinate coordinate) {
        DirectPositionType directPositionType = this.objectFactory.createDirectPositionType();
        directPositionType.getValue().add(coordinate.x);
        directPositionType.getValue().add(coordinate.y);
        if (!Double.isNaN(coordinate.z)) {
            directPositionType.getValue().add(coordinate.z);
        }
        return directPositionType;
    }

    public DirectPositionType[] convertCoordinates(Coordinate[] coordinateArray) {
        if (coordinateArray == null) {
            return null;
        }
        DirectPositionType[] directPositionTypeArray = new DirectPositionType[coordinateArray.length];
        for (int i = 0; i < coordinateArray.length; ++i) {
            directPositionTypeArray[i] = this.convertCoordinate(coordinateArray[i]);
        }
        return directPositionTypeArray;
    }
}

