/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.ogc.gml.v_3_1_1.jts;

import jakarta.xml.bind.JAXBElement;
import java.util.ArrayList;
import net.opengis.gml.v_3_1_1.AbstractRingPropertyType;
import net.opengis.gml.v_3_1_1.AbstractRingType;
import net.opengis.gml.v_3_1_1.LinearRingPropertyType;
import net.opengis.gml.v_3_1_1.LinearRingType;
import net.opengis.gml.v_3_1_1.PolygonPropertyType;
import net.opengis.gml.v_3_1_1.PolygonType;
import org.jvnet.jaxb.locator.ItemObjectLocator;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.PropertyObjectLocator;
import org.jvnet.ogc.gml.v_3_1_1.jts.AbstractGML311ToJTSConverter;
import org.jvnet.ogc.gml.v_3_1_1.jts.ConversionFailedException;
import org.jvnet.ogc.gml.v_3_1_1.jts.GML311ToJTSConverterInterface;
import org.jvnet.ogc.gml.v_3_1_1.jts.GML311ToJTSSRIDConverterInterface;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;

public class GML311ToJTSPolygonConverter
extends AbstractGML311ToJTSConverter<PolygonType, PolygonPropertyType, Polygon> {
    private final GML311ToJTSConverterInterface<LinearRingType, LinearRingPropertyType, LinearRing> linearRingConverter;

    public GML311ToJTSPolygonConverter(GeometryFactory geometryFactory, GML311ToJTSSRIDConverterInterface gML311ToJTSSRIDConverterInterface, GML311ToJTSConverterInterface<LinearRingType, LinearRingPropertyType, LinearRing> gML311ToJTSConverterInterface) {
        super(geometryFactory, gML311ToJTSSRIDConverterInterface);
        this.linearRingConverter = gML311ToJTSConverterInterface;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Polygon doCreateGeometry(ObjectLocator objectLocator, PolygonType polygonType) throws ConversionFailedException {
        LinearRing linearRing;
        LinearRing[] linearRingArray;
        if (polygonType.isSetExterior()) {
            linearRingArray = (LinearRing[])((AbstractRingPropertyType)polygonType.getExterior().getValue()).getRing().getValue();
            if (!(linearRingArray instanceof LinearRingType)) throw new ConversionFailedException((ObjectLocator)objectLocator.property("exterior", (Object)polygonType.getExterior()).property("value", polygonType.getExterior().getValue()).property("ring", (Object)((AbstractRingPropertyType)polygonType.getExterior().getValue()).getRing()), "Only linear rings are supported.");
            linearRing = this.linearRingConverter.createGeometry((ObjectLocator)objectLocator.property("exterior", (Object)polygonType.getExterior()).property("value", polygonType.getExterior().getValue()).property("ring", (Object)((AbstractRingPropertyType)polygonType.getExterior().getValue()).getRing()).property("value", (Object)linearRingArray), (LinearRingPropertyType)((LinearRingType)linearRingArray));
        } else {
            linearRing = null;
        }
        if (polygonType.isSetInterior()) {
            PropertyObjectLocator propertyObjectLocator = objectLocator.property("interior", (Object)polygonType.getInterior());
            ArrayList<LinearRing> arrayList = new ArrayList<LinearRing>(polygonType.getInterior().size());
            for (int i = 0; i < polygonType.getInterior().size(); ++i) {
                JAXBElement jAXBElement = (JAXBElement)polygonType.getInterior().get(i);
                ItemObjectLocator itemObjectLocator = propertyObjectLocator.item(i, (Object)jAXBElement);
                AbstractRingType abstractRingType = (AbstractRingType)((AbstractRingPropertyType)jAXBElement.getValue()).getRing().getValue();
                if (!(abstractRingType instanceof LinearRingType)) {
                    throw new ConversionFailedException((ObjectLocator)itemObjectLocator, "Only linear rings are supported.");
                }
                arrayList.add(this.linearRingConverter.createGeometry((ObjectLocator)itemObjectLocator.property("value", jAXBElement.getValue()).property("ring", (Object)((AbstractRingPropertyType)jAXBElement.getValue()).getRing()).property("value", ((AbstractRingPropertyType)jAXBElement.getValue()).getRing().getValue()), (LinearRingPropertyType)((LinearRingType)abstractRingType)));
            }
            linearRingArray = arrayList.toArray(new LinearRing[0]);
            return this.getGeometryFactory().createPolygon(linearRing, linearRingArray);
        } else {
            linearRingArray = null;
        }
        return this.getGeometryFactory().createPolygon(linearRing, linearRingArray);
    }

    @Override
    public Polygon createGeometry(ObjectLocator objectLocator, PolygonPropertyType polygonPropertyType) throws ConversionFailedException {
        if (polygonPropertyType.isSetPolygon()) {
            return (Polygon)this.createGeometry((ObjectLocator)objectLocator.property("polygon", (Object)polygonPropertyType.getPolygon()), polygonPropertyType.getPolygon());
        }
        throw new ConversionFailedException(objectLocator, "Expected [Polygon] element.");
    }
}

