/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.stats.admin;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.ontotext.forest.stats.admin.PropertyWithSource;
import com.ontotext.graphdb.security.ProtectedPropertiesUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY)
public class InfoBean {
    private String localIP;
    private List<String> jvmArguments;
    private Collection<PropertyWithSource> properties;

    InfoBean() {
    }

    public InfoBean(String localIP, List<String> jvmArguments, Collection<PropertyWithSource> properties) {
        this.localIP = localIP;
        this.jvmArguments = jvmArguments;
        this.properties = properties;
    }

    public String getLocalIP() {
        return this.localIP;
    }

    public List<String> getJvmArguments() {
        if (CollectionUtils.isEmpty(this.jvmArguments)) {
            return Collections.emptyList();
        }
        return this.jvmArguments.stream().map(ProtectedPropertiesUtil::obfuscateJVMValueIfNeeded).collect(Collectors.toList());
    }

    public String getJavaVersion() {
        return System.getProperty("java.vendor") + " " + System.getProperty("java.version");
    }

    public String getOsVersion() {
        return System.getProperty("os.name") + " " + System.getProperty("os.version");
    }

    public String getApplicationDir() {
        return new File("").toURI().toString();
    }

    public String getMaxMemory() {
        return String.valueOf(Runtime.getRuntime().maxMemory() / 0x100000L) + " MB";
    }

    public String getUsedMemory() {
        return String.valueOf((Runtime.getRuntime().maxMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L) + " MB";
    }

    public Collection<PropertyWithSource> getProperties() {
        return this.properties;
    }
}

