/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.externalsync;

import com.ontotext.forest.core.error.GraphDBWorkbenchException;
import com.ontotext.forest.externalsync.ConnectorsManager;
import io.swagger.v3.oas.annotations.Hidden;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.algebra.InsertData;
import org.eclipse.rdf4j.query.algebra.UpdateExpr;
import org.eclipse.rdf4j.query.parser.ParsedUpdate;
import org.eclipse.rdf4j.query.parser.QueryParserUtil;
import org.eclipse.rdf4j.query.parser.sparql.SPARQLUpdateDataBlockParser;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFHandler;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/rest/connectors"})
public class ConnectorsController {
    private static final String LUCENE_CREATE = "http://www.ontotext.com/connectors/lucene#createConnector";
    private static final String LUCENE_REPAIR = "http://www.ontotext.com/connectors/lucene#repairConnector";
    private static final String LUCENE_DROP = "http://www.ontotext.com/connectors/lucene#dropConnector";
    private static final String SOLR_CREATE = "http://www.ontotext.com/connectors/solr#createConnector";
    private static final String SOLR_REPAIR = "http://www.ontotext.com/connectors/solr#repairConnector";
    private static final String SOLR_DROP = "http://www.ontotext.com/connectors/solr#dropConnector";
    private static final String ELASTIC_CREATE = "http://www.ontotext.com/connectors/elasticsearch#createConnector";
    private static final String ELASTIC_REPAIR = "http://www.ontotext.com/connectors/elasticsearch#repairConnector";
    private static final String ELASTIC_DROP = "http://www.ontotext.com/connectors/elasticsearch#dropConnector";
    private static final String OPENSEARCH_CREATE = "http://www.ontotext.com/connectors/opensearch#createConnector";
    private static final String OPENSEARCH_REPAIR = "http://www.ontotext.com/connectors/opensearch#repairConnector";
    private static final String OPENSEARCH_DROP = "http://www.ontotext.com/connectors/opensearch#dropConnector";
    private static final String KAFKA_CREATE = "http://www.ontotext.com/connectors/kafka#createConnector";
    private static final String KAFKA_REPAIR = "http://www.ontotext.com/connectors/kafka#repairConnector";
    private static final String KAFKA_DROP = "http://www.ontotext.com/connectors/kafka#dropConnector";
    private static final String GPT_RETRIEVAL_CREATE = "http://www.ontotext.com/connectors/retrieval#createConnector";
    private static final String GPT_RETRIEVAL_REPAIR = "http://www.ontotext.com/connectors/retrieval#repairConnector";
    private static final String GPT_RETRIEVAL_DROP = "http://www.ontotext.com/connectors/retrieval#dropConnector";
    private static final String ENTITY_CHANGE_CREATE = "http://www.ontotext.com/connectors/entity-change#createConnector";
    private static final String ENTITY_CHANGE_REPAIR = "http://www.ontotext.com/connectors/entity-change#repairConnector";
    private static final String ENTITY_CHANGE_DROP = "http://www.ontotext.com/connectors/entity-change#dropConnector";
    @Autowired
    private ConnectorsManager connectorsManager;

    @RequestMapping(method={RequestMethod.GET})
    public ResponseEntity<Map<String, String>> getConnectors() throws GraphDBWorkbenchException {
        return new ResponseEntity(this.connectorsManager.getConnectorTypeAndPrefix(), (HttpStatusCode)HttpStatus.OK);
    }

    @Hidden
    @RequestMapping(value={"/options"}, method={RequestMethod.GET})
    @ResponseBody
    public JSONArray getConnectorsOption() throws GraphDBWorkbenchException {
        JSONArray jsonArray = new JSONArray();
        Map<String, String> connectorTypes = this.connectorsManager.getConnectorTypeAndPrefix();
        for (Map.Entry<String, String> entry : connectorTypes.entrySet()) {
            JSONObject o = new JSONObject();
            o.put((Object)"key", (Object)entry.getKey());
            String prefix = entry.getValue();
            o.put((Object)"prefix", (Object)prefix);
            o.put((Object)"options", this.connectorsManager.getConnectorFields(prefix));
            jsonArray.add((Object)o);
        }
        return jsonArray;
    }

    @Hidden
    @RequestMapping(value={"/options"}, method={RequestMethod.GET}, params={"prefix"})
    @ResponseBody
    public List<JSONObject> getConnectorsOption(@RequestParam(value="prefix") String prefix) throws GraphDBWorkbenchException {
        return this.connectorsManager.getConnectorFields(prefix);
    }

    @Hidden
    @RequestMapping(value={"existing"}, method={RequestMethod.GET})
    @ResponseBody
    public List<JSONObject> getExistingConnectors(@RequestParam(value="prefix") String prefix) throws GraphDBWorkbenchException {
        List<String> connectorNames = this.connectorsManager.getConnectorsNames(prefix);
        LinkedList<JSONObject> connectorsWithOptions = new LinkedList<JSONObject>();
        for (String name : connectorNames) {
            JSONObject connector = new JSONObject();
            connector.put((Object)"name", (Object)name);
            connector.put((Object)"values", (Object)this.connectorsManager.getConnectorFieldValues(prefix, name));
            connectorsWithOptions.add(connector);
        }
        return connectorsWithOptions;
    }

    @Hidden
    @RequestMapping(value={"check"}, method={RequestMethod.POST})
    public ResponseEntity<Map<String, Object>> checkConnectorQuery(@RequestBody String update) {
        HashMap<String, String> result;
        block5: {
            result = new HashMap<String, String>();
            if (update != null) {
                try {
                    UpdateExpr updateExpr;
                    ParsedUpdate parsedUpdate = QueryParserUtil.parseUpdate((QueryLanguage)QueryLanguage.SPARQL, (String)update, (String)"urn:base");
                    List updateExprs = parsedUpdate.getUpdateExprs();
                    if (updateExprs.size() != 1 || !((updateExpr = (UpdateExpr)updateExprs.get(0)) instanceof InsertData)) break block5;
                    InsertData insertDataExpr = (InsertData)updateExpr;
                    SPARQLUpdateDataBlockParser parser = new SPARQLUpdateDataBlockParser((ValueFactory)SimpleValueFactory.getInstance());
                    AbstractRDFHandler handler = new AbstractRDFHandler(){
                        private boolean seenOne;

                        public void handleStatement(Statement st) throws RDFHandlerException {
                            if (this.seenOne) {
                                throw new RuntimeException("No need to check the remaining statements.");
                            }
                            this.seenOne = true;
                            if (result.isEmpty()) {
                                String p = st.getPredicate().stringValue();
                                if (ConnectorsController.LUCENE_CREATE.equals(p) || ConnectorsController.SOLR_CREATE.equals(p) || ConnectorsController.ELASTIC_CREATE.equals(p) || ConnectorsController.OPENSEARCH_CREATE.equals(p) || ConnectorsController.KAFKA_CREATE.equals(p) || ConnectorsController.GPT_RETRIEVAL_CREATE.equals(p) || ConnectorsController.ENTITY_CHANGE_CREATE.equals(p)) {
                                    result.put("command", "create");
                                    result.put("iri", st.getSubject().stringValue());
                                    result.put("name", ((IRI)st.getSubject()).getLocalName());
                                } else if (ConnectorsController.LUCENE_REPAIR.equals(p) || ConnectorsController.SOLR_REPAIR.equals(p) || ConnectorsController.ELASTIC_REPAIR.equals(p) || ConnectorsController.OPENSEARCH_REPAIR.equals(p) || ConnectorsController.KAFKA_REPAIR.equals(p) || ConnectorsController.GPT_RETRIEVAL_REPAIR.equals(p) || ConnectorsController.ENTITY_CHANGE_REPAIR.equals(p)) {
                                    result.put("command", "repair");
                                    result.put("iri", st.getSubject().stringValue());
                                    result.put("name", ((IRI)st.getSubject()).getLocalName());
                                } else if (ConnectorsController.LUCENE_DROP.equals(p) || ConnectorsController.SOLR_DROP.equals(p) || ConnectorsController.ELASTIC_DROP.equals(p) || ConnectorsController.OPENSEARCH_DROP.equals(p) || ConnectorsController.KAFKA_DROP.equals(p) || ConnectorsController.GPT_RETRIEVAL_DROP.equals(p) || ConnectorsController.ENTITY_CHANGE_DROP.equals(p)) {
                                    result.put("command", "drop");
                                    result.put("iri", st.getSubject().stringValue());
                                    result.put("name", ((IRI)st.getSubject()).getLocalName());
                                }
                                result.putAll(ConnectorsController.this.connectorsManager.getConnectorSupport(st.getPredicate().getNamespace()));
                            }
                        }
                    };
                    parser.setRDFHandler((RDFHandler)handler);
                    parser.setLineNumberOffset(insertDataExpr.getLineNumberOffset());
                    parser.getParserConfig().addNonFatalError((RioSetting)BasicParserSettings.VERIFY_DATATYPE_VALUES);
                    parser.getParserConfig().addNonFatalError((RioSetting)BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES);
                    try {
                        parser.parse((Reader)new StringReader(insertDataExpr.getDataBlock()), "");
                    }
                    catch (Exception e) {
                        result.put("error", e.getMessage());
                        return ResponseEntity.status((HttpStatusCode)HttpStatus.PAYMENT_REQUIRED).body(result);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return new ResponseEntity(result, (HttpStatusCode)HttpStatus.OK);
    }
}

