/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.util;

import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassLoaderUtil {
    private static Logger logger = LoggerFactory.getLogger(ClassLoaderUtil.class);

    private ClassLoaderUtil() {
    }

    public static void executeWithPluginClassLoader(ClassLoader newClassLoader, Runnable action) {
        ClassLoaderUtil.executeWithPluginClassLoader(newClassLoader, () -> {
            action.run();
            return null;
        });
    }

    public static <T> T executeWithPluginClassLoader(ClassLoader newClassLoader, Callable<T> action) {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        if (!oldClassLoader.equals(newClassLoader)) {
            boolean changedSuccessfully = false;
            try {
                try {
                    Thread.currentThread().setContextClassLoader(newClassLoader);
                    logger.debug("Set current thread class loader to {}", (Object)newClassLoader);
                    changedSuccessfully = true;
                }
                catch (SecurityException se) {
                    logger.warn("Could not change context class loader. Proceeding with initialization anyway.", (Throwable)se);
                }
                T se = action.call();
                return se;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                if (changedSuccessfully) {
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                    logger.debug("Restored thread class loader to {}", (Object)oldClassLoader);
                }
            }
        }
        try {
            return action.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

