/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.embedding;

import com.ontotext.trree.sdk.ClientErrorException;
import dev.langchain4j.model.embedding.EmbeddingModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddingModelUtil {
    private static final Logger logger = LoggerFactory.getLogger(EmbeddingModelUtil.class);

    public static EmbeddingModel createInstance(String embeddingModel) {
        logger.debug("Creating embedding model for class {}", (Object)embeddingModel);
        if (embeddingModel != null && !embeddingModel.isEmpty()) {
            try {
                Class<?> clazz = Class.forName(embeddingModel);
                if (!EmbeddingModel.class.isAssignableFrom(clazz)) {
                    throw new IllegalArgumentException(embeddingModel + " does not implement EmbeddingModel");
                }
                return (EmbeddingModel)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new ClientErrorException("Failed to instantiate embedding model: " + embeddingModel, (Throwable)e);
            }
        }
        throw EmbeddingModelUtil.throwNoProvidedEmbeddingModelImplementation();
    }

    public static IllegalStateException throwNoProvidedEmbeddingModelImplementation() {
        throw new IllegalStateException("No EmbeddingModel implementation provided");
    }

    private EmbeddingModelUtil() {
    }
}

