/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.solr;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.ontotext.trree.plugin.externalsync.ExternalSyncPlugin;
import com.ontotext.trree.plugin.externalsync.api.ExternalStore;
import com.ontotext.trree.plugin.externalsync.config.Option;
import com.ontotext.trree.plugin.externalsync.config.Options;
import com.ontotext.trree.plugin.externalsync.config.validators.ClassNameValidator;
import com.ontotext.trree.plugin.externalsync.config.validators.Validator;
import com.ontotext.trree.plugin.externalsync.config.validators.ValidatorWithPlugin;
import com.ontotext.trree.plugin.externalsync.impl.solr.SolrDriver;
import com.ontotext.trree.plugin.externalsync.impl.solr.SolrExternalStore;
import com.ontotext.trree.plugin.externalsync.impl.solr.SolrIndexExistValidator;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.PluginConnection;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.annotation.Nullable;

public class SolrPlugin
extends ExternalSyncPlugin {
    private static final String COPY_CONFIGS_FROM_FIELD = "copyConfigsFrom";
    private static final String SOLR_CORE_FIELD = "solrCore";
    private static final String SOLR_URL_FIELD = "solrUrl";
    private static final String SOLR_BASIC_AUTH_USER_FIELD = "solrBasicAuthUser";
    private static final String SOLR_BASIC_AUTH_PASSWORD_FIELD = "solrBasicAuthPassword";
    private static final String MANAGE_CORE_FIELD = "manageCore";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("external-sync-solr-option-description", Locale.getDefault());
    static final Option<String> SOLR_URL = Option.string((String)"solrUrl", (ResourceBundle)RESOURCE_BUNDLE).required().updatable().withValidator((Validator)new SolrIndexExistValidator()).build();
    static final Option<String> SOLR_BASIC_AUTH_USER = Option.string((String)"solrBasicAuthUser", (ResourceBundle)RESOURCE_BUNDLE).updatable().build();
    static final Option<String> SOLR_BASIC_AUTH_PASSWORD = Option.string((String)"solrBasicAuthPassword", (ResourceBundle)RESOURCE_BUNDLE).updatable().build();
    static final Option<String> AUTHENTICATION_CONFIGURATOR_CLASS = Option.string((String)"authenticationConfiguratorClass", (ResourceBundle)RESOURCE_BUNDLE).withValidator((Validator)new ClassNameValidator()).updatable().build();
    static final Option<String> SOLR_CORE = Option.string((String)"solrCore", (ResourceBundle)RESOURCE_BUNDLE).build();
    static final String DEFAULT_SOLR_CORE = "collection1";
    static final Option<String> CONFIGS_COPY_FROM = Option.string((String)"copyConfigsFrom", (ResourceBundle)RESOURCE_BUNDLE).defaultValue((Object)"collection1").withValidator((Validator)new SolrCoreValidator()).build();
    private static final String MANAGE_SCHEMA_NAME = "manageSchema";
    static final Option<Boolean> MANAGE_SCHEMA = Option.flag((String)"manageSchema", (ResourceBundle)RESOURCE_BUNDLE).defaultValue((Object)true).build();
    static final Option<Boolean> MANAGE_CORE = Option.flag((String)"manageCore", (ResourceBundle)RESOURCE_BUNDLE).defaultValue((Object)true).build();
    static final Option<Long> BULK_UPDATE_BATCH_SIZE = Option.longNumber((String)"bulkUpdateBatchSize", (ResourceBundle)RESOURCE_BUNDLE).defaultValue((Object)1000L).updatable().build();
    private static final List<Option<?>> SOLR_OPTIONS = ImmutableList.builder().add((Object)SolrPlugin.createFieldsOptions((Option[])new Option[0])).addAll((Iterable)DEFAULT_OPTIONS).add(SOLR_URL).add(SOLR_BASIC_AUTH_USER).add(SOLR_BASIC_AUTH_PASSWORD).add(AUTHENTICATION_CONFIGURATOR_CLASS).add(CONFIGS_COPY_FROM).add(SOLR_CORE).add(MANAGE_CORE).add(MANAGE_SCHEMA).add(BULK_UPDATE_BATCH_SIZE).build();

    public String getName() {
        return "solr-connector";
    }

    public String getShortName() {
        return "Solr";
    }

    protected ExternalStore openExistingStore(String storeName, Options storeOptions, PluginConnection pluginConnection) {
        return SolrExternalStore.open(storeName, storeOptions, this, pluginConnection);
    }

    protected ExternalStore createNewStore(String storeName, Options options, PluginConnection pluginConnection, Entities entitiesForCreation) {
        return SolrExternalStore.create(storeName, options, this, pluginConnection, entitiesForCreation);
    }

    public List<Option<?>> getAllOptions() {
        return SOLR_OPTIONS;
    }

    public String getURIComponent() {
        return "solr";
    }

    protected Set<String> getOptionsToRedactForUser() {
        return Set.of(SOLR_URL_FIELD, SOLR_BASIC_AUTH_USER_FIELD, SOLR_BASIC_AUTH_PASSWORD_FIELD, "authenticationConfiguratorClass");
    }

    private static class SolrCoreValidator
    implements ValidatorWithPlugin<String> {
        private SolrCoreValidator() {
        }

        public String validate(@Nullable String core, Options optionsSet) {
            throw new IllegalStateException("Plugin required. Use the other method to validate.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public String validate(ExternalSyncPlugin plugin, @Nullable String indexName, Options optionsSet) {
            String solrUrl = (String)optionsSet.getValue(SOLR_URL);
            assert (indexName != null) : "copyConfigsFrom has a default value";
            if (plugin.isTestingTransaction() && !Strings.isNullOrEmpty((String)solrUrl)) {
                solrDriver.setPlugin(plugin);
                try (SolrDriver solrDriver = SolrDriver.from(indexName, optionsSet, plugin.getLogger());){
                    String copyConfigsFrom = (String)optionsSet.getValue(CONFIGS_COPY_FROM);
                    assert (copyConfigsFrom != null) : "copyConfigsFrom has a default value";
                    if (!solrDriver.copyConfigsFromExists(copyConfigsFrom)) {
                        if (solrDriver.isSolrCloudMode()) {
                            String string = "Config set " + copyConfigsFrom + " does not exist or copyConfigsFrom option is invalid!";
                            return string;
                        }
                        String string = "Template core " + copyConfigsFrom + " does not exist or copyConfigsFrom option is invalid!";
                        return string;
                    }
                }
            }
            return null;
        }
    }
}

