/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.solr;

import com.ontotext.trree.plugin.externalsync.ExternalSyncPlugin;
import com.ontotext.trree.plugin.externalsync.SearchOptions;
import com.ontotext.trree.plugin.externalsync.api.ConnectorServerException;
import com.ontotext.trree.plugin.externalsync.api.ConnectorUserException;
import com.ontotext.trree.plugin.externalsync.auth.HttpClientConfigurator;
import com.ontotext.trree.plugin.externalsync.auth.UsernamePasswordProvider;
import com.ontotext.trree.plugin.externalsync.config.Options;
import com.ontotext.trree.plugin.externalsync.config.OptionsUtil;
import com.ontotext.trree.plugin.externalsync.impl.solr.HttpSolrServerClusterChecking;
import com.ontotext.trree.plugin.externalsync.impl.solr.SolrConnectorCollectionAdminRequest;
import com.ontotext.trree.plugin.externalsync.impl.solr.SolrConnectorCoreAdminRequest;
import com.ontotext.trree.plugin.externalsync.impl.solr.SolrPlugin;
import com.ontotext.trree.plugin.externalsync.impl.solr.SolrResult;
import com.ontotext.trree.plugin.externalsync.iterators.master.MasterResultIterator;
import com.ontotext.trree.plugin.externalsync.util.EntitiesUtil;
import com.ontotext.trree.sdk.ClientErrorException;
import com.ontotext.trree.sdk.HealthCheckable;
import com.ontotext.trree.sdk.HealthResult;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.NameValuePair;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudHttp2SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.ClusterStateProvider;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.impl.HttpListenerFactory;
import org.apache.solr.client.solrj.impl.ZkClientClusterStateProvider;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.response.CoreAdminResponse;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.eclipse.jetty.client.HttpRequestException;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.rdf4j.model.Value;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrDriver
implements HealthCheckable {
    static boolean CHECK_ONLY_ONE_WORKER_MODIFIES_SOLR = false;
    private static final Logger LOG = LoggerFactory.getLogger(SolrDriver.class);
    private static final String SOLR_SO_TIMEOUT_PROPERTY = "solr.so.timeout";
    private static final int SOLR_SO_TIMEOUT_DEFAULT = 60000;
    private static final String SOLR_CONNECTION_TIMEOUT_PROPERTY = "solr.connection.timeout";
    private static final int SOLR_CONNECTION_TIMEOUT_DEFAULT = 30000;
    private static final int PAGE_SIZE_FOR_NORMAL_RESULTS = 1000;
    private static final Set<String> BLACKLISTED_SOLR_PARAMS;
    private SolrConnectorCollectionAdminRequest collectionAdminRequest;
    private SolrConnectorCoreAdminRequest coreAdminRequest;
    private static final HttpContext dummyHttpContext;
    private SolrClient solr;
    private Http2SolrClient httpClient;
    private boolean isSolrCloudMode;
    private final String indexName;
    private final Logger logger;
    private String solrUrl;
    private final String coreOrCollectionName;
    private ExternalSyncPlugin plugin;
    private int bulkUpdateBatchSize;
    private List<SolrInputDocument> documentsToAdd;
    private List<String> documentIdsToDelete;
    static final SolrProvider DEFAULT_SOLR_PROVIDER;
    private static SolrProvider solrProvider;

    private SolrDriver(String name, Options options, Logger logger) {
        this.indexName = name;
        this.logger = logger;
        this.coreOrCollectionName = (String)options.getValueOr(SolrPlugin.SOLR_CORE, (Object)name);
        this.applyUpdatableOptions(options);
        this.beginInternal();
    }

    public long count() throws IOException, SolrServerException {
        SolrQuery query = new SolrQuery("*:*");
        query.setRows(Integer.valueOf(0));
        QueryResponse queryResponse = this.solr.query(this.coreOrCollectionName, (SolrParams)query);
        return queryResponse.getResults().getNumFound();
    }

    boolean isSolrCloudMode() {
        return this.isSolrCloudMode;
    }

    private static int getSolrSocketTimeoutProperty() {
        int soTimeout = 60000;
        String soTimeoutProperty = System.getProperty(SOLR_SO_TIMEOUT_PROPERTY);
        if (soTimeoutProperty != null) {
            try {
                soTimeout = Integer.parseInt(soTimeoutProperty);
            }
            catch (NumberFormatException e) {
                LOG.error("Solr socket timeout must be an integer: {}", (Object)soTimeoutProperty);
            }
        }
        return soTimeout;
    }

    private static int getSolrConnectTimeoutProperty() {
        int connectionTimeout = 30000;
        String connectionTimeoutProperty = System.getProperty(SOLR_CONNECTION_TIMEOUT_PROPERTY);
        if (connectionTimeoutProperty != null) {
            try {
                connectionTimeout = Integer.parseInt(connectionTimeoutProperty);
            }
            catch (NumberFormatException e) {
                LOG.error("Solr connection timeout must be an integer: {}", (Object)connectionTimeoutProperty);
            }
        }
        return connectionTimeout;
    }

    static void setSolrProvider(@Nullable SolrProvider solrProvider) {
        SolrDriver.solrProvider = solrProvider == null ? DEFAULT_SOLR_PROVIDER : solrProvider;
    }

    public static SolrDriver from(String name, Options options, Logger logger) {
        return new SolrDriver(name, options, logger);
    }

    public void setPlugin(ExternalSyncPlugin plugin) {
        this.plugin = plugin;
    }

    void createNewCoreOrCollection(String copyFrom) {
        if (this.plugin.isTestingTransaction()) {
            if (this.isSolrCloudMode) {
                if (this.plugin.isTestingTransaction()) {
                    this.collectionAdminRequest.withSolrDriver(this).withCollectionName(this.coreOrCollectionName).withConfigSetName(copyFrom).withZkConnectionString(this.solrUrl).create();
                }
            } else {
                this.coreAdminRequest.withSolrDriver(this).withCoreName(this.coreOrCollectionName).withInstanceDir(this.coreOrCollectionName).withCopyCoreFrom(copyFrom).create();
            }
        }
    }

    private boolean coreExists(String coreName) throws IOException, SolrServerException {
        CoreAdminResponse status = CoreAdminRequest.getStatus((String)coreName, (SolrClient)this.solr);
        return status.getCoreStatus(coreName) != null && status.getCoreStatus(coreName).size() > 0;
    }

    boolean copyConfigsFromExists(String copyConfigsFrom) {
        try {
            if (this.isSolrCloudMode) {
                CloudSolrClient solrCloudClient = (CloudSolrClient)this.solr;
                solrCloudClient.connect();
                return solrCloudClient.getClusterStateProvider().getState(copyConfigsFrom) != null;
            }
            return this.coreExists(copyConfigsFrom);
        }
        catch (Exception e) {
            return (Boolean)this.handleSolrException("Could not connect to Solr", e);
        }
    }

    boolean solrIndexExists() {
        try {
            if (this.isSolrCloudMode) {
                CloudSolrClient solrCloudClient = (CloudSolrClient)this.solr;
                solrCloudClient.connect();
                ZkStateReader reader = ZkStateReader.from((CloudSolrClient)solrCloudClient);
                DocCollection collection = reader.getClusterState().getCollectionOrNull(this.coreOrCollectionName);
                return collection != null;
            }
            return this.coreExists(this.coreOrCollectionName);
        }
        catch (Exception e) {
            return (Boolean)this.handleSolrException("Could not connect to Solr", e);
        }
    }

    NamedList<Object> executeRequest(SolrRequest request) {
        try {
            return this.solr.request(request, this.coreOrCollectionName);
        }
        catch (Exception e) {
            return (NamedList)this.handleSolrException("Error executing Solr request", e);
        }
    }

    void delete(String subjectUri) {
        if (this.plugin.isTestingTransaction()) {
            this.documentIdsToDelete.add(subjectUri);
            if (this.documentIdsToDelete.size() >= this.bulkUpdateBatchSize) {
                this.flush();
            }
        }
    }

    private void beginInternal() {
        if (this.documentIdsToDelete == null || !this.documentIdsToDelete.isEmpty()) {
            this.documentIdsToDelete = new ArrayList<String>(this.bulkUpdateBatchSize);
        }
        if (this.documentsToAdd == null || !this.documentsToAdd.isEmpty()) {
            this.documentsToAdd = new ArrayList<SolrInputDocument>(this.bulkUpdateBatchSize);
        }
    }

    private void flush() {
        if (this.plugin.isTestingTransaction()) {
            try {
                if (!this.documentIdsToDelete.isEmpty()) {
                    try {
                        this.solr.deleteById(this.coreOrCollectionName, this.documentIdsToDelete);
                    }
                    catch (Exception e) {
                        this.handleSolrException("Unable to delete documents", e);
                    }
                }
                if (!this.documentsToAdd.isEmpty()) {
                    try {
                        this.solr.add(this.coreOrCollectionName, this.documentsToAdd);
                    }
                    catch (IOException | SolrServerException e) {
                        this.handleSolrException("Unable to add documents", (Exception)e);
                    }
                }
            }
            finally {
                this.beginInternal();
            }
        }
    }

    void commit() {
        if (this.plugin.isTestingTransaction()) {
            try {
                this.flush();
                this.solr.commit(this.coreOrCollectionName);
            }
            catch (IOException | SolrServerException e) {
                this.handleSolrException("Unable to commit transaction", (Exception)e);
            }
        }
    }

    void rollback() {
        if (this.plugin.isTestingTransaction()) {
            try {
                this.documentIdsToDelete = null;
                this.documentsToAdd = null;
                this.beginInternal();
                this.solr.rollback(this.coreOrCollectionName);
            }
            catch (IOException | SolrServerException e) {
                this.handleSolrException("Unable to rollback transaction", (Exception)e);
            }
        }
    }

    void deleteCoreOrCollection() {
        if (this.plugin.isTestingTransaction()) {
            if (this.isSolrCloudMode) {
                this.collectionAdminRequest.withSolrDriver(this).withCollectionName(this.coreOrCollectionName).delete();
            } else {
                this.coreAdminRequest.withSolrDriver(this).withCoreName(this.coreOrCollectionName).delete();
            }
        }
    }

    void save(SolrInputDocument document) throws IOException {
        if (this.plugin.isTestingTransaction()) {
            this.documentsToAdd.add(document);
            if (this.documentsToAdd.size() >= this.bulkUpdateBatchSize) {
                this.flush();
            }
        }
    }

    void deleteAll() {
        if (this.plugin.isTestingTransaction()) {
            try {
                UpdateResponse response = this.solr.deleteByQuery(this.coreOrCollectionName, "*:*");
                this.logger.debug("[{}] It took {} to delete everything in the core", (Object)this.indexName, (Object)response.getElapsedTime());
            }
            catch (Exception e) {
                this.handleSolrException("Couldn't delete all data from core", e);
            }
        }
    }

    public SolrResult query(MasterResultIterator mri, List<String> facets) {
        String queryString = mri.getQueryString();
        SearchOptions options = mri.getSearchOptions();
        SolrQuery parsedQuery = new SolrQuery();
        long subjectFilter = mri.getEntitySubjectFilter();
        if (queryString != null && queryString.startsWith("q=")) {
            try {
                for (NameValuePair nvp : new URIBuilder("http://localhost/?" + queryString).getQueryParams()) {
                    String name = nvp.getName();
                    if (BLACKLISTED_SOLR_PARAMS.contains(name)) continue;
                    String value = nvp.getValue();
                    parsedQuery.add(name, new String[]{value});
                }
            }
            catch (URISyntaxException e) {
                throw new ClientErrorException("Invalid parameters", (Throwable)e);
            }
        }
        if (queryString != null && queryString.trim().startsWith("{")) {
            try {
                JSONParser parser = new JSONParser();
                JSONObject jsonQuery = (JSONObject)parser.parse(queryString);
                for (Object e : jsonQuery.entrySet()) {
                    String key = (String)((Map.Entry)e).getKey();
                    Object value = ((Map.Entry)e).getValue();
                    if (BLACKLISTED_SOLR_PARAMS.contains(key)) continue;
                    if (value instanceof String) {
                        parsedQuery.add(key, new String[]{(String)value});
                        continue;
                    }
                    if (value instanceof JSONArray) {
                        for (Object el : (JSONArray)value) {
                            if (el instanceof String) {
                                parsedQuery.add(key, new String[]{(String)el});
                                continue;
                            }
                            throw new ClientErrorException("Unexpected JSON format. The values must be strings.");
                        }
                        continue;
                    }
                    throw new ClientErrorException("Unexpected JSON format. The values must be strings.");
                }
            }
            catch (ParseException e) {
                throw new ClientErrorException("Invalid JSON string.", (Throwable)e);
            }
        }
        if (queryString == null || queryString.isEmpty()) {
            parsedQuery.setQuery("*:*");
        } else {
            parsedQuery.setQuery(queryString);
        }
        if (subjectFilter != 0L) {
            parsedQuery.addFilterQuery(new String[]{"id:" + ClientUtils.escapeQueryChars((String)EntitiesUtil.valueToString((Value)mri.getEntities().get(subjectFilter)))});
        }
        if (!facets.isEmpty()) {
            parsedQuery.setFacet(true);
            parsedQuery.setFacetMinCount(1);
            parsedQuery.addFacetField(facets.toArray(new String[facets.size()]));
        }
        parsedQuery.addField("id");
        parsedQuery.addField("score");
        if (options.offset > 0) {
            parsedQuery.setStart(Integer.valueOf(options.offset));
        }
        if (options.limit > 0) {
            parsedQuery.setRows(Integer.valueOf(options.limit));
        }
        for (SearchOptions.OrderPredicate orderPredicate : options.orderBy) {
            SolrQuery.ORDER order = SolrDriver.getOrder(orderPredicate);
            parsedQuery.addSort("score".equals(orderPredicate.predicate) ? "score" : orderPredicate.predicate, order);
        }
        if (mri.isSnippets()) {
            parsedQuery.setHighlight(true);
            if (StringUtils.isEmpty((CharSequence)parsedQuery.getHighlightSimplePre())) {
                parsedQuery.setHighlightSimplePre(options.snippetPre);
            }
            if (StringUtils.isEmpty((CharSequence)parsedQuery.getHighlightSimplePost())) {
                parsedQuery.setHighlightSimplePost(options.snippetPost);
            }
            if (parsedQuery.getHighlightFields() == null) {
                parsedQuery.addHighlightField("*");
            }
        }
        return new SolrResult(this.indexName, this.logger, 1000, true, parsedQuery, this);
    }

    static SolrQuery.ORDER getOrder(SearchOptions.OrderPredicate orderPredicate) {
        SolrQuery.ORDER order;
        if (orderPredicate.isScoreSpecial()) {
            order = SolrQuery.ORDER.desc;
            if (orderPredicate.reverse) {
                order = SolrQuery.ORDER.asc;
            }
        } else {
            order = SolrQuery.ORDER.asc;
            if (orderPredicate.reverse) {
                order = SolrQuery.ORDER.desc;
            }
        }
        return order;
    }

    boolean isTestingTransaction() {
        return this.plugin.isTestingTransaction();
    }

    QueryResponse solrQuery(SolrQuery query) {
        try {
            return this.solr.query(this.coreOrCollectionName, (SolrParams)query);
        }
        catch (Exception e) {
            return (QueryResponse)this.handleSolrException("Unable to execute Solr query", e);
        }
    }

    public String getCoreOrCollectionName() {
        return this.coreOrCollectionName;
    }

    <T> T handleSolrException(String message, Exception e) {
        throw new ConnectorServerException(message + ": " + e.getMessage(), (Throwable)e);
    }

    public void close() {
        try {
            solrProvider.close(this.solr);
        }
        finally {
            if (this.httpClient != null) {
                this.httpClient.close();
            }
        }
    }

    public HealthResult runHealthCheck() {
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setRows(Integer.valueOf(1));
        solrQuery.setQuery("*:*");
        try {
            QueryResponse queryResponse = this.solr.query(this.coreOrCollectionName, (SolrParams)solrQuery);
            long hits = queryResponse.getResults().getNumFound();
            String message = String.format("query took %d ms, %d hits", queryResponse.getElapsedTime(), hits);
            if (hits == 0L) {
                return new HealthResult(this.indexName, HealthResult.Status.YELLOW, message);
            }
            return new HealthResult(this.indexName, HealthResult.Status.GREEN, message);
        }
        catch (Exception e) {
            return new HealthResult(this.indexName, HealthResult.Status.RED, "query cannot be run: " + e.getMessage());
        }
    }

    void applyUpdatableOptions(Options options) {
        String newSolrUrl = (String)options.getValue(SolrPlugin.SOLR_URL);
        assert (newSolrUrl != null);
        boolean newIsSolrCloudMode = newSolrUrl.contains("zk://");
        Pair<Http2SolrClient, SolrClient> httpAndSolrClient = solrProvider.get(options, this.coreOrCollectionName, this, true);
        Http2SolrClient newHttpClient = (Http2SolrClient)httpAndSolrClient.getLeft();
        SolrClient newSolr = (SolrClient)httpAndSolrClient.getRight();
        if (CHECK_ONLY_ONE_WORKER_MODIFIES_SOLR) {
            newSolr = new HttpSolrServerClusterChecking(newSolr, this);
        }
        SolrConnectorCollectionAdminRequest newCollectionAdminRequest = null;
        SolrConnectorCoreAdminRequest newCoreAdminRequest = null;
        if (newIsSolrCloudMode) {
            newCollectionAdminRequest = SolrConnectorCollectionAdminRequest.newInstance().withSolrClient(newSolr);
        } else {
            newCoreAdminRequest = SolrConnectorCoreAdminRequest.newInstance(this.indexName, this.logger).withSolrClient(newSolr);
        }
        this.solrUrl = newSolrUrl;
        this.isSolrCloudMode = newIsSolrCloudMode;
        this.collectionAdminRequest = newCollectionAdminRequest;
        this.coreAdminRequest = newCoreAdminRequest;
        Http2SolrClient oldHttpClient = this.httpClient;
        SolrClient oldSolr = this.solr;
        this.httpClient = newHttpClient;
        this.solr = newSolr;
        this.bulkUpdateBatchSize = ((Long)options.getValue(SolrPlugin.BULK_UPDATE_BATCH_SIZE)).intValue();
        if (oldHttpClient != null) {
            try {
                oldHttpClient.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (oldSolr != null) {
            try {
                oldSolr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static {
        dummyHttpContext = new HttpContext(){

            public Object getAttribute(String id) {
                return null;
            }

            public void setAttribute(String id, Object obj) {
            }

            public Object removeAttribute(String id) {
                return null;
            }
        };
        BLACKLISTED_SOLR_PARAMS = new HashSet<String>();
        BLACKLISTED_SOLR_PARAMS.add("fl");
        BLACKLISTED_SOLR_PARAMS.add("wt");
        BLACKLISTED_SOLR_PARAMS.add("hl");
        BLACKLISTED_SOLR_PARAMS.add("indent");
        BLACKLISTED_SOLR_PARAMS.add("debugQuery");
        BLACKLISTED_SOLR_PARAMS.add("_");
        solrProvider = DEFAULT_SOLR_PROVIDER = new SolrProvider(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Pair<Http2SolrClient, SolrClient> get(Options options, String coreOrCollectionName, SolrDriver driver, boolean isAdmin) {
                Object solrUrlOrZkHosts = (String)options.getValue(SolrPlugin.SOLR_URL);
                assert (solrUrlOrZkHosts != null);
                boolean isSolrCloudMode = ((String)solrUrlOrZkHosts).contains("zk://");
                if (isSolrCloudMode) {
                    solrUrlOrZkHosts = ((String)solrUrlOrZkHosts).replace("zk://", "").split("\\|")[0];
                } else if (!isAdmin) {
                    solrUrlOrZkHosts = (String)solrUrlOrZkHosts + "/" + coreOrCollectionName;
                }
                int socketTimeout = SolrDriver.getSolrSocketTimeoutProperty();
                int connectTimeout = SolrDriver.getSolrConnectTimeoutProperty();
                HttpListenerFactory authInterceptorListener = null;
                Http2SolrClient.Builder http2SolrClientBuilder = new Http2SolrClient.Builder((String)solrUrlOrZkHosts).connectionTimeout(connectTimeout);
                String solrBasicAuthUser = null;
                String solrBasicAuthPassword = null;
                Object authenticationProvider = OptionsUtil.instantiateClassFromOption((Options)options, SolrPlugin.AUTHENTICATION_CONFIGURATOR_CLASS);
                if (authenticationProvider != null) {
                    if (authenticationProvider instanceof HttpClientConfigurator) {
                        Credentials credentials;
                        CredentialsProvider credentialsProvider;
                        HttpClientConfigurator httpClientConfigurator = (HttpClientConfigurator)authenticationProvider;
                        final HttpRequestInterceptor authInterceptor = httpClientConfigurator.getHttpRequestInterceptor((String)solrUrlOrZkHosts, driver.indexName);
                        if (authInterceptor != null) {
                            authInterceptorListener = () -> new HttpListenerFactory.RequestResponseListener(this){

                                public void onBegin(Request request) {
                                    try {
                                        authInterceptor.process((HttpRequest)new JettyRequestWrapper(request), dummyHttpContext);
                                    }
                                    catch (IOException | HttpException e) {
                                        throw new HttpRequestException(e.getMessage(), request);
                                    }
                                }
                            };
                        }
                        if ((credentialsProvider = httpClientConfigurator.getCredentialsProvider((String)solrUrlOrZkHosts, driver.indexName)) != null && (credentials = credentialsProvider.getCredentials(AuthScope.ANY)) != null) {
                            solrBasicAuthUser = credentials.getUserPrincipal().getName();
                            solrBasicAuthPassword = credentials.getPassword();
                        }
                    } else {
                        if (!(authenticationProvider instanceof UsernamePasswordProvider)) throw new ConnectorUserException("Provided authentication class " + authenticationProvider.getClass().getName() + " does not implement any of the supported interfaces");
                        UsernamePasswordProvider.Credentials credentials = ((UsernamePasswordProvider)authenticationProvider).getCredentials((String)solrUrlOrZkHosts, driver.indexName);
                        if (credentials != null) {
                            solrBasicAuthUser = credentials.getUsername();
                            solrBasicAuthPassword = credentials.getPassword();
                        }
                    }
                } else {
                    solrBasicAuthUser = (String)options.getValue(SolrPlugin.SOLR_BASIC_AUTH_USER);
                    solrBasicAuthPassword = (String)options.getValue(SolrPlugin.SOLR_BASIC_AUTH_PASSWORD);
                }
                if (StringUtils.isNotEmpty((CharSequence)solrBasicAuthUser) && StringUtils.isNotEmpty((CharSequence)solrBasicAuthPassword)) {
                    http2SolrClientBuilder.withBasicAuthCredentials(solrBasicAuthUser, solrBasicAuthPassword);
                }
                Http2SolrClient http2SolrClient = http2SolrClientBuilder.build();
                if (authInterceptorListener != null) {
                    http2SolrClient.addListenerFactory(authInterceptorListener);
                }
                if (!isSolrCloudMode) return Pair.of(null, (Object)http2SolrClient);
                CloudHttp2SolrClient cloudSolrClient = new CloudSolrClient.Builder(Collections.singletonList(solrUrlOrZkHosts), Optional.empty()).withHttpClient(http2SolrClient).build();
                ClusterStateProvider clusterStateProvider = cloudSolrClient.getClusterStateProvider();
                if (!(clusterStateProvider instanceof ZkClientClusterStateProvider)) return Pair.of((Object)http2SolrClient, (Object)cloudSolrClient);
                ((ZkClientClusterStateProvider)clusterStateProvider).setZkClientTimeout(socketTimeout);
                ((ZkClientClusterStateProvider)clusterStateProvider).setZkConnectTimeout(connectTimeout);
                return Pair.of((Object)http2SolrClient, (Object)cloudSolrClient);
            }

            @Override
            public void close(SolrClient client) {
                try {
                    client.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
    }

    static interface SolrProvider {
        public Pair<Http2SolrClient, SolrClient> get(Options var1, String var2, SolrDriver var3, boolean var4);

        public void close(SolrClient var1);
    }

    static class JettyRequestWrapper
    implements HttpUriRequest {
        Request jettyRequest;

        JettyRequestWrapper(Request jettyRequest) {
            this.jettyRequest = jettyRequest;
        }

        public String getMethod() {
            return this.jettyRequest.getMethod();
        }

        public URI getURI() {
            return this.jettyRequest.getURI();
        }

        public void setHeader(String name, String value) {
            this.jettyRequest.header(name, null);
            this.jettyRequest.header(name, value);
        }

        public void setHeader(Header header) {
            this.setHeader(header.getName(), header.getValue());
        }

        public void addHeader(String name, String value) {
            this.jettyRequest.header(name, value);
        }

        public ProtocolVersion getProtocolVersion() {
            HttpVersion version = this.jettyRequest.getVersion();
            int major = version.getVersion() / 10;
            int minor = version.getVersion() % 10;
            return new ProtocolVersion("HTTP", major, minor);
        }

        public boolean containsHeader(String name) {
            return this.jettyRequest.getHeaders().contains(name);
        }

        public void addHeader(Header header) {
            this.addHeader(header.getName(), header.getValue());
        }

        public void removeHeaders(String name) {
            this.jettyRequest.header(name, null);
        }

        public Header[] getHeaders(String name) {
            throw new NotImplementedException();
        }

        public Header getFirstHeader(String name) {
            throw new NotImplementedException();
        }

        public Header getLastHeader(String name) {
            throw new NotImplementedException();
        }

        public Header[] getAllHeaders() {
            throw new NotImplementedException();
        }

        public HeaderIterator headerIterator() {
            throw new NotImplementedException();
        }

        public HeaderIterator headerIterator(String name) {
            throw new NotImplementedException();
        }

        public void setHeaders(Header[] headers) {
            throw new NotImplementedException();
        }

        public void removeHeader(Header header) {
            throw new NotImplementedException();
        }

        public RequestLine getRequestLine() {
            throw new NotImplementedException();
        }

        public void abort() {
            this.jettyRequest.abort((Throwable)new ConnectorUserException("Request was aborted"));
        }

        public boolean isAborted() {
            return this.jettyRequest.getAbortCause() != null;
        }

        public HttpParams getParams() {
            throw new NotImplementedException();
        }

        public void setParams(HttpParams params) {
            throw new NotImplementedException();
        }
    }
}

