/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.solr;

import com.ontotext.trree.plugin.externalsync.api.ConnectorServerException;
import com.ontotext.trree.plugin.externalsync.impl.solr.SolrDriver;
import java.util.Optional;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.response.CoreAdminResponse;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;

public class SolrConnectorCoreAdminRequest {
    private final String indexName;
    private final Logger logger;
    private SolrDriver solrDriver;
    private SolrClient solrClient;
    private String coreName;
    private String instanceDir;
    private String copyCoreFrom;

    private SolrConnectorCoreAdminRequest(String indexName, Logger logger) {
        this.indexName = indexName;
        this.logger = logger;
    }

    public static SolrConnectorCoreAdminRequest newInstance(String indexName, Logger logger) {
        return new SolrConnectorCoreAdminRequest(indexName, logger);
    }

    public SolrConnectorCoreAdminRequest withSolrDriver(SolrDriver solrDriver) {
        this.solrDriver = solrDriver;
        return this;
    }

    public SolrConnectorCoreAdminRequest withSolrClient(SolrClient solrClient) {
        this.solrClient = solrClient;
        return this;
    }

    public SolrConnectorCoreAdminRequest withCoreName(String coreName) {
        this.coreName = coreName;
        return this;
    }

    public SolrConnectorCoreAdminRequest withInstanceDir(String instanceDir) {
        this.instanceDir = instanceDir;
        return this;
    }

    public SolrConnectorCoreAdminRequest withCopyCoreFrom(String copyCoreFrom) {
        this.copyCoreFrom = copyCoreFrom;
        return this;
    }

    public CoreAdminRequest.Create create() {
        this.checkNonNull(this.coreName, "coreName");
        this.checkNonNull(this.instanceDir, "instanceDir");
        this.checkNonNull(this.copyCoreFrom, "copyCoreFrom");
        try {
            CustomCreateRequest createRequest = new CustomCreateRequest(this.copyCoreFrom);
            createRequest.setCoreName(this.coreName);
            createRequest.setInstanceDir(this.instanceDir);
            CoreAdminResponse response = (CoreAdminResponse)createRequest.process(this.solrClient);
            this.logger.debug("[{}] It took {} to create the new core from {}", new Object[]{this.indexName, response.getElapsedTime(), this.copyCoreFrom});
            return createRequest;
        }
        catch (Exception e) {
            return (CoreAdminRequest.Create)this.solrDriver.handleSolrException("Could not create new core in Solr", e);
        }
    }

    public CoreAdminRequest.Unload delete() {
        this.checkNonNull(this.coreName, "coreName");
        this.checkNonNull(this.solrClient, "solrClient");
        try {
            CoreAdminRequest.Unload req = new CoreAdminRequest.Unload(true);
            req.setCoreName(this.coreName);
            req.setDeleteInstanceDir(true);
            CoreAdminResponse response = (CoreAdminResponse)req.process(this.solrClient);
            this.logger.debug("[{}] It took {} to delete core {}", new Object[]{this.indexName, response.getElapsedTime(), this.coreName});
            return req;
        }
        catch (Exception e) {
            return (CoreAdminRequest.Unload)this.solrDriver.handleSolrException("Couldn't delete solr core " + this.coreName, e);
        }
    }

    private void checkNonNull(Object requiredParam, String requiredParamName) {
        Optional.of(requiredParam).orElseThrow(() -> new IllegalArgumentException(requiredParamName + " is a required parameter in order to create a Solr core"));
    }

    private static class CustomCreateRequest
    extends CoreAdminRequest.Create {
        private String copyCoreFrom;

        CustomCreateRequest(String copyCoreFrom) {
            this.copyCoreFrom = copyCoreFrom;
        }

        public SolrParams getParams() {
            SolrParams params = super.getParams();
            if (!(params instanceof ModifiableSolrParams)) {
                throw new ConnectorServerException("Solr changed and we cannot set custom parameters to the create core request!");
            }
            ModifiableSolrParams modifiableSolrParams = (ModifiableSolrParams)params;
            modifiableSolrParams.set("coreFrom", new String[]{this.copyCoreFrom});
            return params;
        }
    }
}

