/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.solr;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.ontotext.trree.plugin.externalsync.impl.solr.SolrDriver;
import com.ontotext.trree.sdk.ClientErrorException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class SolrConnectorCollectionAdminRequest {
    private static final Pattern SOLRCLOUD_ZK_OPTIONS_PATTERN = Pattern.compile("(numshards|replicationfactor|maxshardspernode|autoaddreplicas|router.name|router.field|shards)=(.*)", 2);
    private static final String ROUTER_NAME_ZK_OPTION = "router.name";
    private static final String ROUTER_FIELD_ZK_OPTION = "router.field";
    private static final String SHARDS_ZK_OPTION = "shards";
    private static final String NUM_SHARDS_ZK_OPTION = "numshards";
    private static final String REPLICATION_FACTOR_ZK_OPTION = "replicationfactor";
    private SolrDriver solrDriver;
    private String collectionName;
    private String configSetName;
    private SolrClient solrClient;
    private String zkConnectionStr;

    private SolrConnectorCollectionAdminRequest() {
    }

    public static SolrConnectorCollectionAdminRequest newInstance() {
        return new SolrConnectorCollectionAdminRequest();
    }

    public SolrConnectorCollectionAdminRequest withSolrDriver(SolrDriver solrDriver) {
        this.solrDriver = solrDriver;
        return this;
    }

    public SolrConnectorCollectionAdminRequest withSolrClient(SolrClient solrClient) {
        this.solrClient = solrClient;
        return this;
    }

    public SolrConnectorCollectionAdminRequest withZkConnectionString(String zkConnectionStr) {
        this.zkConnectionStr = zkConnectionStr;
        return this;
    }

    public SolrConnectorCollectionAdminRequest withCollectionName(String collectionName) {
        this.collectionName = collectionName;
        return this;
    }

    public SolrConnectorCollectionAdminRequest withConfigSetName(String configName) {
        this.configSetName = configName;
        return this;
    }

    public CollectionAdminRequest.Create create() {
        try {
            this.checkNonNull(this.collectionName, "collectionName");
            this.checkNonNull(this.configSetName, "configSetName");
            this.checkNonNull(this.solrClient, "solrClient");
            Optional.of(this.zkConnectionStr).orElseThrow(() -> new IllegalArgumentException("ZooKeeper connection string is required in solrUrl parameter in order to create a new SolrCloud collection"));
            Map<String, Object> zkOptions = SolrConnectorCollectionAdminRequest.getAdditionalZkOptions(this.zkConnectionStr);
            int numShards = (Integer)Optional.ofNullable(zkOptions.get(NUM_SHARDS_ZK_OPTION)).orElse(2);
            int replicationFactor = (Integer)Optional.ofNullable(zkOptions.get(REPLICATION_FACTOR_ZK_OPTION)).orElse(2);
            String routerName = String.valueOf(Optional.ofNullable(zkOptions.get(ROUTER_NAME_ZK_OPTION)).orElse("compositeId"));
            Optional<Object> routerField = Optional.ofNullable(zkOptions.get(ROUTER_FIELD_ZK_OPTION));
            String shards = String.valueOf(Optional.ofNullable(zkOptions.get(SHARDS_ZK_OPTION)).orElse(""));
            CustomCollectionCreateRequest createRequest = new CustomCollectionCreateRequest(this.collectionName, this.configSetName, numShards, replicationFactor);
            createRequest.setRouterName(routerName);
            createRequest.setRouterField(routerField.isPresent() ? String.valueOf(routerField) : null);
            if (!shards.isEmpty()) {
                createRequest.setShards(shards);
            }
            createRequest.process(this.solrClient);
            return createRequest;
        }
        catch (Exception e) {
            return (CollectionAdminRequest.Create)this.solrDriver.handleSolrException("Could not create new collection " + this.collectionName + " in SolrCloud", e);
        }
    }

    public CollectionAdminRequest.Delete delete() {
        this.checkNonNull(this.collectionName, "collectionName");
        this.checkNonNull(this.solrClient, "solrClient");
        CollectionAdminRequest.Delete deleteRequest = CollectionAdminRequest.deleteCollection((String)this.collectionName);
        try {
            deleteRequest.process(this.solrClient);
            return deleteRequest;
        }
        catch (Exception e) {
            return (CollectionAdminRequest.Delete)this.solrDriver.handleSolrException("Could not delete collection " + this.collectionName + " in SolrCloud", e);
        }
    }

    private static Map<String, Object> getAdditionalZkOptions(String optionsString) {
        HashMap zkOptions = Maps.newHashMap();
        ArrayList unknownSettings = Lists.newArrayList();
        String[] zkSettings = optionsString.split("\\|");
        for (int i = 1; i < zkSettings.length; ++i) {
            Matcher matcher = SOLRCLOUD_ZK_OPTIONS_PATTERN.matcher(zkSettings[i]);
            if (matcher.matches()) {
                String option = matcher.group(1).toLowerCase();
                String value = matcher.group(2);
                switch (option) {
                    case "numshards": {
                        zkOptions.put(NUM_SHARDS_ZK_OPTION, Integer.parseInt(value));
                        break;
                    }
                    case "replicationfactor": {
                        zkOptions.put(REPLICATION_FACTOR_ZK_OPTION, Integer.parseInt(value));
                        break;
                    }
                    case "router.name": {
                        zkOptions.put(ROUTER_NAME_ZK_OPTION, value);
                        break;
                    }
                    case "router.field": {
                        zkOptions.put(ROUTER_FIELD_ZK_OPTION, value);
                        break;
                    }
                    case "shards": {
                        zkOptions.put(SHARDS_ZK_OPTION, value);
                    }
                }
            } else {
                unknownSettings.add(zkSettings[i]);
            }
            if (unknownSettings.isEmpty()) continue;
            throw new IllegalArgumentException("Invalid options: " + String.valueOf(unknownSettings));
        }
        return zkOptions;
    }

    private void checkNonNull(Object requiredParam, String requiredParamName) {
        Optional.of(requiredParam).orElseThrow(() -> new IllegalArgumentException(requiredParamName + " is a required parameter in order to create a SolrCloud collection"));
    }

    private static class CustomCollectionCreateRequest
    extends CollectionAdminRequest.Create {
        private String collectionName;

        public CustomCollectionCreateRequest(String collectionName, String configSetName, int numShards, int replicationFactor) {
            super(collectionName, configSetName, Integer.valueOf(numShards), Integer.valueOf(replicationFactor), Integer.valueOf(replicationFactor), Integer.valueOf(replicationFactor));
            this.collectionName = collectionName;
            this.setReplicationFactor(replicationFactor);
        }

        public SolrParams getParams() {
            SolrParams params = super.getParams();
            if (!(params instanceof ModifiableSolrParams)) {
                throw new ClientErrorException("Solr changed and we cannot set custom parameters to the create collection request!");
            }
            ModifiableSolrParams modifiableSolrParams = (ModifiableSolrParams)params;
            modifiableSolrParams.set("collection", new String[]{this.collectionName});
            return params;
        }
    }
}

