/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapitools.builders;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapitools.builders.BaseBuilder;

public abstract class BaseSetBuilder<T extends OWLObject, B, I>
extends BaseBuilder<T, B> {
    protected final Set<I> items = new HashSet<I>();

    @Inject
    public BaseSetBuilder(OWLDataFactory df) {
        super(df);
    }

    public B withItem(I arg) {
        this.items.add(arg);
        return (B)this;
    }

    public B withItems(Collection<? extends I> arg) {
        this.items.addAll(arg);
        return (B)this;
    }

    public B withItems(Stream<? extends I> arg) {
        OWLAPIStreamUtils.add(this.items, arg);
        return (B)this;
    }

    @SafeVarargs
    public final B withItems(I ... arg) {
        I[] IArray = arg;
        int n = arg.length;
        int n2 = 0;
        while (n2 < n) {
            I i = IArray[n2];
            this.items.add(i);
            ++n2;
        }
        return (B)this;
    }
}

