/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.vocab;

import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.model.HasPrefixedName;
import org.semanticweb.owlapi.model.HasShortForm;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.vocab.Namespaces;

public enum OWLFacet implements HasShortForm,
HasIRI,
HasPrefixedName
{
    LENGTH(Namespaces.XSD, "length", "length"),
    MIN_LENGTH(Namespaces.XSD, "minLength", "minLength"),
    MAX_LENGTH(Namespaces.XSD, "maxLength", "maxLength"),
    PATTERN(Namespaces.XSD, "pattern", "pattern"),
    MIN_INCLUSIVE(Namespaces.XSD, "minInclusive", ">="),
    MIN_EXCLUSIVE(Namespaces.XSD, "minExclusive", ">"),
    MAX_INCLUSIVE(Namespaces.XSD, "maxInclusive", "<="),
    MAX_EXCLUSIVE(Namespaces.XSD, "maxExclusive", "<"),
    TOTAL_DIGITS(Namespaces.XSD, "totalDigits", "totalDigits"),
    FRACTION_DIGITS(Namespaces.XSD, "fractionDigits", "fractionDigits"),
    LANG_RANGE(Namespaces.RDF, "langRange", "langRange");

    public static final Map<IRI, OWLFacet> FACET_IRIS;
    private final IRI iri;
    private final String shortForm;
    private final String symbolicForm;
    private final String prefixedName;

    static {
        FACET_IRIS = OWLAPIStreamUtils.asMap(OWLFacet.stream(), HasIRI::getIRI);
    }

    private OWLFacet(Namespaces ns, String shortForm, String symbolicForm) {
        this.iri = IRI.create(ns.toString(), shortForm);
        this.shortForm = shortForm;
        this.symbolicForm = symbolicForm;
        this.prefixedName = ns.getPrefixName() + ":" + shortForm;
    }

    private static Stream<OWLFacet> stream() {
        return Stream.of(OWLFacet.values());
    }

    public static Set<IRI> getFacetIRIs() {
        return FACET_IRIS.keySet();
    }

    public static OWLFacet getFacet(IRI iri) {
        OWLAPIPreconditions.checkNotNull(iri, "iri cannot be null");
        OWLFacet facet = FACET_IRIS.get(iri);
        if (facet == null) {
            throw new IllegalArgumentException("Unknown facet: " + String.valueOf(iri));
        }
        return facet;
    }

    @Nullable
    public static OWLFacet getFacetByShortName(String shortName) {
        OWLAPIPreconditions.checkNotNull(shortName);
        return OWLFacet.stream().filter(v -> v.getShortForm().equals(shortName)).findAny().orElse(null);
    }

    @Nullable
    public static OWLFacet getFacetBySymbolicName(String symbolicName) {
        return OWLFacet.stream().filter(v -> v.getSymbolicForm().equals(symbolicName)).findAny().orElse(null);
    }

    public static Set<String> getFacets() {
        return OWLAPIStreamUtils.asSet(OWLFacet.stream().map(v -> v.getSymbolicForm()));
    }

    @Override
    public String getShortForm() {
        return this.shortForm;
    }

    @Override
    public IRI getIRI() {
        return this.iri;
    }

    public String getSymbolicForm() {
        return this.symbolicForm;
    }

    public String toString() {
        return this.getShortForm();
    }

    @Override
    public String getPrefixedName() {
        return this.prefixedName;
    }
}

