/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLEntityURIConverterStrategy;

public class OWLEntityURIUnderscores2CamelBackConverterStrategy
implements OWLEntityURIConverterStrategy {
    private final Map<IRI, IRI> iriMap = new HashMap<IRI, IRI>();

    private static IRI convert(IRI iri) {
        OWLAPIPreconditions.checkNotNull(iri, "iri cannot be null");
        Optional<String> fragment = iri.getRemainder();
        if (fragment.isPresent()) {
            String base = iri.getNamespace();
            String camelCaseFragment = OWLEntityURIUnderscores2CamelBackConverterStrategy.toCamelCase(fragment.get());
            return IRI.create(base, camelCaseFragment);
        }
        String path = iri.toURI().getPath();
        if (!path.isEmpty()) {
            int index = path.lastIndexOf(47);
            String lastPathElement = path.substring(index + 1, path.length());
            String camelCaseElement = OWLEntityURIUnderscores2CamelBackConverterStrategy.toCamelCase(lastPathElement);
            String iriString = iri.toString();
            String base = iriString.substring(0, iriString.lastIndexOf(47) + 1);
            return IRI.create(base, camelCaseElement);
        }
        return iri;
    }

    private static String toCamelCase(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        boolean nextIsUpperCase = false;
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (ch == '_') {
                nextIsUpperCase = true;
            } else if (nextIsUpperCase) {
                sb.append(Character.toUpperCase(ch));
                nextIsUpperCase = false;
            } else {
                sb.append(ch);
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public IRI getConvertedIRI(@Nonnull OWLEntity entity) {
        IRI convIRI = this.iriMap.get(entity.getIRI());
        if (convIRI == null) {
            convIRI = OWLEntityURIUnderscores2CamelBackConverterStrategy.convert(entity.getIRI());
            this.iriMap.put(entity.getIRI(), convIRI);
        }
        return convIRI;
    }
}

