/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public class OWLEntityRemover
implements OWLEntityVisitor {
    private final List<RemoveAxiom> changes = new ArrayList<RemoveAxiom>();
    private final Collection<OWLOntology> ontologies;

    public OWLEntityRemover(Collection<OWLOntology> ontologies) {
        this(ontologies.stream());
    }

    public OWLEntityRemover(Stream<OWLOntology> ontologies) {
        this.ontologies = OWLAPIStreamUtils.asList(OWLAPIPreconditions.checkNotNull(ontologies, "ontologies cannot be null"));
    }

    public OWLEntityRemover(OWLOntology ontology) {
        this.ontologies = Collections.singleton(OWLAPIPreconditions.checkNotNull(ontology, "ontology cannot be null"));
    }

    public List<RemoveAxiom> getChanges() {
        return new ArrayList<RemoveAxiom>(this.changes);
    }

    public void reset() {
        this.changes.clear();
    }

    private void generateChanges(OWLEntity entity) {
        OWLAPIPreconditions.checkNotNull(entity, "entity cannot be null");
        for (OWLOntology ont : this.ontologies) {
            ont.referencingAxioms(entity).forEach(ax -> {
                boolean bl = this.changes.add(new RemoveAxiom(ont, (OWLAxiom)ax));
            });
            ont.annotationAssertionAxioms(entity.getIRI()).forEach(ax -> {
                boolean bl = this.changes.add(new RemoveAxiom(ont, (OWLAxiom)ax));
            });
        }
    }

    @Override
    public void visit(OWLClass cls) {
        this.generateChanges(cls);
    }

    @Override
    public void visit(OWLDatatype datatype) {
        this.generateChanges(datatype);
    }

    @Override
    public void visit(OWLNamedIndividual individual) {
        this.generateChanges(individual);
    }

    @Override
    public void visit(OWLDataProperty property) {
        this.generateChanges(property);
    }

    @Override
    public void visit(OWLObjectProperty property) {
        this.generateChanges(property);
    }

    @Override
    public void visit(OWLAnnotationProperty property) {
        this.generateChanges(property);
    }
}

