/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import java.io.Serializable;
import java.util.Optional;
import org.semanticweb.owlapi.change.OWLOntologyChangeData;
import org.semanticweb.owlapi.change.OWLOntologyChangeRecord;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.HasSignature;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeVisitor;
import org.semanticweb.owlapi.model.OWLOntologyChangeVisitorEx;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public abstract class OWLOntologyChange
implements HasSignature,
Serializable {
    private final OWLOntology ont;

    public OWLOntologyChange(OWLOntology ont) {
        this.ont = OWLAPIPreconditions.checkNotNull(ont, "ontology must not be null");
    }

    public Optional<OWLAxiom> getAddedOrRemovedAxiom() {
        return Optional.empty();
    }

    public Optional<OWLAxiom> getAddedAxiom() {
        return Optional.empty();
    }

    public Optional<OWLAxiom> getRemovedAxiom() {
        return Optional.empty();
    }

    public boolean isAxiomChange(AxiomType<?> type) {
        return this.getAddedOrRemovedAxiom().filter(ax -> ax.getAxiomType().equals(type)).isPresent();
    }

    public boolean isAxiomChange() {
        return false;
    }

    public boolean isAddAxiom() {
        return false;
    }

    public boolean isRemoveAxiom() {
        return this.isAxiomChange() && !this.isAddAxiom();
    }

    public OWLAxiom getAxiom() {
        throw new UnsupportedOperationException("This is an " + this.getClass().getSimpleName() + ", not an axiom change: " + String.valueOf(this));
    }

    public boolean isImportChange() {
        return false;
    }

    public OWLOntology getOntology() {
        return this.ont;
    }

    public abstract OWLOntologyChangeData getChangeData();

    public OWLOntologyChangeRecord getChangeRecord() {
        return new OWLOntologyChangeRecord(this.ont.getOntologyID(), this.getChangeData());
    }

    public abstract void accept(OWLOntologyChangeVisitor var1);

    public abstract <O> O accept(OWLOntologyChangeVisitorEx<O> var1);

    public abstract OWLOntologyChange reverseChange();
}

